/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.List;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.FunctionExtension;
import org.mariuszgromada.math.mxparser.FunctionExtensionVariadic;
import org.mariuszgromada.math.mxparser.HeadEqBody;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.parsertokens.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Function
extends PrimitiveElement {
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    public static final int NOT_FOUND = -1;
    public static final int TYPE_ID = 103;
    public static final String TYPE_DESC = "User defined function";
    public static final int BODY_RUNTIME = 1;
    public static final int BODY_EXTENDED = 2;
    private int functionBodyType;
    Expression functionExpression;
    private String functionName;
    private String description;
    boolean isVariadic;
    private int parametersNumber;
    private FunctionExtension functionExtension;
    private FunctionExtensionVariadic functionExtensionVariadic;

    public Function(String functionName, String functionExpressionString, PrimitiveElement ... elements) {
        super(103);
        if (mXparser.regexMatch(functionName, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.functionName = functionName;
            this.functionExpression = new Expression(functionExpressionString, elements);
            this.functionExpression.setDescription(functionName);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = false;
            this.parametersNumber = 0;
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else {
            this.parametersNumber = 0;
            this.description = "";
            this.functionExpression = new Expression("", new PrimitiveElement[0]);
            this.functionExpression.setSyntaxStatus(false, "[" + functionName + "]Invalid function name, pattern not matches: " + "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*");
        }
    }

    public Function(String functionName, String functionExpressionString, String ... argumentsNames) {
        super(103);
        if (mXparser.regexMatch(functionName, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.functionName = functionName;
            this.functionExpression = new Expression(functionExpressionString, new PrimitiveElement[0]);
            this.functionExpression.setDescription(functionName);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = false;
            for (String argName : argumentsNames) {
                this.functionExpression.addArguments(new Argument(argName, new PrimitiveElement[0]));
            }
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else {
            this.parametersNumber = 0;
            this.description = "";
            this.functionExpression = new Expression("", new PrimitiveElement[0]);
            this.functionExpression.setSyntaxStatus(false, "[" + functionName + "]Invalid function name, pattern not matches: " + "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*");
        }
    }

    public Function(String functionDefinitionString, PrimitiveElement ... elements) {
        super(103);
        this.parametersNumber = 0;
        if (mXparser.regexMatch(functionDefinitionString, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\(((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*,(\\s)*)*(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(functionDefinitionString);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, elements);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = false;
            if (headEqBody.headTokens.size() > 1) {
                for (int i = 1; i < headEqBody.headTokens.size(); ++i) {
                    Token t = headEqBody.headTokens.get(i);
                    if (t.tokenTypeId == 20) continue;
                    this.functionExpression.addArguments(new Argument(t.tokenStr, new PrimitiveElement[0]));
                }
            }
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else if (mXparser.regexMatch(functionDefinitionString, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\((\\s)*\\.\\.\\.(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(functionDefinitionString);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, elements);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = true;
            this.parametersNumber = -1;
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else {
            this.functionExpression = new Expression(new PrimitiveElement[0]);
            this.functionExpression.setDescription(functionDefinitionString);
            String errorMessage = "";
            errorMessage = errorMessage + "\n [" + functionDefinitionString + "] --> pattern not mathes: f(x1,...,xn) = ... reg exp: " + "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\(((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*,(\\s)*)*(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*";
            this.functionExpression.setSyntaxStatus(false, errorMessage);
        }
    }

    public Function(String functionName, FunctionExtension functionExtension) {
        super(103);
        if (mXparser.regexMatch(functionName, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.functionName = functionName;
            this.functionExpression = new Expression("{body-ext}", new PrimitiveElement[0]);
            this.isVariadic = false;
            this.parametersNumber = functionExtension.getParametersNumber();
            this.description = "";
            this.functionExtension = functionExtension;
            this.functionBodyType = 2;
        } else {
            this.parametersNumber = 0;
            this.description = "";
            this.functionExpression = new Expression("", new PrimitiveElement[0]);
            this.functionExpression.setSyntaxStatus(false, "[" + functionName + "]Invalid function name, pattern not matches: " + "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*");
        }
    }

    public Function(String functionName, FunctionExtensionVariadic functionExtensionVariadic) {
        super(103);
        if (mXparser.regexMatch(functionName, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.functionName = functionName;
            this.functionExpression = new Expression("{body-ext-var}", new PrimitiveElement[0]);
            this.isVariadic = true;
            this.parametersNumber = -1;
            this.description = "";
            this.functionExtensionVariadic = functionExtensionVariadic;
            this.functionBodyType = 2;
        } else {
            this.parametersNumber = 0;
            this.description = "";
            this.functionExpression = new Expression("", new PrimitiveElement[0]);
            this.functionExpression.setSyntaxStatus(false, "[" + functionName + "]Invalid function name, pattern not matches: " + "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*");
        }
    }

    private Function(Function function) {
        super(103);
        this.functionName = function.functionName;
        this.description = function.description;
        this.parametersNumber = function.parametersNumber;
        this.functionExpression = function.functionExpression.clone();
        this.functionBodyType = function.functionBodyType;
        this.isVariadic = function.isVariadic;
        if (this.functionBodyType == 2) {
            if (function.functionExtension != null) {
                this.functionExtension = function.functionExtension.clone();
            }
            if (function.functionExtensionVariadic != null) {
                this.functionExtensionVariadic = function.functionExtensionVariadic.clone();
            }
        }
    }

    public void setFunction(String functionDefinitionString, PrimitiveElement ... elements) {
        this.parametersNumber = 0;
        if (mXparser.regexMatch(functionDefinitionString, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\(((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*,(\\s)*)*(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(functionDefinitionString);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, elements);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = false;
            if (headEqBody.headTokens.size() > 1) {
                for (int i = 1; i < headEqBody.headTokens.size(); ++i) {
                    Token t = headEqBody.headTokens.get(i);
                    if (t.tokenTypeId == 20) continue;
                    this.functionExpression.addArguments(new Argument(t.tokenStr, new PrimitiveElement[0]));
                }
            }
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else if (mXparser.regexMatch(functionDefinitionString, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\((\\s)*\\.\\.\\.(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(functionDefinitionString);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, elements);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = true;
            this.parametersNumber = -1;
            this.description = "";
            this.functionBodyType = 1;
            this.addFunctions(this);
        } else {
            this.functionExpression = new Expression(new PrimitiveElement[0]);
            this.functionExpression.setDescription(functionDefinitionString);
            String errorMessage = "";
            errorMessage = errorMessage + "\n [" + functionDefinitionString + "] --> pattern not mathes: f(x1,...,xn) = ... reg exp: " + "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\(((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*,(\\s)*)*(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*";
            this.functionExpression.setSyntaxStatus(false, errorMessage);
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getFunctionExpressionString() {
        return this.functionExpression.getExpressionString();
    }

    public void setFunctionName(String functionName) {
        if (mXparser.regexMatch(functionName, "([a-zA-Z_])+([a-zA-Z0-9_])*")) {
            this.functionName = functionName;
            this.setExpressionModifiedFlags();
        } else {
            this.functionExpression.setSyntaxStatus(false, "[" + functionName + "]Invalid function name, pattern not matches: " + "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*");
        }
    }

    public void setArgumentValue(int argumentIndex, double argumentValue) {
        if (!this.isVariadic) {
            if (this.functionBodyType == 1) {
                this.functionExpression.argumentsList.get((int)argumentIndex).argumentValue = argumentValue;
            } else if (!this.isVariadic) {
                this.functionExtension.setParameterValue(argumentIndex, argumentValue);
            }
        }
    }

    public int getFunctionBodyType() {
        return this.functionBodyType;
    }

    public boolean checkSyntax() {
        boolean syntaxStatus = true;
        if (this.functionBodyType != 2) {
            syntaxStatus = this.functionExpression.checkSyntax();
        }
        this.checkRecursiveMode();
        return syntaxStatus;
    }

    public String getErrorMessage() {
        return this.functionExpression.getErrorMessage();
    }

    protected Function clone() {
        Function newFunction = new Function(this);
        return newFunction;
    }

    public double calculate() {
        if (this.functionBodyType == 1) {
            return this.functionExpression.calculate();
        }
        if (!this.isVariadic) {
            return this.functionExtension.calculate();
        }
        List<Double> paramsList = this.functionExpression.UDFVariadicParamsAtRunTime;
        if (paramsList != null) {
            int n = paramsList.size();
            double[] parameters = new double[n];
            for (int i = 0; i < n; ++i) {
                parameters[i] = paramsList.get(i);
            }
            return this.functionExtensionVariadic.calculate(parameters);
        }
        return Double.NaN;
    }

    public double calculate(double ... parameters) {
        if (parameters.length > 0) {
            this.functionExpression.UDFVariadicParamsAtRunTime = new ArrayList<Double>();
            for (double x : parameters) {
                this.functionExpression.UDFVariadicParamsAtRunTime.add(x);
            }
        } else {
            return Double.NaN;
        }
        if (this.isVariadic) {
            if (this.functionBodyType == 1) {
                return this.functionExpression.calculate();
            }
            return this.functionExtensionVariadic.calculate(parameters);
        }
        if (parameters.length == this.getParametersNumber()) {
            if (this.functionBodyType == 1) {
                for (int p = 0; p < parameters.length; ++p) {
                    this.setArgumentValue(p, parameters[p]);
                }
                return this.functionExpression.calculate();
            }
            for (int p = 0; p < parameters.length; ++p) {
                this.functionExtension.setParameterValue(p, parameters[p]);
            }
            return this.functionExtension.calculate();
        }
        this.functionExpression.setSyntaxStatus(false, "[" + this.functionName + "] incorrect number of function parameters (expecting " + this.getParametersNumber() + ", provided " + parameters.length + ")!");
        return Double.NaN;
    }

    public double calculate(Argument ... arguments) {
        double[] parameters;
        if (arguments.length > 0) {
            this.functionExpression.UDFVariadicParamsAtRunTime = new ArrayList<Double>();
            parameters = new double[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                double x = arguments[i].getArgumentValue();
                this.functionExpression.UDFVariadicParamsAtRunTime.add(x);
                parameters[i] = x;
            }
        } else {
            return Double.NaN;
        }
        if (this.isVariadic) {
            if (this.functionBodyType == 1) {
                return this.functionExpression.calculate();
            }
            return this.functionExtensionVariadic.calculate(parameters);
        }
        if (arguments.length == this.getParametersNumber()) {
            if (this.functionBodyType == 1) {
                for (int p = 0; p < arguments.length; ++p) {
                    this.setArgumentValue(p, arguments[p].getArgumentValue());
                }
                return this.functionExpression.calculate();
            }
            for (int p = 0; p < arguments.length; ++p) {
                this.functionExtension.setParameterValue(p, arguments[p].getArgumentValue());
            }
            return this.functionExtension.calculate();
        }
        this.functionExpression.setSyntaxStatus(false, "[" + this.functionName + "] incorrect number of function parameters (expecting " + this.getParametersNumber() + ", provided " + arguments.length + ")!");
        return Double.NaN;
    }

    public void addDefinitions(PrimitiveElement ... elements) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addDefinitions(elements);
        }
    }

    public void removeDefinitions(PrimitiveElement ... elements) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeDefinitions(elements);
        }
    }

    private int countRecursiveArguments() {
        int numOfRecursiveArguments = 0;
        if (this.functionBodyType == 1) {
            for (Argument argument : this.functionExpression.argumentsList) {
                if (argument.getArgumentType() != 3) continue;
                ++numOfRecursiveArguments;
            }
        }
        return numOfRecursiveArguments;
    }

    public void addArguments(Argument ... arguments) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addArguments(arguments);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
        }
    }

    public void defineArguments(String ... argumentsNames) {
        if (this.functionBodyType == 1) {
            this.functionExpression.defineArguments(argumentsNames);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
        }
    }

    public void defineArgument(String argumentName, double argumentValue) {
        if (this.functionBodyType == 1) {
            this.functionExpression.defineArgument(argumentName, argumentValue);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
        }
    }

    public int getArgumentIndex(String argumentName) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getArgumentIndex(argumentName);
        }
        return -1;
    }

    public Argument getArgument(String argumentName) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getArgument(argumentName);
        }
        return null;
    }

    public Argument getArgument(int argumentIndex) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getArgument(argumentIndex);
        }
        return null;
    }

    public int getParametersNumber() {
        if (!this.isVariadic) {
            return this.parametersNumber;
        }
        if (this.functionExpression.UDFVariadicParamsAtRunTime != null) {
            return this.functionExpression.UDFVariadicParamsAtRunTime.size();
        }
        return -1;
    }

    public void setParametersNumber(int parametersNumber) {
        if (this.functionBodyType == 1) {
            this.parametersNumber = parametersNumber;
            this.functionExpression.setExpressionModifiedFlag();
        }
    }

    public String getParameterName(int parameterIndex) {
        if (parameterIndex < 0) {
            return "";
        }
        if (parameterIndex >= this.parametersNumber) {
            return "";
        }
        if (this.functionBodyType == 1) {
            return this.getArgument(parameterIndex).getArgumentName();
        }
        if (this.functionBodyType == 2) {
            return this.functionExtension.getParameterName(parameterIndex);
        }
        return "";
    }

    public int getArgumentsNumber() {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getArgumentsNumber();
        }
        return 0;
    }

    public void removeArguments(String ... argumentsNames) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeArguments(argumentsNames);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
        }
    }

    public void removeArguments(Argument ... arguments) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeArguments(arguments);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
        }
    }

    public void removeAllArguments() {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeAllArguments();
            this.parametersNumber = 0;
        }
    }

    public void addConstants(Constant ... constants) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addConstants(constants);
        }
    }

    public void addConstants(List<Constant> constantsList) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addConstants(constantsList);
        }
    }

    public void defineConstant(String constantName, double constantValue) {
        if (this.functionBodyType == 1) {
            this.functionExpression.defineConstant(constantName, constantValue);
        }
    }

    public int getConstantIndex(String constantName) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getConstantIndex(constantName);
        }
        return -1;
    }

    public Constant getConstant(String constantName) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getConstant(constantName);
        }
        return null;
    }

    public Constant getConstant(int constantIndex) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getConstant(constantIndex);
        }
        return null;
    }

    public int getConstantsNumber() {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getConstantsNumber();
        }
        return 0;
    }

    public void removeConstants(String ... constantsNames) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeConstants(constantsNames);
        }
    }

    public void removeConstants(Constant ... constants) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeConstants(constants);
        }
    }

    public void removeAllConstants() {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeAllConstants();
        }
    }

    public void addFunctions(Function ... functions) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addFunctions(functions);
        }
    }

    public void defineFunction(String functionName, String functionExpressionString, String ... argumentsNames) {
        if (this.functionBodyType == 1) {
            this.functionExpression.defineFunction(functionName, functionExpressionString, argumentsNames);
        }
    }

    public int getFunctionIndex(String functionName) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getFunctionIndex(functionName);
        }
        return -1;
    }

    public Function getFunction(String functionName) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getFunction(functionName);
        }
        return null;
    }

    public Function getFunction(int functionIndex) {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getFunction(functionIndex);
        }
        return null;
    }

    public int getFunctionsNumber() {
        if (this.functionBodyType == 1) {
            return this.functionExpression.getFunctionsNumber();
        }
        return 0;
    }

    public void removeFunctions(String ... functionsNames) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeFunctions(functionsNames);
        }
    }

    public void removeFunctions(Function ... functions) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeFunctions(functions);
        }
    }

    public void removeAllFunctions() {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeAllFunctions();
        }
    }

    public void setVerboseMode() {
        this.functionExpression.setVerboseMode();
    }

    public void setSilentMode() {
        this.functionExpression.setSilentMode();
    }

    public boolean getVerboseMode() {
        return this.functionExpression.getVerboseMode();
    }

    void checkRecursiveMode() {
        if (this.functionBodyType == 1) {
            List<Token> functionExpressionTokens = this.functionExpression.getInitialTokens();
            this.functionExpression.disableRecursiveMode();
            if (functionExpressionTokens != null) {
                for (Token t : functionExpressionTokens) {
                    if (!t.tokenStr.equals(this.functionName)) continue;
                    this.functionExpression.setRecursiveMode();
                    break;
                }
            }
        }
    }

    public boolean getRecursiveMode() {
        return this.functionExpression.getRecursiveMode();
    }

    public double getComputingTime() {
        return this.functionExpression.getComputingTime();
    }

    void addRelatedExpression(Expression expression) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addRelatedExpression(expression);
        }
    }

    void removeRelatedExpression(Expression expression) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeRelatedExpression(expression);
        }
    }

    void setExpressionModifiedFlags() {
        if (this.functionBodyType == 1) {
            this.functionExpression.setExpressionModifiedFlag();
        }
    }
}

