/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.IllegalStateException;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.pool2.KeyedPooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericKeyedObjectPool;
import org.apache.commons.pool2.impl.GenericKeyedObjectPoolConfig;
import org.messaginghub.pooled.jms.JmsPoolConnection;
import org.messaginghub.pooled.jms.JmsPoolJMSContext;
import org.messaginghub.pooled.jms.pool.PooledConnection;
import org.messaginghub.pooled.jms.pool.PooledConnectionKey;
import org.messaginghub.pooled.jms.util.JMSExceptionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsPoolConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(JmsPoolConnectionFactory.class);
    public static final int DEFAULT_MAX_CONNECTIONS = 1;
    protected final AtomicBoolean stopped = new AtomicBoolean(false);
    private GenericKeyedObjectPool<PooledConnectionKey, PooledConnection> connectionsPool;
    protected Object connectionFactory;
    private int maxSessionsPerConnection = 500;
    private int connectionIdleTimeout = 30000;
    private boolean blockIfSessionPoolIsFull = true;
    private long blockIfSessionPoolIsFullTimeout = -1L;
    private boolean useAnonymousProducers = true;
    private int explicitProducerCacheSize = 0;
    private boolean useProviderJMSContext = false;
    private final AtomicReference<PooledConnection> mostRecentlyCreated = new AtomicReference<Object>(null);

    public void initConnectionsPool() {
        if (this.connectionsPool == null) {
            GenericKeyedObjectPoolConfig poolConfig = new GenericKeyedObjectPoolConfig();
            poolConfig.setJmxEnabled(false);
            this.connectionsPool = new GenericKeyedObjectPool((KeyedPooledObjectFactory)new KeyedPooledObjectFactory<PooledConnectionKey, PooledConnection>(){

                public PooledObject<PooledConnection> makeObject(PooledConnectionKey connectionKey) throws Exception {
                    Connection delegate = JmsPoolConnectionFactory.this.createProviderConnection(connectionKey);
                    PooledConnection connection = JmsPoolConnectionFactory.this.createPooledConnection(delegate);
                    connection.setIdleTimeout(JmsPoolConnectionFactory.this.getConnectionIdleTimeout());
                    connection.setMaxSessionsPerConnection(JmsPoolConnectionFactory.this.getMaxSessionsPerConnection());
                    connection.setBlockIfSessionPoolIsFull(JmsPoolConnectionFactory.this.isBlockIfSessionPoolIsFull());
                    if (JmsPoolConnectionFactory.this.isBlockIfSessionPoolIsFull() && JmsPoolConnectionFactory.this.getBlockIfSessionPoolIsFullTimeout() > 0L) {
                        connection.setBlockIfSessionPoolIsFullTimeout(JmsPoolConnectionFactory.this.getBlockIfSessionPoolIsFullTimeout());
                    }
                    connection.setUseAnonymousProducers(JmsPoolConnectionFactory.this.isUseAnonymousProducers());
                    connection.setExplicitProducerCacheSize(JmsPoolConnectionFactory.this.getExplicitProducerCacheSize());
                    LOG.trace("Created new connection: {}", (Object)connection);
                    JmsPoolConnectionFactory.this.mostRecentlyCreated.set(connection);
                    return new DefaultPooledObject((Object)connection);
                }

                public void destroyObject(PooledConnectionKey connectionKey, PooledObject<PooledConnection> pooledObject) throws Exception {
                    PooledConnection connection = (PooledConnection)pooledObject.getObject();
                    try {
                        LOG.trace("Destroying connection: {}", (Object)connection);
                        connection.close();
                    }
                    catch (Exception e) {
                        LOG.warn("Close connection failed for connection: " + connection + ". This exception will be ignored.", (Throwable)e);
                    }
                }

                public boolean validateObject(PooledConnectionKey connectionKey, PooledObject<PooledConnection> pooledObject) {
                    PooledConnection connection = (PooledConnection)pooledObject.getObject();
                    if (connection == null || connection.idleTimeoutCheck() || connection.isClosed()) {
                        LOG.trace("Connection has expired or was closed: {} and will be destroyed", (Object)connection);
                        return false;
                    }
                    try {
                        connection.getConnection().getExceptionListener();
                    }
                    catch (IllegalStateException jmsISE) {
                        return false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }

                public void activateObject(PooledConnectionKey connectionKey, PooledObject<PooledConnection> pooledObject) throws Exception {
                }

                public void passivateObject(PooledConnectionKey connectionKey, PooledObject<PooledConnection> pooledObject) throws Exception {
                }
            }, poolConfig);
            this.connectionsPool.setMaxIdlePerKey(1);
            this.connectionsPool.setLifo(false);
            this.connectionsPool.setMinIdlePerKey(1);
            this.connectionsPool.setBlockWhenExhausted(false);
            this.connectionsPool.setTestOnBorrow(true);
            this.connectionsPool.setTestWhileIdle(true);
        }
    }

    public Object getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(Object factory) {
        if (!(factory instanceof ConnectionFactory)) {
            throw new IllegalArgumentException("connectionFactory should implement jakarta.jms.ConnectionFactory");
        }
        this.connectionFactory = factory;
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String userName, String password) throws JMSException {
        return (QueueConnection)this.createConnection(userName, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        return (TopicConnection)this.createConnection(userName, password);
    }

    public Connection createConnection() throws JMSException {
        return this.createConnection(null, null);
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createJmsPoolConnection(userName, password);
    }

    public JMSContext createContext() {
        return this.createContext(null, null, 1);
    }

    public JMSContext createContext(int sessionMode) {
        return this.createContext(null, null, sessionMode);
    }

    public JMSContext createContext(String username, String password) {
        return this.createContext(username, password, 1);
    }

    public JMSContext createContext(String username, String password, int sessionMode) {
        if (this.stopped.get()) {
            LOG.debug("JmsPoolConnectionFactory is stopped, skip create new connection.");
            return null;
        }
        if (this.isUseProviderJMSContext()) {
            return this.createProviderContext(username, password, sessionMode);
        }
        try {
            return this.newPooledConnectionContext(this.createJmsPoolConnection(username, password), sessionMode);
        }
        catch (JMSException e) {
            throw JMSExceptionSupport.createRuntimeException((Exception)((Object)e));
        }
    }

    public void start() {
        LOG.debug("Starting the JmsPoolConnectionFactory.");
        this.stopped.set(false);
    }

    public void stop() {
        if (this.stopped.compareAndSet(false, true)) {
            LOG.debug("Stopping the JmsPoolConnectionFactory, number of connections in cache: {}", (Object)(this.connectionsPool != null ? this.connectionsPool.getNumActive() : 0));
            try {
                if (this.connectionsPool != null) {
                    this.connectionsPool.close();
                    this.connectionsPool = null;
                }
            }
            catch (Exception ignored) {
                LOG.trace("Caught exception on close of the Connection pool: ", (Throwable)ignored);
            }
        }
    }

    public void clear() {
        if (this.stopped.get()) {
            return;
        }
        this.getConnectionsPool().clear();
    }

    public int getMaxSessionsPerConnection() {
        return this.maxSessionsPerConnection;
    }

    public void setMaxSessionsPerConnection(int maxSessionsPerConnection) {
        this.maxSessionsPerConnection = maxSessionsPerConnection;
    }

    public void setBlockIfSessionPoolIsFull(boolean block) {
        this.blockIfSessionPoolIsFull = block;
    }

    public boolean isBlockIfSessionPoolIsFull() {
        return this.blockIfSessionPoolIsFull;
    }

    public int getMaxConnections() {
        return this.getConnectionsPool().getMaxIdlePerKey();
    }

    public void setMaxConnections(int maxConnections) {
        this.getConnectionsPool().setMaxIdlePerKey(maxConnections);
        this.getConnectionsPool().setMaxTotalPerKey(maxConnections);
    }

    public int getConnectionIdleTimeout() {
        return this.connectionIdleTimeout;
    }

    public void setConnectionIdleTimeout(int connectionIdleTimeout) {
        this.connectionIdleTimeout = connectionIdleTimeout;
    }

    public boolean isUseAnonymousProducers() {
        return this.useAnonymousProducers;
    }

    public void setUseAnonymousProducers(boolean value) {
        this.useAnonymousProducers = value;
    }

    public int getExplicitProducerCacheSize() {
        return this.explicitProducerCacheSize;
    }

    public void setExplicitProducerCacheSize(int cacheSize) {
        this.explicitProducerCacheSize = cacheSize;
    }

    public void setConnectionCheckInterval(long connectionCheckInterval) {
        this.getConnectionsPool().setTimeBetweenEvictionRuns(Duration.ofMillis(connectionCheckInterval));
    }

    public long getConnectionCheckInterval() {
        return this.getConnectionsPool().getDurationBetweenEvictionRuns().toMillis();
    }

    public int getNumConnections() {
        return this.getConnectionsPool().getNumIdle();
    }

    public long getBlockIfSessionPoolIsFullTimeout() {
        return this.blockIfSessionPoolIsFullTimeout;
    }

    public void setBlockIfSessionPoolIsFullTimeout(long blockIfSessionPoolIsFullTimeout) {
        this.blockIfSessionPoolIsFullTimeout = blockIfSessionPoolIsFullTimeout;
    }

    public boolean isUseProviderJMSContext() {
        return this.useProviderJMSContext;
    }

    public void setUseProviderJMSContext(boolean useProviderJMSContext) {
        this.useProviderJMSContext = useProviderJMSContext;
    }

    protected GenericKeyedObjectPool<PooledConnectionKey, PooledConnection> getConnectionsPool() {
        this.initConnectionsPool();
        return this.connectionsPool;
    }

    protected PooledConnection createPooledConnection(Connection connection) {
        return new PooledConnection(connection);
    }

    protected JmsPoolConnection newPooledConnectionWrapper(PooledConnection connection) {
        return new JmsPoolConnection(connection);
    }

    protected JmsPoolJMSContext newPooledConnectionContext(JmsPoolConnection connection, int sessionMode) {
        return new JmsPoolJMSContext(connection, sessionMode);
    }

    protected Connection createProviderConnection(PooledConnectionKey key) throws JMSException {
        if (this.connectionFactory instanceof ConnectionFactory) {
            if (key.getUserName() == null && key.getPassword() == null) {
                return ((ConnectionFactory)this.connectionFactory).createConnection();
            }
            return ((ConnectionFactory)this.connectionFactory).createConnection(key.getUserName(), key.getPassword());
        }
        throw new IllegalStateException("connectionFactory should implement jakarta.jms.ConnectionFactory");
    }

    protected JMSContext createProviderContext(String username, String password, int sessionMode) {
        if (this.connectionFactory instanceof ConnectionFactory) {
            if (username == null && password == null) {
                return ((ConnectionFactory)this.connectionFactory).createContext(sessionMode);
            }
            return ((ConnectionFactory)this.connectionFactory).createContext(username, password, sessionMode);
        }
        throw new IllegalStateRuntimeException("connectionFactory should implement jakarta.jms.ConnectionFactory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized JmsPoolConnection createJmsPoolConnection(String userName, String password) throws JMSException {
        if (this.stopped.get()) {
            LOG.debug("JmsPoolConnectionFactory is stopped, skip create new connection.");
            return null;
        }
        if (this.connectionFactory == null) {
            throw new IllegalStateException("No ConnectionFactory instance has been configured");
        }
        int exhaustionRecoverAttemptLimit = 10;
        PooledConnection connection = null;
        PooledConnectionKey key = new PooledConnectionKey(userName, password);
        if (this.getConnectionsPool().getNumIdle((Object)key) < this.getMaxConnections()) {
            try {
                this.connectionsPool.addObject((Object)key);
                connection = this.mostRecentlyCreated.getAndSet(null);
                connection.incrementReferenceCount();
                return this.newPooledConnectionWrapper(connection);
            }
            catch (Exception e) {
                throw JMSExceptionSupport.create("Error while attempting to add new Connection to the pool", e);
            }
        }
        try {
            int exhaustedPoolRecoveryAttempts = 0;
            while (connection == null) {
                try {
                    connection = (PooledConnection)this.connectionsPool.borrowObject((Object)key);
                }
                catch (NoSuchElementException nse) {
                    if (exhaustedPoolRecoveryAttempts++ >= 10) throw JMSExceptionSupport.createResourceAllocationException(nse);
                    LOG.trace("Recover attempt {} from exhausted pool by refilling pool key and creating new Connection", (Object)exhaustedPoolRecoveryAttempts);
                    this.connectionsPool.addObject((Object)key);
                    continue;
                }
                PooledConnection pooledConnection = connection;
                synchronized (pooledConnection) {
                    if (connection.isClosed()) {
                        this.connectionsPool.returnObject((Object)key, (Object)connection);
                        connection = null;
                    } else {
                        connection.incrementReferenceCount();
                    }
                }
            }
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Error while attempting to retrieve a connection from the pool", e);
        }
        try {
            this.connectionsPool.returnObject((Object)key, (Object)connection);
            return this.newPooledConnectionWrapper(connection);
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Error when returning connection to the pool", e);
        }
    }

    protected void populateProperties(Properties props) {
        props.setProperty("maxSessionsPerConnection", Integer.toString(this.getMaxSessionsPerConnection()));
        props.setProperty("maxConnections", Integer.toString(this.getMaxConnections()));
        props.setProperty("connectionIdleTimeout", Integer.toString(this.getConnectionIdleTimeout()));
        props.setProperty("connectionCheckInterval", Long.toString(this.getConnectionCheckInterval()));
        props.setProperty("useAnonymousProducers", Boolean.toString(this.isUseAnonymousProducers()));
        props.setProperty("blockIfSessionPoolIsFull", Boolean.toString(this.isBlockIfSessionPoolIsFull()));
        props.setProperty("blockIfSessionPoolIsFullTimeout", Long.toString(this.getBlockIfSessionPoolIsFullTimeout()));
        props.setProperty("useProviderJMSContext", Boolean.toString(this.isUseProviderJMSContext()));
    }
}

