/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionConsumer;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.messaginghub.pooled.jms.JmsPoolSession;
import org.messaginghub.pooled.jms.JmsPoolSessionEventListener;
import org.messaginghub.pooled.jms.pool.PooledConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsPoolConnection
implements TopicConnection,
QueueConnection,
JmsPoolSessionEventListener,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(JmsPoolConnection.class);
    protected PooledConnection connection;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final List<TemporaryQueue> connTempQueues = new CopyOnWriteArrayList<TemporaryQueue>();
    private final List<TemporaryTopic> connTempTopics = new CopyOnWriteArrayList<TemporaryTopic>();
    private final List<JmsPoolSession> loanedSessions = new CopyOnWriteArrayList<JmsPoolSession>();

    public JmsPoolConnection(PooledConnection pool) {
        this.connection = pool;
    }

    @Override
    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.cleanupAllLoanedSessions();
            this.cleanupConnectionTemporaryDestinations();
            if (this.connection != null) {
                this.connection.decrementReferenceCount();
                this.connection = null;
            }
        }
    }

    public void start() throws JMSException {
        this.checkClosed();
        this.connection.start();
    }

    public void stop() throws JMSException {
        this.checkClosed();
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        return this.getConnection().getMetaData();
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this.connection.getParentExceptionListener();
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.checkClosed();
        this.connection.setParentExceptionListener(exceptionListener);
    }

    public String getClientID() throws JMSException {
        return this.getConnection().getClientID();
    }

    public void setClientID(String clientID) throws JMSException {
        if (this.getConnection().getClientID() == null || !this.getClientID().equals(clientID)) {
            this.getConnection().setClientID(clientID);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer(destination, selector, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String s, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer((Destination)topic, s, serverSessionPool, maxMessages);
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String selector, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        return this.getConnection().createDurableConnectionConsumer(topic, selector, s1, serverSessionPool, i);
    }

    public ConnectionConsumer createSharedDurableConnectionConsumer(Topic topic, String subscriptionName, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.connection.checkClientJMSVersionSupport(2, 0);
        return this.getConnection().createSharedDurableConnectionConsumer(topic, subscriptionName, selector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createSharedConnectionConsumer(Topic topic, String subscriptionName, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.connection.checkClientJMSVersionSupport(2, 0);
        return this.getConnection().createSharedConnectionConsumer(topic, subscriptionName, selector, sessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String selector, ServerSessionPool serverSessionPool, int maxMessages) throws JMSException {
        return this.getConnection().createConnectionConsumer((Destination)queue, selector, serverSessionPool, maxMessages);
    }

    public QueueSession createQueueSession(boolean transacted, int ackMode) throws JMSException {
        return (QueueSession)this.createSession(transacted, ackMode);
    }

    public TopicSession createTopicSession(boolean transacted, int ackMode) throws JMSException {
        return (TopicSession)this.createSession(transacted, ackMode);
    }

    public Session createSession() throws JMSException {
        return this.createSession(false, 1);
    }

    public Session createSession(int sessionMode) throws JMSException {
        return this.createSession(sessionMode == 0, sessionMode);
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        this.checkClosed();
        JmsPoolSession result = (JmsPoolSession)this.connection.createSession(transacted, ackMode);
        this.loanedSessions.add(result);
        result.addSessionEventListener(this);
        return result;
    }

    @Override
    public void onTemporaryQueueCreate(TemporaryQueue tempQueue) {
        this.connTempQueues.add(tempQueue);
    }

    @Override
    public void onTemporaryTopicCreate(TemporaryTopic tempTopic) {
        this.connTempTopics.add(tempTopic);
    }

    @Override
    public void onSessionClosed(JmsPoolSession session) {
        this.loanedSessions.remove(session);
    }

    public Connection getConnection() throws JMSException {
        this.checkClosed();
        return this.connection.getConnection();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { " + this.connection + " }";
    }

    protected void cleanupConnectionTemporaryDestinations() {
        for (TemporaryQueue tempQueue : this.connTempQueues) {
            try {
                tempQueue.delete();
            }
            catch (JMSException ex) {
                LOG.info("failed to delete Temporary Queue \"" + tempQueue.toString() + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.connTempQueues.clear();
        for (TemporaryTopic tempTopic : this.connTempTopics) {
            try {
                tempTopic.delete();
            }
            catch (JMSException ex) {
                LOG.info("failed to delete Temporary Topic \"" + tempTopic.toString() + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.connTempTopics.clear();
    }

    protected void cleanupAllLoanedSessions() {
        for (JmsPoolSession session : this.loanedSessions) {
            try {
                session.close();
            }
            catch (JMSException ex) {
                LOG.info("failed to close loaned Session \"" + session + "\" on closing pooled connection: " + ex.getMessage());
            }
        }
        this.loanedSessions.clear();
    }

    public int getNumSessions() throws JMSException {
        this.checkClosed();
        return this.connection.getNumSessions();
    }

    public int getNumActiveSessions() throws JMSException {
        this.checkClosed();
        return this.connection.getNumActiveSessions();
    }

    public int getNumtIdleSessions() throws JMSException {
        this.checkClosed();
        return this.connection.getNumIdleSessions();
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("Connection closed");
        }
    }
}

