/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.registry;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.registry.MappingsRegistry;
import org.milyn.edisax.util.EDIUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMappingsRegistry
implements MappingsRegistry {
    protected final Map<String, EdifactModel> content = new LinkedHashMap<String, EdifactModel>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EdifactModel getMappingModel(String messageName, Delimiters delimiters) throws EDIConfigurationException, SAXException, IOException {
        String[] nameComponents = EDIUtils.split(messageName, delimiters.getComponent(), delimiters.getEscape());
        StringBuilder lookupNameBuilder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (i > 0) {
                lookupNameBuilder.append(':');
            }
            lookupNameBuilder.append(nameComponents[i]);
        }
        String lookupName = lookupNameBuilder.toString().trim();
        EdifactModel result = this.content.get(lookupName);
        if (result == null) {
            Map<String, EdifactModel> map = this.content;
            synchronized (map) {
                result = this.content.get(lookupName);
                if (result == null) {
                    this.content.putAll(this.demandLoading(nameComponents));
                }
            }
            result = this.content.get(lookupName);
            if (result != null) {
                return result;
            }
        } else {
            return result;
        }
        throw new EDIConfigurationException("Mapping Model '" + messageName + "' not found in supplied set of Mapping model.");
    }

    protected abstract Map<String, EdifactModel> demandLoading(String[] var1) throws EDIConfigurationException, IOException, SAXException;
}

