/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.fixedlength;

import java.nio.charset.Charset;
import java.util.List;
import org.milyn.GenericReaderConfigurator;
import org.milyn.ReaderConfigurator;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.fixedlength.FixedLengthBinding;
import org.milyn.fixedlength.FixedLengthBindingType;
import org.milyn.fixedlength.FixedLengthReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedLengthReaderConfigurator
implements ReaderConfigurator {
    private String fields;
    private boolean lineNumber = false;
    private int skipLines = 0;
    private Charset encoding = Charset.forName("UTF-8");
    private String rootElementName = "set";
    private String recordElementName = "record";
    private String lineNumberAttributeName = "number";
    private String truncatedAttributeName = "truncated";
    private FixedLengthBinding binding;
    private String targetProfile;
    private boolean indent = false;
    private boolean strict = true;

    public FixedLengthReaderConfigurator(String fields) {
        AssertArgument.isNotNullAndNotEmpty(fields, "fields");
        this.fields = fields;
    }

    public FixedLengthReaderConfigurator setSkipLines(int skipLines) {
        this.skipLines = skipLines;
        return this;
    }

    public FixedLengthReaderConfigurator setEncoding(Charset encoding) {
        AssertArgument.isNotNull(encoding, "encoding");
        this.encoding = encoding;
        return this;
    }

    public FixedLengthReaderConfigurator setRootElementName(String rootElementName) {
        AssertArgument.isNotNullAndNotEmpty(rootElementName, "rootElementName");
        this.rootElementName = rootElementName;
        return this;
    }

    public FixedLengthReaderConfigurator setRecordElementName(String recordElementName) {
        AssertArgument.isNotNullAndNotEmpty(recordElementName, "recordElementName");
        this.recordElementName = recordElementName;
        return this;
    }

    public FixedLengthReaderConfigurator setLineNumberAttributeName(String lineNumberAttributeName) {
        AssertArgument.isNotNullAndNotEmpty(lineNumberAttributeName, "lineNumberAttributeName");
        this.lineNumberAttributeName = lineNumberAttributeName;
        return this;
    }

    public FixedLengthReaderConfigurator setTruncatedAttributeName(String truncatedAttributeName) {
        AssertArgument.isNotNullAndNotEmpty(truncatedAttributeName, "truncatedAttributeName");
        this.truncatedAttributeName = truncatedAttributeName;
        return this;
    }

    public FixedLengthReaderConfigurator setIndent(boolean indent) {
        this.indent = indent;
        return this;
    }

    public FixedLengthReaderConfigurator setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public FixedLengthReaderConfigurator setBinding(FixedLengthBinding binding) {
        this.binding = binding;
        return this;
    }

    public FixedLengthReaderConfigurator setLineNumber(boolean lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    public FixedLengthReaderConfigurator setTargetProfile(String targetProfile) {
        AssertArgument.isNotNullAndNotEmpty(targetProfile, "targetProfile");
        this.targetProfile = targetProfile;
        return this;
    }

    @Override
    public List<SmooksResourceConfiguration> toConfig() {
        GenericReaderConfigurator configurator = new GenericReaderConfigurator(FixedLengthReader.class);
        configurator.getParameters().setProperty("fields", this.fields);
        configurator.getParameters().setProperty("lineNumber", Boolean.toString(this.lineNumber));
        configurator.getParameters().setProperty("skipLines", Integer.toString(this.skipLines));
        configurator.getParameters().setProperty("encoding", this.encoding.name());
        configurator.getParameters().setProperty("rootElementName", this.rootElementName);
        configurator.getParameters().setProperty("recordElementName", this.recordElementName);
        configurator.getParameters().setProperty("lineNumberAttributeName", this.lineNumberAttributeName);
        configurator.getParameters().setProperty("truncatedAttributeName", this.truncatedAttributeName);
        configurator.getParameters().setProperty("indent", Boolean.toString(this.indent));
        configurator.getParameters().setProperty("strict", Boolean.toString(this.strict));
        if (this.binding != null) {
            configurator.getParameters().setProperty("bindBeanId", this.binding.getBeanId());
            configurator.getParameters().setProperty("bindBeanClass", this.binding.getBeanClass().getName());
            configurator.getParameters().setProperty("bindingType", this.binding.getBindingType().toString());
            if (this.binding.getBindingType() == FixedLengthBindingType.MAP) {
                if (this.binding.getKeyField() == null) {
                    throw new SmooksConfigurationException("Fixed length 'MAP' Binding must specify a 'keyField' property on the binding configuration.");
                }
                configurator.getParameters().setProperty("bindMapKeyField", this.binding.getKeyField());
            }
        }
        configurator.setTargetProfile(this.targetProfile);
        return configurator.toConfig();
    }
}

