/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import com.google.common.collect.ImmutableList;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.awt.Desktop;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.authentication.AuthenticationException;
import org.mockserver.client.ClientException;
import org.mockserver.client.ForwardChainExpectation;
import org.mockserver.client.MockServerEventBus;
import org.mockserver.closurecallback.websocketregistry.LocalCallbackRegistry;
import org.mockserver.configuration.ClientConfiguration;
import org.mockserver.configuration.Configuration;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.httpclient.NettyHttpClient;
import org.mockserver.httpclient.SocketConnectionException;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.HttpState;
import org.mockserver.mock.OpenAPIExpectation;
import org.mockserver.model.ClearType;
import org.mockserver.model.ExpectationId;
import org.mockserver.model.Format;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.model.LogEventRequestAndResponse;
import org.mockserver.model.MediaType;
import org.mockserver.model.PortBinding;
import org.mockserver.model.RequestDefinition;
import org.mockserver.model.RetrieveType;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.serialization.ExpectationIdSerializer;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.serialization.LogEventRequestAndResponseSerializer;
import org.mockserver.serialization.OpenAPIExpectationSerializer;
import org.mockserver.serialization.PortBindingSerializer;
import org.mockserver.serialization.RequestDefinitionSerializer;
import org.mockserver.serialization.VerificationSequenceSerializer;
import org.mockserver.serialization.VerificationSerializer;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.mockserver.socket.tls.PEMToFile;
import org.mockserver.stop.Stoppable;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.mockserver.verify.VerificationTimes;
import org.mockserver.version.Version;
import org.slf4j.event.Level;

public class MockServerClient
implements Stoppable {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(MockServerClient.class);
    private static final Map<Integer, MockServerEventBus> EVENT_BUS_MAP = new ConcurrentHashMap<Integer, MockServerEventBus>();
    private final EventLoopGroup eventLoopGroup;
    private final String host;
    private final String contextPath;
    private final Class<MockServerClient> clientClass;
    protected CompletableFuture<Integer> portFuture;
    private Boolean secure;
    private Integer port;
    private HttpRequest requestOverride;
    private ClientConfiguration configuration;
    private ProxyConfiguration proxyConfiguration;
    private Supplier<String> controlPlaneJWTSupplier;
    private NettyHttpClient nettyHttpClient;
    private RequestDefinitionSerializer requestDefinitionSerializer = new RequestDefinitionSerializer(MOCK_SERVER_LOGGER);
    private ExpectationIdSerializer expectationIdSerializer = new ExpectationIdSerializer(MOCK_SERVER_LOGGER);
    private LogEventRequestAndResponseSerializer httpRequestResponseSerializer = new LogEventRequestAndResponseSerializer(MOCK_SERVER_LOGGER);
    private PortBindingSerializer portBindingSerializer = new PortBindingSerializer(MOCK_SERVER_LOGGER);
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer(MOCK_SERVER_LOGGER);
    private OpenAPIExpectationSerializer openAPIExpectationSerializer = new OpenAPIExpectationSerializer(MOCK_SERVER_LOGGER);
    private VerificationSerializer verificationSerializer = new VerificationSerializer(MOCK_SERVER_LOGGER);
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer(MOCK_SERVER_LOGGER);
    private final CompletableFuture<MockServerClient> stopFuture = new CompletableFuture();

    public MockServerClient(Configuration configuration, CompletableFuture<Integer> portFuture) {
        this(ClientConfiguration.clientConfiguration((Configuration)configuration), portFuture);
    }

    public MockServerClient(ClientConfiguration configuration, CompletableFuture<Integer> portFuture) {
        if (configuration == null) {
            configuration = ClientConfiguration.clientConfiguration();
        }
        this.clientClass = MockServerClient.class;
        this.host = "127.0.0.1";
        this.portFuture = portFuture;
        this.contextPath = "";
        this.configuration = configuration;
        this.eventLoopGroup = this.eventLoopGroup();
        LocalCallbackRegistry.setMaxWebSocketExpectations((int)configuration.maxWebSocketExpectations());
    }

    public MockServerClient(String host, int port) {
        this(host, port, "");
    }

    public MockServerClient(Configuration configuration, String host, int port) {
        this(configuration, host, port, "");
    }

    public MockServerClient(ClientConfiguration configuration, String host, int port) {
        this(configuration, host, port, "");
    }

    public MockServerClient(String host, int port, String contextPath) {
        this.clientClass = MockServerClient.class;
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Host can not be null or empty");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("ContextPath can not be null");
        }
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
        this.configuration = ClientConfiguration.clientConfiguration();
        this.eventLoopGroup = this.eventLoopGroup();
        LocalCallbackRegistry.setMaxWebSocketExpectations((int)this.configuration.maxWebSocketExpectations());
    }

    public MockServerClient(Configuration configuration, String host, int port, String contextPath) {
        this(ClientConfiguration.clientConfiguration((Configuration)configuration), host, port, contextPath);
    }

    public MockServerClient(ClientConfiguration configuration, String host, int port, String contextPath) {
        this.clientClass = MockServerClient.class;
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Host can not be null or empty");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("ContextPath can not be null");
        }
        if (configuration == null) {
            configuration = ClientConfiguration.clientConfiguration();
        }
        this.configuration = configuration;
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
        this.eventLoopGroup = this.eventLoopGroup();
    }

    private NioEventLoopGroup eventLoopGroup() {
        return new NioEventLoopGroup(this.configuration.clientNioEventLoopThreadCount().intValue(), (ThreadFactory)new Scheduler.SchedulerThreadFactory(this.getClass().getSimpleName() + "-eventLoop"));
    }

    @Deprecated
    public MockServerClient setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        return this.withProxyConfiguration(proxyConfiguration);
    }

    public MockServerClient withProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        return this;
    }

    public MockServerClient withControlPlaneJWT(String controlPlaneJWT) {
        return this.withControlPlaneJWT(() -> controlPlaneJWT);
    }

    public MockServerClient withControlPlaneJWT(Supplier<String> controlPlaneJWTSupplier) {
        this.controlPlaneJWTSupplier = controlPlaneJWTSupplier;
        return this;
    }

    @Deprecated
    public MockServerClient setRequestOverride(HttpRequest requestOverride) {
        return this.withRequestOverride(requestOverride);
    }

    public MockServerClient withRequestOverride(HttpRequest requestOverride) {
        if (requestOverride == null) {
            throw new IllegalArgumentException("Request with default properties can not be null");
        }
        this.requestOverride = requestOverride;
        return this;
    }

    private MockServerEventBus getMockServerEventBus() {
        if (EVENT_BUS_MAP.get(this.port()) == null) {
            EVENT_BUS_MAP.put(this.port(), new MockServerEventBus());
        }
        return EVENT_BUS_MAP.get(this.port());
    }

    private void removeMockServerEventBus() {
        EVENT_BUS_MAP.remove(this.port());
    }

    public boolean isSecure() {
        return this.secure != null ? this.secure : false;
    }

    public MockServerClient withSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    private int port() {
        if (this.port == null) {
            try {
                this.port = this.portFuture.get(this.configuration.maxFutureTimeoutInMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.port;
    }

    public InetSocketAddress remoteAddress() {
        return new InetSocketAddress(this.host, this.port());
    }

    public String contextPath() {
        return this.contextPath;
    }

    public Integer getPort() {
        return this.port();
    }

    private String calculatePath(String path) {
        String cleanedPath = "/mockserver/" + path;
        if (StringUtils.isNotBlank((CharSequence)this.contextPath)) {
            cleanedPath = (!this.contextPath.startsWith("/") ? "/" : "") + this.contextPath + (!this.contextPath.endsWith("/") ? "/" : "") + (cleanedPath.startsWith("/") ? cleanedPath.substring(1) : cleanedPath);
        }
        return (!cleanedPath.startsWith("/") ? "/" : "") + cleanedPath;
    }

    private NettyHttpClient getNettyHttpClient() {
        if (this.nettyHttpClient == null) {
            NettySslContextFactory nettySslContextFactory = new NettySslContextFactory(this.configuration.toServerConfiguration(), MOCK_SERVER_LOGGER, false);
            Function<SslContextBuilder, SslContext> clientSslContextBuilderFunction = NettySslContextFactory.clientSslContextBuilderFunction;
            if (this.configuration.controlPlaneTLSMutualAuthenticationRequired().booleanValue()) {
                if (StringUtils.isBlank((CharSequence)this.configuration.controlPlanePrivateKeyPath()) || StringUtils.isBlank((CharSequence)this.configuration.controlPlaneX509CertificatePath()) || StringUtils.isBlank((CharSequence)this.configuration.controlPlaneTLSMutualAuthenticationCAChain())) {
                    throw new IllegalArgumentException("when 'controlPlaneTLSMutualAuthenticationRequired' is enabled 'controlPlanePrivateKeyPath', 'controlPlaneX509CertificatePath' and 'controlPlaneTLSMutualAuthenticationCAChain' must all be specified,\n\tfound controlPlanePrivateKeyPath: \"" + this.configuration.controlPlanePrivateKeyPath() + "\"\n\tand controlPlaneX509CertificatePath: \"" + this.configuration.controlPlaneX509CertificatePath() + "\"\n\tand controlPlaneTLSMutualAuthenticationCAChain: \"" + this.configuration.controlPlaneTLSMutualAuthenticationCAChain() + "\"");
                }
                clientSslContextBuilderFunction = sslContextBuilder -> {
                    try {
                        PrivateKey key = PEMToFile.privateKeyFromPEMFile((String)this.configuration.controlPlanePrivateKeyPath());
                        X509Certificate[] keyCertChain = PEMToFile.x509ChainFromPEMFile((String)this.configuration.controlPlaneX509CertificatePath()).toArray(new X509Certificate[0]);
                        X509Certificate[] trustCertCollection = nettySslContextFactory.trustCertificateChain(this.configuration.controlPlaneTLSMutualAuthenticationCAChain());
                        sslContextBuilder.keyManager(key, keyCertChain).trustManager(trustCertCollection);
                        return sslContextBuilder.build();
                    }
                    catch (SSLException e) {
                        throw new RuntimeException(e);
                    }
                };
            }
            this.nettyHttpClient = new NettyHttpClient(this.configuration.toServerConfiguration(), MOCK_SERVER_LOGGER, this.eventLoopGroup, (List)(this.proxyConfiguration != null ? ImmutableList.of((Object)this.proxyConfiguration) : null), false, nettySslContextFactory.withClientSslContextBuilderFunction((Function)clientSslContextBuilderFunction));
        }
        return this.nettyHttpClient;
    }

    private HttpResponse sendRequest(HttpRequest request, boolean ignoreErrors) {
        if (!this.stopFuture.isDone()) {
            try {
                HttpResponse response;
                if (!request.containsHeader(HttpHeaderNames.CONTENT_TYPE.toString()) && request.getBody() != null && StringUtils.isNotBlank((CharSequence)request.getBody().getContentType())) {
                    request.withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{request.getBody().getContentType()});
                }
                if (this.secure != null) {
                    request.withSecure(this.secure);
                }
                if (this.requestOverride != null) {
                    request = request.update(this.requestOverride, null);
                }
                if (this.controlPlaneJWTSupplier != null) {
                    String jwt = this.controlPlaneJWTSupplier.get();
                    if (StringUtils.isNotBlank((CharSequence)jwt)) {
                        request.withHeader(HttpHeaderNames.AUTHORIZATION.toString(), new String[]{"Bearer " + jwt});
                    } else {
                        throw new IllegalArgumentException("Control plane jwt supplier returned invalid JWT \"" + jwt + "\"");
                    }
                }
                if ((response = this.getNettyHttpClient().sendRequest(request.withHeader(HttpHeaderNames.HOST.toString(), new String[]{this.host + ":" + this.port()}), this.configuration.maxSocketTimeoutInMillis().longValue(), TimeUnit.MILLISECONDS, ignoreErrors)) != null) {
                    if (response.getStatusCode() != null) {
                        if (response.getStatusCode().intValue() == HttpResponseStatus.BAD_REQUEST.code()) {
                            throw new IllegalArgumentException(response.getBodyAsString());
                        }
                        if (response.getStatusCode().intValue() == HttpResponseStatus.UNAUTHORIZED.code()) {
                            throw new AuthenticationException(response.getBodyAsString());
                        }
                    }
                    String serverVersion = response.getFirstHeader("version");
                    String clientVersion = Version.getVersion();
                    if (!Version.matchesMajorMinorVersion((String)serverVersion)) {
                        throw new ClientException("Client version \"" + clientVersion + "\" major and minor versions do not match server version \"" + serverVersion + "\"");
                    }
                }
                return response;
            }
            catch (RuntimeException rex) {
                if (StringUtils.isNotBlank((CharSequence)rex.getMessage()) && (rex.getMessage().contains("executor not accepting a task") || rex.getMessage().contains("loop shut down"))) {
                    throw new IllegalStateException(this.getClass().getSimpleName() + " has already been closed, please create new " + this.getClass().getSimpleName() + " instance");
                }
                throw rex;
            }
        }
        throw new IllegalStateException(this.getClass().getSimpleName() + " has already been stopped, please create new " + this.getClass().getSimpleName() + " instance");
    }

    private HttpResponse sendRequest(HttpRequest request) {
        return this.sendRequest(request, false);
    }

    public MockServerClient openUI() {
        return this.openUI(TimeUnit.SECONDS, 1L);
    }

    public MockServerClient openUI(TimeUnit timeUnit, long pause) {
        try {
            Desktop desktop = Desktop.getDesktop();
            if (desktop != null) {
                if (desktop.isSupported(Desktop.Action.BROWSE)) {
                    desktop.browse(new URI("http://" + this.host + ":" + this.port() + "/mockserver/dashboard"));
                    timeUnit.sleep(pause);
                } else if (MockServerLogger.isEnabled((Level)Level.WARN)) {
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("browse to URL not supported by the desktop instance from JVM"));
                }
            } else if (MockServerLogger.isEnabled((Level)Level.WARN)) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("unable to obtain the desktop instance from JVM"));
            }
        }
        catch (Throwable throwable) {
            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while attempting to launch UI" + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? " " + throwable.getMessage() : "")).setThrowable(throwable));
            throw new ClientException("exception while attempting to launch UI" + (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) ? " " + throwable.getMessage() : ""));
        }
        return this;
    }

    @Deprecated
    public boolean isRunning() {
        return this.isRunning(10, 500L, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public boolean isRunning(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")), true);
            if (httpResponse != null && httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                return true;
            }
            if (attempts <= 0) {
                return false;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.isRunning(attempts - 1, timeout, timeUnit);
        }
        catch (IllegalStateException | SocketConnectionException sce) {
            if (MockServerLogger.isEnabled((Level)Level.TRACE)) {
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("exception while checking if MockServer is running - " + sce.getMessage() + " if MockServer was stopped this exception is expected").setThrowable(sce));
            }
            return false;
        }
    }

    public boolean hasStopped() {
        return this.hasStopped(10, 500L, TimeUnit.MILLISECONDS);
    }

    public boolean hasStopped(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")), true);
            if (httpResponse != null && httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                if (attempts <= 0) {
                    return false;
                }
                try {
                    timeUnit.sleep(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.hasStopped(attempts - 1, timeout, timeUnit);
            }
            return true;
        }
        catch (IllegalStateException | SocketConnectionException sce) {
            return true;
        }
    }

    public boolean hasStarted() {
        return this.hasStarted(10, 500L, TimeUnit.MILLISECONDS);
    }

    public boolean hasStarted(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")));
            if (httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                return true;
            }
            if (attempts <= 0) {
                return false;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.hasStarted(attempts - 1, timeout, timeUnit);
        }
        catch (IllegalStateException | SocketConnectionException sce) {
            if (attempts <= 0) {
                if (MockServerLogger.isEnabled((Level)Level.DEBUG)) {
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("exception while checking if MockServer has started - " + sce.getMessage()).setThrowable(sce));
                }
                return false;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.hasStarted(attempts - 1, timeout, timeUnit);
        }
    }

    public List<Integer> bind(Integer ... ports) {
        String boundPorts = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("bind")).withBody(this.portBindingSerializer.serialize(PortBinding.portBinding((Integer[])ports)), StandardCharsets.UTF_8)).getBodyAsString();
        return this.portBindingSerializer.deserialize(boundPorts).getPorts();
    }

    public Future<MockServerClient> stopAsync() {
        return this.stop(true);
    }

    public void stop() {
        block2: {
            try {
                this.stopAsync().get(10L, TimeUnit.SECONDS);
            }
            catch (Throwable throwable) {
                if (!MockServerLogger.isEnabled((Level)Level.DEBUG)) break block2;
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("exception while stopping - " + throwable.getMessage()).setThrowable(throwable));
            }
        }
    }

    public CompletableFuture<MockServerClient> stop(boolean ignoreFailure) {
        if (!this.stopFuture.isDone()) {
            this.getMockServerEventBus().publish(MockServerEventBus.EventType.STOP);
            this.removeMockServerEventBus();
            new Scheduler.SchedulerThreadFactory("ClientStop").newThread(() -> {
                block7: {
                    try {
                        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("stop")));
                        if (!this.hasStopped()) {
                            for (int i = 0; !this.hasStopped() && i < 50; ++i) {
                                TimeUnit.MILLISECONDS.sleep(5L);
                            }
                        }
                    }
                    catch (RejectedExecutionException ree) {
                        if (!ignoreFailure && MockServerLogger.isEnabled((Level)Level.TRACE)) {
                            MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("request rejected while closing down, logging in case due other error " + ree).setThrowable((Throwable)ree));
                        }
                    }
                    catch (Exception e) {
                        if (ignoreFailure || !MockServerLogger.isEnabled((Level)Level.WARN)) break block7;
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("failed to send stop request to MockServer " + e.getMessage()));
                    }
                }
                if (!this.eventLoopGroup.isShuttingDown()) {
                    this.eventLoopGroup.shutdownGracefully();
                }
                this.stopFuture.complete(this.clientClass.cast(this));
            }).start();
        }
        return this.stopFuture;
    }

    public void close() {
        this.stop();
    }

    public MockServerClient reset() {
        this.getMockServerEventBus().publish(MockServerEventBus.EventType.RESET);
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("reset")));
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(RequestDefinition requestDefinition) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("clear")).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(String expectationId) {
        return this.clear(ExpectationId.expectationId((String)expectationId));
    }

    public MockServerClient clear(ExpectationId expectationId) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("clear")).withBody(expectationId != null ? this.expectationIdSerializer.serialize(expectationId) : "", StandardCharsets.UTF_8));
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(RequestDefinition requestDefinition, ClearType type) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("clear")).withQueryStringParameter("type", new String[]{type.name().toLowerCase()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(String expectationId, ClearType type) {
        return this.clear(ExpectationId.expectationId((String)expectationId), type);
    }

    public MockServerClient clear(ExpectationId expectationId, ClearType type) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("clear")).withQueryStringParameter("type", new String[]{type.name().toLowerCase()}).withBody(expectationId != null ? this.expectationIdSerializer.serialize(expectationId) : "", StandardCharsets.UTF_8));
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(RequestDefinition ... requestDefinitions) throws AssertionError {
        return this.verify((Integer)null, requestDefinitions);
    }

    public MockServerClient verify(Integer maximumNumberOfRequestToReturnInVerificationFailure, RequestDefinition ... requestDefinitions) throws AssertionError {
        if (requestDefinitions == null || requestDefinitions.length == 0 || requestDefinitions[0] == null) {
            throw new IllegalArgumentException("verify(RequestDefinition...) requires a non-null non-empty array of RequestDefinition objects");
        }
        try {
            VerificationSequence verificationSequence = new VerificationSequence().withRequests(requestDefinitions).withMaximumNumberOfRequestToReturnInVerificationFailure(maximumNumberOfRequestToReturnInVerificationFailure);
            String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verifySequence")).withBody(this.verificationSequenceSerializer.serialize(verificationSequence), StandardCharsets.UTF_8)).getBodyAsString();
            if (result != null && !result.isEmpty()) {
                throw new AssertionError((Object)result);
            }
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable.getMessage());
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(String ... expectationIds) throws AssertionError {
        return this.verify((ExpectationId[])Arrays.stream(expectationIds).map(ExpectationId::expectationId).toArray(ExpectationId[]::new));
    }

    public MockServerClient verify(ExpectationId ... expectationIds) throws AssertionError {
        return this.verify((Integer)null, expectationIds);
    }

    public MockServerClient verify(Integer maximumNumberOfRequestToReturnInVerificationFailure, ExpectationId ... expectationIds) throws AssertionError {
        if (expectationIds == null || expectationIds.length == 0 || expectationIds[0] == null) {
            throw new IllegalArgumentException("verify(ExpectationId...) requires a non-null non-empty array of ExpectationId objects");
        }
        try {
            VerificationSequence verificationSequence = new VerificationSequence().withExpectationIds(expectationIds).withMaximumNumberOfRequestToReturnInVerificationFailure(maximumNumberOfRequestToReturnInVerificationFailure);
            String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verifySequence")).withBody(this.verificationSequenceSerializer.serialize(verificationSequence), StandardCharsets.UTF_8)).getBodyAsString();
            if (result != null && !result.isEmpty()) {
                throw new AssertionError((Object)result);
            }
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable.getMessage());
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(RequestDefinition requestDefinition, VerificationTimes times) throws AssertionError {
        return this.verify(requestDefinition, times, null);
    }

    public MockServerClient verify(RequestDefinition requestDefinition, VerificationTimes times, Integer maximumNumberOfRequestToReturnInVerificationFailure) throws AssertionError {
        if (requestDefinition == null) {
            throw new IllegalArgumentException("verify(RequestDefinition, VerificationTimes) requires a non null RequestDefinition object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(RequestDefinition, VerificationTimes) requires a non null VerificationTimes object");
        }
        try {
            Verification verification = Verification.verification().withRequest(requestDefinition).withTimes(times).withMaximumNumberOfRequestToReturnInVerificationFailure(maximumNumberOfRequestToReturnInVerificationFailure);
            String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), StandardCharsets.UTF_8)).getBodyAsString();
            if (result != null && !result.isEmpty()) {
                throw new AssertionError((Object)result);
            }
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable.getMessage());
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(String expectationId, VerificationTimes times) throws AssertionError {
        return this.verify(ExpectationId.expectationId((String)expectationId), times);
    }

    public MockServerClient verify(ExpectationId expectationId, VerificationTimes times) throws AssertionError {
        return this.verify(expectationId, times, null);
    }

    public MockServerClient verify(ExpectationId expectationId, VerificationTimes times, Integer maximumNumberOfRequestToReturnInVerificationFailure) throws AssertionError {
        if (expectationId == null) {
            throw new IllegalArgumentException("verify(ExpectationId, VerificationTimes) requires a non null ExpectationId object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(ExpectationId, VerificationTimes) requires a non null VerificationTimes object");
        }
        try {
            Verification verification = Verification.verification().withExpectationId(expectationId).withTimes(times).withMaximumNumberOfRequestToReturnInVerificationFailure(maximumNumberOfRequestToReturnInVerificationFailure);
            String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), StandardCharsets.UTF_8)).getBodyAsString();
            if (result != null && !result.isEmpty()) {
                throw new AssertionError((Object)result);
            }
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable.getMessage());
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verifyZeroInteractions() throws AssertionError {
        try {
            Verification verification = Verification.verification().withRequest((RequestDefinition)HttpRequest.request()).withTimes(VerificationTimes.exactly((int)0));
            String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), StandardCharsets.UTF_8)).getBodyAsString();
            if (result != null && !result.isEmpty()) {
                throw new AssertionError((Object)result);
            }
        }
        catch (AuthenticationException authenticationException) {
            throw authenticationException;
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable.getMessage());
        }
        return this.clientClass.cast(this);
    }

    public HttpRequest[] retrieveRecordedRequests(RequestDefinition requestDefinition) {
        RequestDefinition[] requestDefinitions = new RequestDefinition[]{};
        String recordedRequests = this.retrieveRecordedRequests(requestDefinition, Format.JSON);
        if (StringUtils.isNotBlank((CharSequence)recordedRequests) && !recordedRequests.equals("[]")) {
            requestDefinitions = this.requestDefinitionSerializer.deserializeArray(recordedRequests);
        }
        return (HttpRequest[])Arrays.stream(requestDefinitions).map(HttpRequest.class::cast).toArray(HttpRequest[]::new);
    }

    public String retrieveRecordedRequests(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.REQUESTS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public LogEventRequestAndResponse[] retrieveRecordedRequestsAndResponses(RequestDefinition requestDefinition) {
        String recordedRequests = this.retrieveRecordedRequestsAndResponses(requestDefinition, Format.JSON);
        if (StringUtils.isNotBlank((CharSequence)recordedRequests) && !recordedRequests.equals("[]")) {
            return this.httpRequestResponseSerializer.deserializeArray(recordedRequests);
        }
        return new LogEventRequestAndResponse[0];
    }

    public String retrieveRecordedRequestsAndResponses(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.REQUEST_RESPONSES.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public Expectation[] retrieveRecordedExpectations(RequestDefinition requestDefinition) {
        String recordedExpectations = this.retrieveRecordedExpectations(requestDefinition, Format.JSON);
        if (StringUtils.isNotBlank((CharSequence)recordedExpectations) && !recordedExpectations.equals("[]")) {
            return this.expectationSerializer.deserializeArray(recordedExpectations, true);
        }
        return new Expectation[0];
    }

    public String retrieveRecordedExpectations(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.RECORDED_EXPECTATIONS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public String retrieveLogMessages(RequestDefinition requestDefinition) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.LOGS.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public String[] retrieveLogMessagesArray(RequestDefinition requestDefinition) {
        return this.retrieveLogMessages(requestDefinition).split(HttpState.LOG_SEPARATOR);
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition) {
        return this.when(requestDefinition, Times.unlimited());
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition, Times times) {
        return new ForwardChainExpectation(this.configuration, MOCK_SERVER_LOGGER, this.getMockServerEventBus(), this, new Expectation(requestDefinition, times, TimeToLive.unlimited(), 0));
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition, Times times, TimeToLive timeToLive) {
        return new ForwardChainExpectation(this.configuration, MOCK_SERVER_LOGGER, this.getMockServerEventBus(), this, new Expectation(requestDefinition, times, timeToLive, 0));
    }

    public ForwardChainExpectation when(RequestDefinition requestDefinition, Times times, TimeToLive timeToLive, Integer priority) {
        return new ForwardChainExpectation(this.configuration, MOCK_SERVER_LOGGER, this.getMockServerEventBus(), this, new Expectation(requestDefinition, times, timeToLive, priority.intValue()));
    }

    public Expectation[] upsert(OpenAPIExpectation ... openAPIExpectations) {
        if (openAPIExpectations != null) {
            HttpResponse httpResponse = null;
            if (openAPIExpectations.length == 1) {
                httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("openapi")).withBody(this.openAPIExpectationSerializer.serialize(openAPIExpectations[0]), StandardCharsets.UTF_8));
                if (httpResponse != null && httpResponse.getStatusCode() != 201) {
                    throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while submitted OpenAPI expectation:{}", (Object[])new Object[]{httpResponse.getBody(), openAPIExpectations[0]}));
                }
            } else if (openAPIExpectations.length > 1 && (httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("openapi")).withBody(this.openAPIExpectationSerializer.serialize(openAPIExpectations), StandardCharsets.UTF_8))) != null && httpResponse.getStatusCode() != 201) {
                throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while submitted OpenAPI expectations:{}", (Object[])new Object[]{httpResponse.getBody(), openAPIExpectations}));
            }
            if (httpResponse != null && StringUtils.isNotBlank((CharSequence)httpResponse.getBodyAsString())) {
                return this.expectationSerializer.deserializeArray(httpResponse.getBodyAsString(), true);
            }
        }
        return new Expectation[0];
    }

    public Expectation[] upsert(Expectation ... expectations) {
        if (expectations != null) {
            HttpResponse httpResponse = null;
            if (expectations.length == 1) {
                httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("expectation")).withBody(this.expectationSerializer.serialize(expectations[0]), StandardCharsets.UTF_8));
                if (httpResponse != null && httpResponse.getStatusCode() != 201) {
                    throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while submitted expectation:{}", (Object[])new Object[]{httpResponse.getBody(), expectations[0]}));
                }
            } else if (expectations.length > 1 && (httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("expectation")).withBody(this.expectationSerializer.serialize(expectations), StandardCharsets.UTF_8))) != null && httpResponse.getStatusCode() != 201) {
                throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while submitted expectations:{}", (Object[])new Object[]{httpResponse.getBody(), expectations}));
            }
            if (httpResponse != null && StringUtils.isNotBlank((CharSequence)httpResponse.getBodyAsString())) {
                return this.expectationSerializer.deserializeArray(httpResponse.getBodyAsString(), true);
            }
        }
        return new Expectation[0];
    }

    @Deprecated
    public Expectation[] sendExpectation(Expectation ... expectations) {
        return this.upsert(expectations);
    }

    public Expectation[] retrieveActiveExpectations(RequestDefinition requestDefinition) {
        String activeExpectations = this.retrieveActiveExpectations(requestDefinition, Format.JSON);
        if (StringUtils.isNotBlank((CharSequence)activeExpectations) && !activeExpectations.equals("[]")) {
            return this.expectationSerializer.deserializeArray(activeExpectations, true);
        }
        return new Expectation[0];
    }

    public String retrieveActiveExpectations(RequestDefinition requestDefinition, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withContentType(MediaType.APPLICATION_JSON_UTF_8).withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.ACTIVE_EXPECTATIONS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(requestDefinition != null ? this.requestDefinitionSerializer.serialize(requestDefinition) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }
}

