/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.serializers.string;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.model.NottableString;

public class NottableStringSerializer
extends StdSerializer<NottableString> {
    public NottableStringSerializer() {
        super(NottableString.class);
    }

    public void serialize(NottableString nottableString, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (nottableString.getNot() != null && nottableString.getNot().booleanValue()) {
            if (nottableString.getValue().startsWith("!")) {
                jgen.writeStartObject();
                jgen.writeBooleanField("not", true);
                jgen.writeStringField("value", nottableString.getValue());
                jgen.writeEndObject();
            } else {
                jgen.writeString("!" + nottableString.getValue());
            }
        } else if (nottableString.getValue().startsWith("!")) {
            jgen.writeStartObject();
            jgen.writeBooleanField("not", false);
            jgen.writeStringField("value", nottableString.getValue());
            jgen.writeEndObject();
        } else {
            jgen.writeString(nottableString.getValue());
        }
    }
}

