/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket;

import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.io.IOUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreFactory {
    public static final String KEY_STORE_PASSWORD = "changeit";
    public static final String CERTIFICATE_DOMAIN = "localhost";
    public static final String KEY_STORE_CERT_ALIAS = "mockserver-client-cert";
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreFactory.class);
    private static final String KEY_STORE_CA_ALIAS = "mockserver-ca-cert";
    private static final String SSL_CONTEXT_PROTOCOL = "TLSv1.2";
    private static final String SSL_CONTEXT_FALLBACK_PROTOCOL = "TLSv1";
    private static final KeyStoreFactory SSL_FACTORY = new KeyStoreFactory();
    private static SSLContext sslContext;

    private KeyStoreFactory() {
    }

    public static KeyStoreFactory keyStoreFactory() {
        return SSL_FACTORY;
    }

    public static String defaultKeyStoreFileName() {
        if ("jks".equalsIgnoreCase(ConfigurationProperties.javaKeyStoreType())) {
            return "mockserver_keystore.jks";
        }
        if ("pkcs12".equalsIgnoreCase(ConfigurationProperties.javaKeyStoreType())) {
            return "mockserver_keystore.p12";
        }
        if ("jceks".equalsIgnoreCase(ConfigurationProperties.javaKeyStoreType())) {
            return "mockserver_keystore.jceks";
        }
        throw new IllegalArgumentException(ConfigurationProperties.javaKeyStoreType() + " is not a supported keystore type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore saveCertificateAsKeyStore(KeyStore existingKeyStore, boolean deleteOnExit, String keyStoreFileName, String certificationAlias, Key privateKey, char[] keyStorePassword, Certificate[] chain, X509Certificate caCert) {
        try {
            KeyStore keyStore = existingKeyStore;
            if (keyStore == null) {
                keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, keyStorePassword);
            }
            try {
                keyStore.deleteEntry(certificationAlias);
            }
            catch (KeyStoreException kse) {
                // empty catch block
            }
            keyStore.setKeyEntry(certificationAlias, privateKey, keyStorePassword, chain);
            try {
                keyStore.deleteEntry(KEY_STORE_CA_ALIAS);
            }
            catch (KeyStoreException kse) {
                // empty catch block
            }
            keyStore.setCertificateEntry(KEY_STORE_CA_ALIAS, caCert);
            File keyStoreFile = new File(keyStoreFileName);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(keyStoreFile);
                keyStore.store(fileOutputStream, keyStorePassword);
                logger.trace("Saving key store to file [" + keyStoreFileName + "]");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fileOutputStream);
            if (deleteOnExit) {
                keyStoreFile.deleteOnExit();
            }
            return keyStore;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while saving KeyStore", e);
        }
    }

    public synchronized SSLContext sslContext() {
        if (sslContext == null || ConfigurationProperties.rebuildKeyStore()) {
            try {
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(this.loadOrCreateKeyStore(), ConfigurationProperties.javaKeyStorePassword().toCharArray());
                sslContext = this.getSSLContextInstance();
                sslContext.init(keyManagerFactory.getKeyManagers(), InsecureTrustManagerFactory.INSTANCE.getTrustManagers(), null);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize the SSLContext", e);
            }
        }
        return sslContext;
    }

    private SSLContext getSSLContextInstance() throws NoSuchAlgorithmException {
        try {
            logger.debug("Using protocol {}", (Object)SSL_CONTEXT_PROTOCOL);
            return SSLContext.getInstance(SSL_CONTEXT_PROTOCOL);
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Protocol {} not available, falling back to {}", (Object)SSL_CONTEXT_PROTOCOL, (Object)SSL_CONTEXT_FALLBACK_PROTOCOL);
            return SSLContext.getInstance(SSL_CONTEXT_FALLBACK_PROTOCOL);
        }
    }

    public KeyStore loadOrCreateKeyStore() {
        KeyStore keystore = null;
        File keyStoreFile = new File(ConfigurationProperties.javaKeyStoreFilePath());
        if (keyStoreFile.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(keyStoreFile);
                keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(fileInputStream, ConfigurationProperties.javaKeyStorePassword().toCharArray());
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Exception while loading KeyStore from " + keyStoreFile.getAbsolutePath(), e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        System.setProperty("javax.net.ssl.trustStore", keyStoreFile.getAbsolutePath());
        ConfigurationProperties.rebuildKeyStore(false);
        return this.populateKeyStore(keystore);
    }

    private KeyStore populateKeyStore(KeyStore keyStore) {
        KeyAndCertificateFactory.keyAndCertificateFactory().buildAndSaveCertificates();
        return KeyStoreFactory.saveCertificateAsKeyStore(keyStore, ConfigurationProperties.deleteGeneratedKeyStoreOnExit(), ConfigurationProperties.javaKeyStoreFilePath(), KEY_STORE_CERT_ALIAS, KeyAndCertificateFactory.keyAndCertificateFactory().mockServerPrivateKey(), ConfigurationProperties.javaKeyStorePassword().toCharArray(), new X509Certificate[]{KeyAndCertificateFactory.keyAndCertificateFactory().mockServerX509Certificate(), KeyAndCertificateFactory.keyAndCertificateFactory().mockServerCertificateAuthorityX509Certificate()}, KeyAndCertificateFactory.keyAndCertificateFactory().mockServerCertificateAuthorityX509Certificate());
    }
}

