/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.socket.KeyStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySslContextFactory {
    private static final Logger logger = LoggerFactory.getLogger(KeyStoreFactory.class);
    private SslContext clientSslContext = null;
    private SslContext serverSslContext = null;
    private static final NettySslContextFactory NETTY_SSL_CONTEXT_FACTORY = new NettySslContextFactory();

    private NettySslContextFactory() {
    }

    public static NettySslContextFactory nettySslContextFactory() {
        return NETTY_SSL_CONTEXT_FACTORY;
    }

    public synchronized SslContext createClientSslContext() {
        if (this.clientSslContext == null || ConfigurationProperties.rebuildKeyStore()) {
            try {
                this.clientSslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            catch (SSLException e) {
                throw new RuntimeException("Exception creating SSL context for client", e);
            }
        }
        return this.clientSslContext;
    }

    public synchronized SslContext createServerSslContext() {
        if (this.serverSslContext == null || ConfigurationProperties.rebuildKeyStore()) {
            try {
                this.serverSslContext = this.buildSslContext();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception creating SSL context for server", e);
            }
        }
        return this.serverSslContext;
    }

    private SslContext buildSslContext() throws Exception {
        KeyAndCertificateFactory.keyAndCertificateFactory().buildAndSaveCertificates();
        return SslContextBuilder.forServer((PrivateKey)KeyAndCertificateFactory.keyAndCertificateFactory().mockServerPrivateKey(), (String)ConfigurationProperties.javaKeyStorePassword(), (X509Certificate[])new X509Certificate[]{KeyAndCertificateFactory.keyAndCertificateFactory().mockServerX509Certificate(), KeyAndCertificateFactory.keyAndCertificateFactory().mockServerCertificateAuthorityX509Certificate()}).build();
    }
}

