/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.logging;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.LogManager;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.mock.HttpState;
import org.mockserver.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class MockServerLogger {
    private final Logger logger;
    private HttpState httpStateHandler;

    public static void configureLogger() {
        try {
            if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(("handlers=org.mockserver.logging.StandardOutConsoleHandler" + Character.NEW_LINE + "org.mockserver.logging.StandardOutConsoleHandler.level=ALL" + Character.NEW_LINE + "org.mockserver.logging.StandardOutConsoleHandler.formatter=java.util.logging.SimpleFormatter" + Character.NEW_LINE + "java.util.logging.SimpleFormatter.format=%1$tF %1$tT " + Version.getVersion() + " %4$s %5$s %6$s%n" + Character.NEW_LINE + "org.mockserver.level=INFO" + Character.NEW_LINE + "io.netty.level=WARNING").getBytes(StandardCharsets.UTF_8)));
                if (StringUtils.isNotBlank((CharSequence)ConfigurationProperties.javaLoggerLogLevel())) {
                    String loggingConfiguration = "" + (!ConfigurationProperties.disableSystemOut() ? "handlers=org.mockserver.logging.StandardOutConsoleHandler" + Character.NEW_LINE + "org.mockserver.logging.StandardOutConsoleHandler.level=ALL" + Character.NEW_LINE + "org.mockserver.logging.StandardOutConsoleHandler.formatter=java.util.logging.SimpleFormatter" + Character.NEW_LINE : "") + "java.util.logging.SimpleFormatter.format=%1$tF %1$tT " + Version.getVersion() + " %4$s %5$s %6$s%n" + Character.NEW_LINE + "org.mockserver.level=" + ConfigurationProperties.javaLoggerLogLevel() + Character.NEW_LINE + "io.netty.level=" + (Arrays.asList("TRACE", "FINEST").contains(ConfigurationProperties.javaLoggerLogLevel()) ? "FINE" : "WARNING");
                    LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(loggingConfiguration.getBytes(StandardCharsets.UTF_8)));
                }
            }
        }
        catch (Throwable throwable) {
            new MockServerLogger().logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.ERROR).setMessageFormat("exception while configuring Java logging - " + throwable.getMessage()).setThrowable(throwable));
        }
    }

    @VisibleForTesting
    public MockServerLogger() {
        this(MockServerLogger.class);
    }

    @VisibleForTesting
    public MockServerLogger(Logger logger) {
        this.logger = logger;
        this.httpStateHandler = null;
    }

    public MockServerLogger(Class<?> loggerClass) {
        this.logger = LoggerFactory.getLogger(loggerClass);
        this.httpStateHandler = null;
    }

    public MockServerLogger(@Nullable HttpState httpStateHandler) {
        this.logger = null;
        this.httpStateHandler = httpStateHandler;
    }

    public MockServerLogger setHttpStateHandler(HttpState httpStateHandler) {
        this.httpStateHandler = httpStateHandler;
        return this;
    }

    public void logEvent(LogEntry logEntry) {
        if (logEntry.getType() == LogEntry.LogMessageType.RECEIVED_REQUEST || logEntry.getType() == LogEntry.LogMessageType.FORWARDED_REQUEST || logEntry.isAlwaysLog() || MockServerLogger.isEnabled(logEntry.getLogLevel())) {
            if (this.httpStateHandler != null) {
                this.httpStateHandler.log(logEntry);
            } else {
                MockServerLogger.writeToSystemOut(this.logger, logEntry);
            }
        }
    }

    public static void writeToSystemOut(Logger logger, LogEntry logEntry) {
        if (!ConfigurationProperties.disableLogging() && (logEntry.isAlwaysLog() || MockServerLogger.isEnabled(logEntry.getLogLevel())) && StringUtils.isNotBlank((CharSequence)logEntry.getMessage())) {
            switch (logEntry.getLogLevel()) {
                case ERROR: {
                    logger.error(MockServerLogger.portInformation(logEntry) + logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case WARN: {
                    logger.warn(MockServerLogger.portInformation(logEntry) + logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case INFO: {
                    logger.info(MockServerLogger.portInformation(logEntry) + logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case DEBUG: {
                    logger.debug(MockServerLogger.portInformation(logEntry) + logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case TRACE: {
                    logger.trace(MockServerLogger.portInformation(logEntry) + logEntry.getMessage(), logEntry.getThrowable());
                }
            }
        }
    }

    private static String portInformation(LogEntry logEntry) {
        Integer port = logEntry.getPort();
        if (port != null) {
            return port + " ";
        }
        return "";
    }

    public static boolean isEnabled(Level level) {
        return MockServerLogger.isEnabled(level, ConfigurationProperties.logLevel());
    }

    public static boolean isEnabled(Level level, Level configuredLevel) {
        return configuredLevel != null && level.toInt() >= configuredLevel.toInt();
    }

    static {
        MockServerLogger.configureLogger();
    }
}

