/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.httpclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.codec.MockServerBinaryClientCodec;
import org.mockserver.codec.MockServerHttpClientCodec;
import org.mockserver.httpclient.Http2SettingsHandler;
import org.mockserver.httpclient.HttpClientConnectionErrorHandler;
import org.mockserver.httpclient.HttpClientHandler;
import org.mockserver.httpclient.HttpOrHttp2Initializer;
import org.mockserver.httpclient.NettyHttpClient;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.Protocol;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class HttpClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final MockServerLogger mockServerLogger;
    private final boolean forwardProxyClient;
    private final Protocol httpProtocol;
    private final HttpClientConnectionErrorHandler httpClientConnectionHandler;
    private final CompletableFuture<Protocol> protocolFuture;
    private final HttpClientHandler httpClientHandler;
    private final Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations;
    private final NettySslContextFactory nettySslContextFactory;

    HttpClientInitializer(Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations, MockServerLogger mockServerLogger, boolean forwardProxyClient, NettySslContextFactory nettySslContextFactory, Protocol httpProtocol) {
        this.proxyConfigurations = proxyConfigurations;
        this.mockServerLogger = mockServerLogger;
        this.forwardProxyClient = forwardProxyClient;
        this.httpProtocol = httpProtocol;
        this.protocolFuture = new CompletableFuture();
        this.httpClientHandler = new HttpClientHandler();
        this.httpClientConnectionHandler = new HttpClientConnectionErrorHandler();
        this.nettySslContextFactory = nettySslContextFactory;
    }

    public void whenComplete(BiConsumer<? super Protocol, ? super Throwable> action) {
        this.protocolFuture.whenComplete(action);
    }

    public void initChannel(SocketChannel channel) {
        boolean secure;
        ChannelPipeline pipeline = channel.pipeline();
        boolean bl = secure = channel.attr(NettyHttpClient.SECURE) != null && channel.attr(NettyHttpClient.SECURE).get() != null && (Boolean)channel.attr(NettyHttpClient.SECURE).get() != false;
        if (this.proxyConfigurations != null) {
            ProxyConfiguration proxyConfiguration;
            if (secure && this.proxyConfigurations.containsKey((Object)ProxyConfiguration.Type.HTTPS)) {
                proxyConfiguration = this.proxyConfigurations.get((Object)ProxyConfiguration.Type.HTTPS);
                if (StringUtils.isNotBlank((CharSequence)proxyConfiguration.getUsername()) && StringUtils.isNotBlank((CharSequence)proxyConfiguration.getPassword())) {
                    pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress(), proxyConfiguration.getUsername(), proxyConfiguration.getPassword())});
                } else {
                    pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress())});
                }
            } else if (this.proxyConfigurations.containsKey((Object)ProxyConfiguration.Type.SOCKS5)) {
                proxyConfiguration = this.proxyConfigurations.get((Object)ProxyConfiguration.Type.SOCKS5);
                if (StringUtils.isNotBlank((CharSequence)proxyConfiguration.getUsername()) && StringUtils.isNotBlank((CharSequence)proxyConfiguration.getPassword())) {
                    pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress(), proxyConfiguration.getUsername(), proxyConfiguration.getPassword())});
                } else {
                    pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress())});
                }
            }
        }
        pipeline.addLast(new ChannelHandler[]{this.httpClientConnectionHandler});
        if (secure) {
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.attr(NettyHttpClient.REMOTE_SOCKET).get();
            pipeline.addLast(new ChannelHandler[]{this.nettySslContextFactory.createClientSslContext(this.forwardProxyClient, this.httpProtocol != null && this.httpProtocol.equals((Object)Protocol.HTTP_2)).newHandler(channel.alloc(), remoteAddress.getHostName(), remoteAddress.getPort())});
        }
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(HttpClientHandler.class.getName())});
        }
        if (this.httpProtocol == null) {
            this.configureBinaryPipeline(pipeline);
        } else if (secure) {
            pipeline.addLast(new ChannelHandler[]{new HttpOrHttp2Initializer(this::configureHttp1Pipeline, this::configureHttp2Pipeline)});
        } else {
            this.configureHttp1Pipeline(pipeline);
        }
    }

    private void configureHttp1Pipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHttpClientCodec(this.mockServerLogger, this.proxyConfigurations)});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
        this.protocolFuture.complete(Protocol.HTTP_1_1);
    }

    private void configureHttp2Pipeline(ChannelPipeline pipeline) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        HttpToHttp2ConnectionHandlerBuilder http2ConnectionHandlerBuilder = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(Integer.MAX_VALUE).propagateSettings(true).validateHttpHeaders(false).build())).connection((Http2Connection)connection).flushPreface(true);
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            http2ConnectionHandlerBuilder.frameLogger(new Http2FrameLogger(LogLevel.TRACE, HttpClientHandler.class.getName()));
        }
        pipeline.addLast(new ChannelHandler[]{http2ConnectionHandlerBuilder.build()});
        pipeline.addLast(new ChannelHandler[]{new Http2SettingsHandler(this.protocolFuture)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHttpClientCodec(this.mockServerLogger, this.proxyConfigurations)});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
    }

    private void configureBinaryPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new MockServerBinaryClientCodec()});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
        this.protocolFuture.complete(null);
    }
}

