/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.RequestDefinition;
import org.slf4j.event.Level;

public class MatchDifference {
    private final boolean detailedMatchFailures;
    private final RequestDefinition httpRequest;
    private final Map<Field, List<String>> differences = new ConcurrentHashMap<Field, List<String>>();
    private Field fieldName;

    public MatchDifference(boolean detailedMatchFailures, RequestDefinition httpRequest) {
        this.detailedMatchFailures = detailedMatchFailures;
        this.httpRequest = httpRequest;
    }

    public MatchDifference addDifference(MockServerLogger mockServerLogger, Throwable throwable, String messageFormat, Object ... arguments) {
        if (mockServerLogger != null && MockServerLogger.isEnabled(Level.TRACE)) {
            mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(this.httpRequest).setCorrelationId(this.httpRequest.getLogCorrelationId()).setMessageFormat(messageFormat).setArguments(arguments).setThrowable(throwable));
        }
        return this.addDifference(messageFormat, arguments);
    }

    public MatchDifference addDifference(MockServerLogger mockServerLogger, String messageFormat, Object ... arguments) {
        return this.addDifference(mockServerLogger, null, messageFormat, arguments);
    }

    public MatchDifference addDifference(Field fieldName, String messageFormat, Object ... arguments) {
        if (this.detailedMatchFailures && StringUtils.isNotBlank((CharSequence)messageFormat) && arguments != null && fieldName != null) {
            this.differences.computeIfAbsent(fieldName, key -> new ArrayList()).add(StringFormatter.formatLogMessage(1, messageFormat, arguments));
        }
        return this;
    }

    public MatchDifference addDifference(String messageFormat, Object ... arguments) {
        return this.addDifference(this.fieldName, messageFormat, arguments);
    }

    public RequestDefinition getHttpRequest() {
        return this.httpRequest;
    }

    public String getLogCorrelationId() {
        return this.httpRequest.getLogCorrelationId();
    }

    protected MatchDifference currentField(Field fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public List<String> getDifferences(Field fieldName) {
        return this.differences.get((Object)fieldName);
    }

    public Map<Field, List<String>> getAllDifferences() {
        return this.differences;
    }

    public void addDifferences(Map<Field, List<String>> differences) {
        for (Field field : differences.keySet()) {
            this.differences.computeIfAbsent(field, key -> new ArrayList()).addAll((Collection)differences.get((Object)field));
        }
    }

    public static enum Field {
        METHOD("method"),
        PATH("path"),
        PATH_PARAMETERS("pathParameters"),
        QUERY_PARAMETERS("queryParameters"),
        COOKIES("cookies"),
        HEADERS("headers"),
        BODY("body"),
        SECURE("secure"),
        PROTOCOL("protocol"),
        KEEP_ALIVE("keep-alive"),
        OPERATION("operation"),
        OPENAPI("openapi");

        private final String name;

        private Field(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

