/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.logging;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.logging.LogManager;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.mock.HttpStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class MockServerLogger {
    private final Logger logger;
    private HttpStateHandler httpStateHandler;

    public static void configureLogger() {
        try {
            if (StringUtils.isNotBlank((CharSequence)ConfigurationProperties.javaLoggerLogLevel()) && System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                String loggingConfiguration = "handlers=org.mockserver.logging.StandardOutConsoleHandler\norg.mockserver.logging.StandardOutConsoleHandler.level=ALL\norg.mockserver.logging.StandardOutConsoleHandler.formatter=java.util.logging.SimpleFormatter\njava.util.logging.SimpleFormatter.format=%1$tF %1$tT  %3$s  %4$s  %5$s %6$s%n\n.level=" + ConfigurationProperties.javaLoggerLogLevel() + "\nio.netty.handler.ssl.SslHandler.level=WARNING";
                LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(loggingConfiguration.getBytes(Charset.forName("UTF-8"))));
            }
        }
        catch (Throwable throwable) {
            new MockServerLogger().logEvent(new LogEntry().setType(LogEntry.LogMessageType.SERVER_CONFIGURATION).setLogLevel(Level.ERROR).setMessageFormat("Exception while configuring Java logging - " + throwable.getMessage()).setThrowable(throwable));
        }
    }

    @VisibleForTesting
    public MockServerLogger() {
        this(MockServerLogger.class);
    }

    @VisibleForTesting
    public MockServerLogger(Logger logger) {
        this.logger = logger;
        this.httpStateHandler = null;
    }

    public MockServerLogger(Class loggerClass) {
        this.logger = LoggerFactory.getLogger((Class)loggerClass);
        this.httpStateHandler = null;
    }

    public MockServerLogger(@Nullable HttpStateHandler httpStateHandler) {
        this.logger = null;
        this.httpStateHandler = httpStateHandler;
    }

    public MockServerLogger setHttpStateHandler(HttpStateHandler httpStateHandler) {
        this.httpStateHandler = httpStateHandler;
        return this;
    }

    public void logEvent(LogEntry logEntry) {
        if (logEntry.getType() == LogEntry.LogMessageType.RECEIVED_REQUEST || MockServerLogger.isEnabled(logEntry.getLogLevel())) {
            if (this.httpStateHandler != null) {
                this.httpStateHandler.log(logEntry);
            } else {
                MockServerLogger.writeToSystemOut(this.logger, logEntry);
            }
        }
    }

    public static void writeToSystemOut(Logger logger, LogEntry logEntry) {
        if (!ConfigurationProperties.disableSystemOut() && MockServerLogger.isEnabled(logEntry.getLogLevel()) && StringUtils.isNotBlank((CharSequence)logEntry.getMessage())) {
            switch (logEntry.getLogLevel()) {
                case ERROR: {
                    logger.error(logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case WARN: {
                    logger.warn(logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case INFO: {
                    logger.info(logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case DEBUG: {
                    logger.debug(logEntry.getMessage(), logEntry.getThrowable());
                    break;
                }
                case TRACE: {
                    logger.trace(logEntry.getMessage(), logEntry.getThrowable());
                }
            }
        }
    }

    public static boolean isEnabled(Level level) {
        return ConfigurationProperties.logLevel() == null && level.toInt() >= Level.WARN.toInt() || ConfigurationProperties.logLevel() != null && level.toInt() >= ConfigurationProperties.logLevel().toInt();
    }

    static {
        MockServerLogger.configureLogger();
    }
}

