/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.validator.xmlschema.XmlSchemaValidator;
import org.slf4j.event.Level;

public class XmlSchemaMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"key", "mockServerLogger", "xmlSchemaValidator"};
    private final MockServerLogger mockServerLogger;
    private String schema;
    private XmlSchemaValidator xmlSchemaValidator;

    XmlSchemaMatcher(MockServerLogger mockServerLogger, String schema) {
        this.mockServerLogger = mockServerLogger;
        this.schema = schema;
        this.xmlSchemaValidator = new XmlSchemaValidator(mockServerLogger, schema);
    }

    @Override
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }

    @Override
    public boolean matches(HttpRequest context, String matched) {
        boolean result = false;
        try {
            String validation = this.xmlSchemaValidator.isValid(matched);
            result = validation.isEmpty();
            if (!result) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setHttpRequest(context).setMessageFormat("Failed to perform xml schema match of {} with {} because {}").setArguments(matched, this.schema, validation));
            }
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setHttpRequest(context).setMessageFormat("Failed to perform xml schema match of {} with {} because {}").setArguments(matched, this.schema, e.getMessage()));
        }
        return this.not != result;
    }
}

