/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.deserializers.body;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.JsonBody;
import org.mockserver.model.MediaType;
import org.mockserver.model.NottableString;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.Parameters;
import org.mockserver.model.StringBody;
import org.mockserver.model.XmlBody;
import org.mockserver.serialization.Base64Converter;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.BinaryBodyDTO;
import org.mockserver.serialization.model.BodyWithContentTypeDTO;
import org.mockserver.serialization.model.JsonBodyDTO;
import org.mockserver.serialization.model.ParameterBodyDTO;
import org.mockserver.serialization.model.StringBodyDTO;
import org.mockserver.serialization.model.XmlBodyDTO;
import org.slf4j.event.Level;

public class BodyWithContentTypeDTODeserializer
extends StdDeserializer<BodyWithContentTypeDTO> {
    private static Map<String, Body.Type> fieldNameToType = new HashMap<String, Body.Type>();
    private static ObjectMapper objectMapper;
    private static final MockServerLogger MOCK_SERVER_LOGGER;
    private final Base64Converter base64Converter = new Base64Converter();

    public BodyWithContentTypeDTODeserializer() {
        super(BodyWithContentTypeDTO.class);
    }

    public BodyWithContentTypeDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken = jsonParser.getCurrentToken();
        String valueJsonValue = "";
        Enum type = null;
        boolean not = false;
        MediaType contentType = null;
        Charset charset = null;
        Parameters parameters = null;
        if (currentToken == JsonToken.START_OBJECT) {
            Map body = (Map)ctxt.readValue(jsonParser, Map.class);
            for (Map.Entry entry : body.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                String key = (String)entry.getKey();
                if (key.equalsIgnoreCase("type")) {
                    try {
                        type = Body.Type.valueOf(String.valueOf(entry.getValue()));
                    }
                    catch (IllegalArgumentException iae) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Ignoring invalid value for \"type\" field of \"" + entry.getValue() + "\""));
                    }
                }
                if (this.containsIgnoreCase(key, "string", "regex", "json", "jsonSchema", "jsonPath", "xml", "xmlSchema", "xpath", "base64Bytes") && type != Body.Type.PARAMETERS) {
                    String fieldName = String.valueOf(entry.getKey()).toLowerCase();
                    if (fieldNameToType.containsKey(fieldName)) {
                        type = fieldNameToType.get(fieldName);
                    }
                    valueJsonValue = String.valueOf(entry.getValue());
                }
                if (key.equalsIgnoreCase("not")) {
                    not = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                }
                if (key.equalsIgnoreCase("contentType")) {
                    try {
                        String mediaTypeHeader = String.valueOf(entry.getValue());
                        if (StringUtils.isNotBlank((CharSequence)mediaTypeHeader)) {
                            contentType = MediaType.parse(mediaTypeHeader);
                        }
                    }
                    catch (IllegalArgumentException uce) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Ignoring unsupported MediaType with value \"" + entry.getValue() + "\""));
                    }
                }
                if (key.equalsIgnoreCase("charset")) {
                    try {
                        charset = Charset.forName(String.valueOf(entry.getValue()));
                    }
                    catch (UnsupportedCharsetException uce) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Ignoring unsupported Charset with value \"" + entry.getValue() + "\""));
                    }
                    catch (IllegalCharsetNameException icne) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TRACE).setLogLevel(Level.TRACE).setMessageFormat("Ignoring invalid Charset with value \"" + entry.getValue() + "\""));
                    }
                }
                if (!key.equalsIgnoreCase("parameters")) continue;
                if (objectMapper == null) {
                    objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
                }
                parameters = (Parameters)objectMapper.readValue(objectMapper.writeValueAsString(entry.getValue()), Parameters.class);
            }
            if (type != null) {
                switch (1.$SwitchMap$org$mockserver$model$Body$Type[type.ordinal()]) {
                    case 1: {
                        if (contentType != null) {
                            return new BinaryBodyDTO(new BinaryBody(this.base64Converter.base64StringToBytes(valueJsonValue), contentType), (Boolean)not);
                        }
                        return new BinaryBodyDTO(new BinaryBody(this.base64Converter.base64StringToBytes(valueJsonValue)), (Boolean)not);
                    }
                    case 2: {
                        if (contentType != null) {
                            return new JsonBodyDTO(new JsonBody(valueJsonValue, contentType, JsonBody.DEFAULT_MATCH_TYPE), (Boolean)not);
                        }
                        if (charset != null) {
                            return new JsonBodyDTO(new JsonBody(valueJsonValue, charset, JsonBody.DEFAULT_MATCH_TYPE), (Boolean)not);
                        }
                        return new JsonBodyDTO(new JsonBody(valueJsonValue, JsonBody.DEFAULT_MATCH_TYPE), (Boolean)not);
                    }
                    case 3: {
                        return new ParameterBodyDTO(new ParameterBody(parameters), (Boolean)not);
                    }
                    case 4: {
                        if (contentType != null) {
                            return new StringBodyDTO(new StringBody(valueJsonValue, contentType), (Boolean)not);
                        }
                        if (charset != null) {
                            return new StringBodyDTO(new StringBody(valueJsonValue, charset), (Boolean)not);
                        }
                        return new StringBodyDTO(new StringBody(valueJsonValue), (Boolean)not);
                    }
                    case 5: {
                        if (contentType != null) {
                            return new XmlBodyDTO(new XmlBody(valueJsonValue, contentType), (Boolean)not);
                        }
                        if (charset != null) {
                            return new XmlBodyDTO(new XmlBody(valueJsonValue, charset), (Boolean)not);
                        }
                        return new XmlBodyDTO(new XmlBody(valueJsonValue), (Boolean)not);
                    }
                }
            } else if (body.size() > 0) {
                if (objectMapper == null) {
                    objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
                }
                return new JsonBodyDTO(new JsonBody(objectMapper.writeValueAsString((Object)body), JsonBody.DEFAULT_MATCH_TYPE), (Boolean)false);
            }
        } else if (currentToken == JsonToken.VALUE_STRING) {
            return new StringBodyDTO(new StringBody(jsonParser.getText()));
        }
        return null;
    }

    private NottableString parseNottableString(JsonParser jsonParser) throws IOException {
        NottableString nottableString = null;
        if (jsonParser.getCurrentToken() == JsonToken.START_OBJECT) {
            JsonToken currentToken;
            boolean isNot = false;
            String value = "";
            while ((currentToken = jsonParser.nextToken()) != JsonToken.END_OBJECT) {
                switch (currentToken) {
                    case START_ARRAY: {
                        break;
                    }
                    case START_OBJECT: {
                        break;
                    }
                    case END_OBJECT: {
                        break;
                    }
                    case FIELD_NAME: {
                        if (jsonParser.getText().equalsIgnoreCase("not")) {
                            isNot = jsonParser.nextToken() == JsonToken.VALUE_TRUE;
                            break;
                        }
                        if (!jsonParser.getText().equalsIgnoreCase("value")) break;
                        jsonParser.nextToken();
                        value = jsonParser.getText();
                        break;
                    }
                    case VALUE_TRUE: {
                        break;
                    }
                }
            }
            nottableString = NottableString.string(value, isNot);
        } else if (jsonParser.getCurrentToken() == JsonToken.VALUE_STRING) {
            String text = jsonParser.getText();
            nottableString = text.startsWith("!") ? NottableString.not(text.replaceFirst("^!", "")) : NottableString.string(text);
        }
        return nottableString;
    }

    private boolean containsIgnoreCase(String valueToMatch, String ... listOfValues) {
        for (String item : listOfValues) {
            if (!item.equalsIgnoreCase(valueToMatch)) continue;
            return true;
        }
        return false;
    }

    static {
        fieldNameToType.put("base64Bytes".toLowerCase(), Body.Type.BINARY);
        fieldNameToType.put("json".toLowerCase(), Body.Type.JSON);
        fieldNameToType.put("parameters".toLowerCase(), Body.Type.PARAMETERS);
        fieldNameToType.put("string".toLowerCase(), Body.Type.STRING);
        fieldNameToType.put("xml".toLowerCase(), Body.Type.XML);
        MOCK_SERVER_LOGGER = new MockServerLogger(ObjectMapperFactory.class);
    }
}

