/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.List;
import org.mockserver.echo.http.EchoServer;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mappers.MockServerHttpResponseToFullHttpResponse;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.HttpObject;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class EchoServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final EchoServer.Error error;
    private final MockServerLogger mockServerLogger;
    private final MockServerEventLog mockServerEventLog;
    private final EchoServer.NextResponse nextResponse;

    EchoServerHandler(EchoServer.Error error, MockServerLogger mockServerLogger, MockServerEventLog mockServerEventLog, EchoServer.NextResponse nextResponse) {
        this.error = error;
        this.mockServerLogger = mockServerLogger;
        this.mockServerEventLog = mockServerEventLog;
        this.nextResponse = nextResponse;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        this.mockServerEventLog.add(new LogEntry().setLogLevel(Level.INFO).setType(LogEntry.LogMessageType.RECEIVED_REQUEST).setHttpRequest(request).setMessageFormat("EchoServer received request{}").setArguments(request));
        if (!this.nextResponse.httpResponse.isEmpty()) {
            DefaultFullHttpResponse httpResponse = new MockServerHttpResponseToFullHttpResponse(this.mockServerLogger).mapMockServerResponseToNettyResponse(this.nextResponse.httpResponse.remove());
            ctx.writeAndFlush((Object)httpResponse);
        } else {
            int length;
            HttpObject httpResponse = HttpResponse.response().withStatusCode(request.getPath().equalsIgnoreCase("/not_found") ? HttpResponseStatus.NOT_FOUND.code() : HttpResponseStatus.OK.code()).withHeaders((List)request.getHeaderList());
            if (request.getBody() instanceof BodyWithContentType) {
                ((HttpResponse)httpResponse).withBody((BodyWithContentType)request.getBody());
            } else {
                ((HttpResponse)httpResponse).withBody(request.getBodyAsString());
            }
            int n = length = ((HttpResponse)httpResponse).getBody() != null ? ((HttpResponse)httpResponse).getBody().getRawBytes().length : 0;
            if (this.error == EchoServer.Error.LARGER_CONTENT_LENGTH) {
                ((HttpResponse)httpResponse).replaceHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(length * 2));
            } else if (this.error == EchoServer.Error.SMALLER_CONTENT_LENGTH) {
                ((HttpResponse)httpResponse).replaceHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(length / 2));
            } else {
                ((HttpResponse)httpResponse).replaceHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(length));
            }
            this.mockServerEventLog.add(new LogEntry().setLogLevel(Level.INFO).setHttpRequest(request).setHttpResponse((HttpResponse)httpResponse).setMessageFormat("EchoServer returning response{}for request{}").setArguments(httpResponse, request));
            ctx.writeAndFlush((Object)httpResponse);
            if (this.error == EchoServer.Error.LARGER_CONTENT_LENGTH || this.error == EchoServer.Error.SMALLER_CONTENT_LENGTH) {
                ctx.close();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("echo server server caught exception").setThrowable(cause));
        ctx.close();
    }
}

