/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls.jdk;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.socket.tls.jdk.CertificateSigningRequest;
import org.mockserver.socket.tls.jdk.X509AndPrivateKey;
import org.mockserver.socket.tls.jdk.X509Generator;
import org.slf4j.event.Level;

public class JDKKeyAndCertificateFactory
implements KeyAndCertificateFactory {
    private final MockServerLogger mockServerLogger;
    private final X509Generator x509Generator;
    private X509AndPrivateKey x509AndPrivateKey;

    public JDKKeyAndCertificateFactory(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.x509Generator = new X509Generator(new MockServerLogger());
    }

    @Override
    public void buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate() {
        if (this.dynamicCertificateAuthorityUpdate() && this.certificateAuthorityCertificateNotYetCreated()) {
            try {
                X509AndPrivateKey x509AndPrivateKey = this.x509Generator.generateRootX509AndPrivateKey(new CertificateSigningRequest().setKeyPairAlgorithm("RSA").setSigningAlgorithm("SHA256withRSA").setCommonName("www.mockserver.com").setKeyPairSize(2048));
                this.saveCertificateAuthorityPEMToFile(x509AndPrivateKey.getCert(), this.certificateAuthorityX509CertificatePath(), "X509 Certificate");
                this.saveCertificateAuthorityPEMToFile(x509AndPrivateKey.getPrivateKey(), this.certificateAuthorityPrivateKeyPath(), "Private Key");
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while generating certificate authority private key and X509 certificate").setThrowable(e));
            }
        }
    }

    private void saveCertificateAuthorityPEMToFile(String pem, String absolutePath, String type) throws IOException {
        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("created dynamic Certificate Authority " + type + " PEM file at{}").setArguments(absolutePath));
        try (FileWriter fileWriter = new FileWriter(this.createFileIfNotExists(type, new File(absolutePath)));){
            fileWriter.write(pem);
        }
    }

    private File createFileIfNotExists(String type, File file) {
        if (!file.exists()) {
            try {
                JDKKeyAndCertificateFactory.createParentDirs(file);
                if (!file.createNewFile()) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("failed to create the file{}while attempting to save Certificate Authority " + type + " PEM file").setArguments(file.getAbsolutePath()));
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("failed to create the file{}while attempting to save Certificate Authority " + type + " PEM file").setArguments(file.getAbsolutePath()).setThrowable(throwable));
            }
        }
        return file;
    }

    public static void createParentDirs(File file) throws IOException {
        File parent = file.getCanonicalFile().getParentFile();
        if (parent == null) {
            return;
        }
        JDKKeyAndCertificateFactory.createParentDirs(parent);
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!parent.isDirectory()) {
            throw new IOException("Unable to create parent directories of " + file);
        }
    }

    private boolean dynamicCertificateAuthorityUpdate() {
        return ConfigurationProperties.dynamicallyCreateCertificateAuthorityCertificate() && StringUtils.isNotBlank((CharSequence)ConfigurationProperties.directoryToSaveDynamicSSLCertificate());
    }

    public boolean certificateAuthorityCertificateNotYetCreated() {
        return !X509Generator.validX509PEMFileExists(this.certificateAuthorityX509CertificatePath());
    }

    private String certificateAuthorityX509CertificatePath() {
        if (this.dynamicCertificateAuthorityUpdate()) {
            return new File(new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()), "CertificateAuthorityCertificate.pem").getAbsolutePath();
        }
        return ConfigurationProperties.certificateAuthorityCertificate();
    }

    private String certificateAuthorityPrivateKeyPath() {
        if (this.dynamicCertificateAuthorityUpdate()) {
            return new File(new File(ConfigurationProperties.directoryToSaveDynamicSSLCertificate()), "PKCS8CertificateAuthorityPrivateKey.pem").getAbsolutePath();
        }
        return ConfigurationProperties.certificateAuthorityPrivateKey();
    }

    private String certificateAuthorityPrivateKey() {
        if (this.dynamicCertificateAuthorityUpdate()) {
            this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
        }
        String privateKey = FileReader.readFileFromClassPathOrPath(this.certificateAuthorityPrivateKeyPath());
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("loaded dynamic CA private key from path{}PEM{}").setArguments(this.certificateAuthorityPrivateKeyPath(), privateKey));
        }
        return privateKey;
    }

    @Override
    public X509Certificate certificateAuthorityX509Certificate() {
        if (this.dynamicCertificateAuthorityUpdate()) {
            this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
        }
        X509Certificate x509Certificate = X509Generator.x509FromPEMFile(this.certificateAuthorityX509CertificatePath());
        if (MockServerLogger.isEnabled(Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("loaded dynamic CA X509{}from path{}from PEM{}").setArguments(x509Certificate, this.certificateAuthorityX509CertificatePath(), FileReader.readFileFromClassPathOrPath(this.certificateAuthorityX509CertificatePath())));
        }
        return x509Certificate;
    }

    @Override
    public void buildAndSavePrivateKeyAndX509Certificate() {
        try {
            if (this.dynamicCertificateAuthorityUpdate()) {
                this.buildAndSaveCertificateAuthorityPrivateKeyAndX509Certificate();
            }
            String caPrivateKey = this.certificateAuthorityPrivateKey();
            X509Certificate certificateAuthorityX509Certificate = this.certificateAuthorityX509Certificate();
            this.x509AndPrivateKey = this.x509Generator.generateLeafX509AndPrivateKey(new CertificateSigningRequest().setKeyPairAlgorithm("RSA").setSigningAlgorithm("SHA256withRSA").setCommonName("www.mockserver.com").setCommonName(ConfigurationProperties.sslCertificateDomainName()).addSubjectAlternativeNames(ConfigurationProperties.sslSubjectAlternativeNameDomains()).addSubjectAlternativeNames(ConfigurationProperties.sslSubjectAlternativeNameIps()).setKeyPairSize(2048), certificateAuthorityX509Certificate.getIssuerDN().getName(), caPrivateKey);
            if (MockServerLogger.isEnabled(Level.DEBUG)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("created new X509{}with SAN Domain Names{}and IPs{}").setArguments(this.x509Certificate(), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameDomains()), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameIps())));
            }
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while generating private key and X509 certificate").setThrowable(e));
        }
    }

    @Override
    public boolean certificateNotYetCreated() {
        return this.x509AndPrivateKey == null;
    }

    @Override
    public PrivateKey privateKey() {
        return X509Generator.privateKeyFromPEM(this.x509AndPrivateKey.getPrivateKey());
    }

    @Override
    public X509Certificate x509Certificate() {
        return X509Generator.x509FromPEM(this.x509AndPrivateKey.getCert());
    }
}

