/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.ui.MockServerLogListener;

public class MockServerEventLogNotifier
extends ObjectWithReflectiveEqualsHashCodeToString {
    private boolean listenerAdded = false;
    private final List<MockServerLogListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Scheduler scheduler;

    public MockServerEventLogNotifier(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void notifyListeners(MockServerEventLog notifier) {
        if (this.listenerAdded && !this.listeners.isEmpty()) {
            this.scheduler.submit(() -> {
                for (MockServerLogListener listener : this.listeners.toArray(new MockServerLogListener[0])) {
                    listener.updated(notifier);
                }
            });
        }
    }

    public void registerListener(MockServerLogListener listener) {
        this.listeners.add(listener);
        this.listenerAdded = true;
    }

    public void unregisterListener(MockServerLogListener listener) {
        this.listeners.remove(listener);
    }
}

