/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mockserver.collections.CircularHashMap;
import org.mockserver.dashboard.model.LogEntryDTO;
import org.mockserver.dashboard.serializers.LogEntryDTOSerializer;
import org.mockserver.dashboard.serializers.ThrowableSerializer;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.HttpRequestSerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.ui.MockServerLogListener;
import org.mockserver.ui.MockServerMatcherListener;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class DashboardWebSocketServerHandler
extends ChannelInboundHandlerAdapter
implements MockServerLogListener,
MockServerMatcherListener {
    private static final Predicate<LogEntryDTO> requestLogPredicate = input -> input.getType() == LogEntry.LogMessageType.RECEIVED_REQUEST;
    private static final Predicate<LogEntryDTO> requestResponseLogPredicate = input -> input.getType() == LogEntry.LogMessageType.EXPECTATION_RESPONSE || input.getType() == LogEntry.LogMessageType.EXPECTATION_NOT_MATCHED_RESPONSE || input.getType() == LogEntry.LogMessageType.FORWARDED_REQUEST;
    private static final Predicate<LogEntryDTO> recordedExpectationLogPredicate = input -> input.getType() == LogEntry.LogMessageType.FORWARDED_REQUEST;
    private static final AttributeKey<Boolean> CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET = AttributeKey.valueOf((String)"CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET");
    private static final String UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI = "/_mockserver_ui_websocket";
    private static final int UI_UPDATE_ITEM_LIMIT = 50;
    private static ObjectMapper objectMapper;
    private final MockServerLogger mockServerLogger;
    private final boolean sslEnabledUpstream;
    private final HttpStateHandler httpStateHandler;
    private HttpRequestSerializer httpRequestSerializer;
    private WebSocketServerHandshaker handshaker;
    private CircularHashMap<ChannelHandlerContext, HttpRequest> clientRegistry = new CircularHashMap(100);
    private MockServerMatcher mockServerMatcher;
    private MockServerEventLog mockServerEventLog;
    private ThreadPoolExecutor scheduler;
    private ScheduledExecutorService throttleExecutorService;
    private Semaphore semaphore;

    public DashboardWebSocketServerHandler(HttpStateHandler httpStateHandler, boolean sslEnabledUpstream) {
        this.httpStateHandler = httpStateHandler;
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.sslEnabledUpstream = sslEnabledUpstream;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        try {
            this.scheduler = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception creating scheduler " + throwable.getMessage()).setThrowable(throwable));
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        if (this.throttleExecutorService != null) {
            this.throttleExecutorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        boolean release = true;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).uri().equals(UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI)) {
                this.upgradeChannel(ctx, (FullHttpRequest)msg);
                ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).set((Object)true);
            } else if (ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).get() != null && ((Boolean)ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).get()).booleanValue() && msg instanceof WebSocketFrame) {
                this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            } else {
                release = false;
                ctx.fireChannelRead(msg);
            }
        }
        finally {
            if (release) {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void upgradeChannel(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        if (this.mockServerEventLog == null) {
            this.mockServerEventLog = this.httpStateHandler.getMockServerLog();
            this.mockServerEventLog.registerListener((MockServerLogListener)this);
            this.mockServerMatcher = this.httpStateHandler.getMockServerMatcher();
            this.mockServerMatcher.registerListener((MockServerMatcherListener)this);
        }
        String webSocketURL = (this.sslEnabledUpstream ? "wss" : "ws") + "://" + httpRequest.headers().get("Host") + UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI;
        this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.DEBUG).setLogLevel(Level.DEBUG).setMessageFormat("Upgraded dashboard connection to support web sockets on url " + webSocketURL));
        this.handshaker = new WebSocketServerHandshakerFactory(webSocketURL, null, true, Integer.MAX_VALUE).newHandshaker((io.netty.handler.codec.http.HttpRequest)httpRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            this.handshaker.handshake(ctx.channel(), httpRequest, (HttpHeaders)new DefaultHttpHeaders(), ctx.channel().newPromise()).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                HttpRequest cfr_ignored_0 = (HttpRequest)this.clientRegistry.put((Object)ctx, (Object)HttpRequest.request());
            }));
        }
        if (objectMapper == null) {
            objectMapper = ObjectMapperFactory.createObjectMapper((JsonSerializer[])new JsonSerializer[]{new LogEntryDTOSerializer(), new ThrowableSerializer()});
        }
        if (this.httpRequestSerializer == null) {
            this.httpRequestSerializer = new HttpRequestSerializer(this.mockServerLogger);
        }
        if (this.semaphore == null) {
            this.semaphore = new Semaphore(1);
        }
        if (this.throttleExecutorService == null) {
            this.throttleExecutorService = Executors.newScheduledThreadPool(1);
        }
        if (this.scheduler == null) {
            this.scheduler = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
        this.throttleExecutorService.scheduleAtFixedRate(() -> {
            if (this.semaphore.availablePermits() == 0) {
                this.semaphore.release(1);
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain()).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                HttpRequest cfr_ignored_0 = (HttpRequest)this.clientRegistry.remove((Object)ctx);
            }));
        } else if (frame instanceof TextWebSocketFrame) {
            try {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(((TextWebSocketFrame)frame).text());
                this.clientRegistry.put((Object)ctx, (Object)httpRequest);
                this.sendUpdate(httpRequest, ctx);
            }
            catch (IllegalArgumentException iae) {
                this.sendMessage(ctx, (ImmutableMap<String, Object>)ImmutableMap.of((Object)"error", (Object)iae.getMessage()));
            }
        } else if (frame instanceof PingWebSocketFrame) {
            ctx.write((Object)new PongWebSocketFrame(frame.content().retain()));
        } else {
            throw new UnsupportedOperationException(frame.getClass().getName() + " frame types not supported");
        }
    }

    private void sendMessage(ChannelHandlerContext ctx, ImmutableMap<String, Object> message) {
        if (this.semaphore.tryAcquire()) {
            this.scheduler.submit(() -> {
                try {
                    ctx.writeAndFlush((Object)new TextWebSocketFrame(objectMapper.writeValueAsString((Object)message)));
                }
                catch (JsonProcessingException jpe) {
                    this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception will serialising UI data " + jpe.getMessage()).setThrowable((Throwable)jpe));
                }
            });
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("web socket server caught exception").setThrowable(cause));
        }
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.mockServerMatcher != null) {
            this.mockServerMatcher.unregisterListener((MockServerMatcherListener)this);
        }
        if (this.mockServerEventLog != null) {
            this.mockServerEventLog.unregisterListener((MockServerLogListener)this);
        }
        ctx.fireChannelInactive();
    }

    public void updated(MockServerEventLog mockServerLog) {
        for (Map.Entry registryEntry : this.clientRegistry.entrySet()) {
            this.sendUpdate((HttpRequest)registryEntry.getValue(), (ChannelHandlerContext)registryEntry.getKey());
        }
    }

    public void updated(MockServerMatcher mockServerMatcher) {
        for (Map.Entry registryEntry : this.clientRegistry.entrySet()) {
            this.sendUpdate((HttpRequest)registryEntry.getValue(), (ChannelHandlerContext)registryEntry.getKey());
        }
    }

    private void sendUpdate(HttpRequest httpRequest, ChannelHandlerContext channelHandlerContext) {
        this.mockServerEventLog.retrieveLogEntriesInReverse(httpRequest, logEntry -> true, LogEntryDTO::new, reverseLogEventsStream -> {
            ArrayList recordedExpectations = new ArrayList();
            ArrayList recordedRequests = new ArrayList();
            ArrayList recordedRequestResponses = new ArrayList();
            ArrayList logMessages = new ArrayList();
            reverseLogEventsStream.forEach(logEntryDTO -> {
                if (recordedExpectationLogPredicate.test((LogEntryDTO)((Object)((Object)logEntryDTO))) && recordedExpectations.size() < 50) {
                    recordedExpectations.add(ImmutableMap.of((Object)"key", (Object)logEntryDTO.key(), (Object)"value", (Object)new Expectation(logEntryDTO.getHttpRequest(), Times.once(), TimeToLive.unlimited()).thenRespond(logEntryDTO.getHttpResponse())));
                }
                if (requestLogPredicate.test((LogEntryDTO)((Object)((Object)logEntryDTO))) && recordedRequests.size() < 50) {
                    for (HttpRequest request : logEntryDTO.getHttpRequests()) {
                        recordedRequests.add(ImmutableMap.of((Object)"key", (Object)logEntryDTO.key(), (Object)"value", (Object)request));
                    }
                }
                if (requestResponseLogPredicate.test((LogEntryDTO)((Object)((Object)logEntryDTO))) && recordedRequestResponses.size() < 50) {
                    recordedRequestResponses.add(logEntryDTO);
                }
                if (logMessages.size() < 50) {
                    logMessages.add(logEntryDTO);
                }
            });
            this.sendMessage(channelHandlerContext, (ImmutableMap<String, Object>)ImmutableMap.of((Object)"activeExpectations", this.mockServerMatcher.retrieveActiveExpectations(httpRequest).stream().limit(50L).map(expectation -> ImmutableMap.of((Object)"key", (Object)expectation.key(), (Object)"value", (Object)expectation)).collect(Collectors.toList()), (Object)"recordedExpectations", recordedExpectations, (Object)"recordedRequests", recordedRequests, (Object)"recordedRequestResponses", recordedRequestResponses, (Object)"logMessages", logMessages));
        });
    }
}

