/**
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

// DO NOT EDIT THIS GENERATED OUTPUT DIRECTLY!
// This file should be overwritten as part of your build process.
// If you need to extend the behavior of the generated service worker, the best approach is to write
// additional code and include it using the importScripts option:
//   https://github.com/GoogleChrome/sw-precache#importscripts-arraystring
//
// Alternatively, it's possible to make changes to the underlying template file and then use that as the
// new base for generating output, via the templateFilePath option:
//   https://github.com/GoogleChrome/sw-precache#templatefilepath-string
//
// If you go that route, make sure that whenever you update your sw-precache dependency, you reconcile any
// changes made to this original template file with your modified copy.

// This generated service worker JavaScript will precache your site's resources.
// The code needs to be saved in a .js file at the top-level of your site, and registered
// from your pages in order to be used. See
// https://github.com/googlechrome/sw-precache/blob/master/demo/app/js/service-worker-registration.js
// for an example of how you can register this script and handle various service worker events.

/* eslint-env worker, serviceworker */
/* eslint-disable indent, no-unused-vars, no-multiple-empty-lines, max-nested-callbacks, space-before-function-paren, quotes, comma-spacing */
'use strict';

var precacheConfig = [["allclasses-frame.html","04b6a49af292f0ae3c505469f8db24fc"],["allclasses-noframe.html","9a9e086629c828c5b2fc9fafd0abd3a7"],["constant-values.html","a4c46c55b5700e5dd73465e971a84a08"],["deprecated-list.html","80dce03f6af570f1e1010f516af6ac43"],["favicon.ico","05e61206186c2eee9054011bcf15b864"],["help-doc.html","d64e37a4154279ff0f86ac701e625b57"],["index-files/index-1.html","5bc9682e88af1e7b5b9ce6ba3fb54bcf"],["index-files/index-10.html","957765b7e82866bb2ff6342481240566"],["index-files/index-11.html","032667ec5ca67de34baa9679e8bf31df"],["index-files/index-12.html","e5657316191d9572c95766ae3c94c882"],["index-files/index-13.html","54439406f78289f57564466e83a3cbce"],["index-files/index-14.html","5143c5b6145bbc316944e3e79661ccb0"],["index-files/index-15.html","d8ef4ec79a94a3b4e4d0c9098076c27e"],["index-files/index-16.html","4a058de884261569f398f6da94056555"],["index-files/index-17.html","8c421c120404e44dfe573569804a6efd"],["index-files/index-18.html","8a0d6a8fb4eca2feff961b77df49afa0"],["index-files/index-19.html","de739620b6e7d7717423a0f631f14304"],["index-files/index-2.html","dc9edf1e9530af38dd8a68a70a6718c1"],["index-files/index-20.html","f7865b313a7b124647f77da81d32c500"],["index-files/index-3.html","2b98d45c35c2e79aa6a6b3381593524f"],["index-files/index-4.html","4bde1090a8bfc7c8a9ed1a1e6a36cf58"],["index-files/index-5.html","b07b5f76997e82e235706517f37a8857"],["index-files/index-6.html","ecd0ac1808cd55922d0381bb27eb01d2"],["index-files/index-7.html","4fb57032086bfdea6ddaeeee4058eeaf"],["index-files/index-8.html","412f23e6651bf8a7b16d89b1d6dbde05"],["index-files/index-9.html","f573255c7e651f6e2ba9aead17f59b9c"],["index.html","4b1f8167e17481dff6249dda46d66001"],["js/highlight-8.6-java/highlight.pack.js","deec56e4bb489b0ce943987284aac274"],["js/highlight-8.6-java/styles/obsidian.css","d60cd29c66c835762c95d2ce6da21142"],["js/index.js","dfc78156c8712ef6c546ea1037a604ef"],["js/jdk6-project-version-insert.js","ddee726b95840e7606e132d95c65ef27"],["js/jdk6-project-version-insert.min.js","a6a8d425f512ba0a8e2340504f134553"],["js/jquery-1.7.min.js","25721ced154b3a99e818431446d7506d"],["org/mockito/AdditionalAnswers.html","6bb0df6c303604a926630088a432eba7"],["org/mockito/AdditionalMatchers.html","bdac62dba4a30f5aaab6d4967ba85823"],["org/mockito/Answers.html","c9ff054abbf2b3159af523734c81b7c0"],["org/mockito/ArgumentCaptor.html","4d8dd381ec073e27264c9f3ca32903a9"],["org/mockito/ArgumentMatcher.html","037fa8613a135500737a46d38cb69469"],["org/mockito/ArgumentMatchers.html","29ca1048806f26f9cc00dc95d4220bb7"],["org/mockito/BDDMockito.BDDMyOngoingStubbing.html","d6bf375ec9c695eccdfd50f9faf97bd9"],["org/mockito/BDDMockito.BDDStubber.html","687a95c26e9f97b3eac3b276c7d5c96c"],["org/mockito/BDDMockito.Then.html","b24f49feb1d29b173357f1742f092ab6"],["org/mockito/BDDMockito.html","eac1fd7c0876da2ae60d0b51359925e9"],["org/mockito/Captor.html","82dfd9bd7acdec23f2b2fd8daec26254"],["org/mockito/InOrder.html","609d41cb4cfd184371dbc6977187c6fa"],["org/mockito/Incubating.html","623c3023d82e34aab113f6292cb7bb57"],["org/mockito/InjectMocks.html","88a848fa8fe658c3fd9ec0bd110fb14d"],["org/mockito/Matchers.html","8d40eddd912c3634c0d05941be3be854"],["org/mockito/Mock.html","54667260851c4abff036f1678acac688"],["org/mockito/MockSettings.html","239a6ffa69631e4a0407db094a7a9346"],["org/mockito/MockingDetails.html","c7291ab49543bd78b97e82745272d632"],["org/mockito/Mockito.html","658d36fc94373564ed5f1cac60714840"],["org/mockito/MockitoAnnotations.html","20026ae21ef6e57a54f9b39c23660bed"],["org/mockito/MockitoDebugger.html","37d9fa951910d92db59b5cb626c30bca"],["org/mockito/MockitoFramework.html","147ba131ce13a3b4200f91ec259c5c00"],["org/mockito/Spy.html","61d6a60507609439692b5ea9f15ddc49"],["org/mockito/class-use/AdditionalAnswers.html","12ee1c70a7814325a72bdf46e2eee6fd"],["org/mockito/class-use/AdditionalMatchers.html","2ab457ad8a03c1252dae9305506c52b3"],["org/mockito/class-use/Answers.html","63dd0b585cb966c3d221da6ffc2352d9"],["org/mockito/class-use/ArgumentCaptor.html","7b36f09c618317a0720e596bd5b68e96"],["org/mockito/class-use/ArgumentMatcher.html","4e2e33553c45b7a2780c00cb6f00b05d"],["org/mockito/class-use/ArgumentMatchers.html","d52b018345fa0b3229739033a8def66e"],["org/mockito/class-use/BDDMockito.BDDMyOngoingStubbing.html","df2874b042ec112752d6c4faadbc5f95"],["org/mockito/class-use/BDDMockito.BDDStubber.html","c228de93a750001d9ef58f11ec3bc4ce"],["org/mockito/class-use/BDDMockito.Then.html","3fce27b7171b88dcb41aaf2a883e4fbe"],["org/mockito/class-use/BDDMockito.html","b1d581bec8d855a72d0d716ef1b2ddde"],["org/mockito/class-use/Captor.html","7dd9cd6d78b07ac7628bed0429dabb6f"],["org/mockito/class-use/InOrder.html","4647aa9ab5ec6f5b7062d2b3bbf425e1"],["org/mockito/class-use/Incubating.html","e71f322e42470c950cb8daa2d77fca55"],["org/mockito/class-use/InjectMocks.html","de1fb9d0e8ff0e2936c96346e169acf7"],["org/mockito/class-use/Matchers.html","a813772431b1d8a04973886c72c81c2c"],["org/mockito/class-use/Mock.html","48361510b56ff5546f290db470c8678f"],["org/mockito/class-use/MockSettings.html","c0a63c30721ce7cfa8a7bc9c9d887d0f"],["org/mockito/class-use/MockingDetails.html","dbbaef656a9de739d470d32604c22fd5"],["org/mockito/class-use/Mockito.html","ea2878f839708e92b8c995ced1304e74"],["org/mockito/class-use/MockitoAnnotations.html","a5d3ca67cc77ee15ac8dc7f648ed33e4"],["org/mockito/class-use/MockitoDebugger.html","f5864303020f1546921d6d65fd7c63b1"],["org/mockito/class-use/MockitoFramework.html","590f938b5904882ac18f4df1ff207c8d"],["org/mockito/class-use/Spy.html","4640372a95e2354d978397759cdebf37"],["org/mockito/configuration/AnnotationEngine.html","ec1441d8f80e90fc1343d40177a1c24c"],["org/mockito/configuration/DefaultMockitoConfiguration.html","d110cf3a310421cd0814f3a799a79f12"],["org/mockito/configuration/IMockitoConfiguration.html","f105cdaa2d19f8bb166b5cc7a88be49a"],["org/mockito/configuration/class-use/AnnotationEngine.html","804635b67d73e13a350b111bed2d2726"],["org/mockito/configuration/class-use/DefaultMockitoConfiguration.html","9cf176533392139ca6654130047d8bec"],["org/mockito/configuration/class-use/IMockitoConfiguration.html","19e0f9d705b77a865c0a3230faa68573"],["org/mockito/configuration/package-frame.html","4e49d039f0a1add604cb6d7eb3b562c4"],["org/mockito/configuration/package-summary.html","c69a6713d2a8d61a8bbfabf61b01af4a"],["org/mockito/configuration/package-tree.html","ae9716dfff16902a57b7e5741abd3474"],["org/mockito/configuration/package-use.html","941c60dd7d2abdf03b17c32e5d223539"],["org/mockito/exceptions/base/MockitoAssertionError.html","65b1b880052f83b249b7c62b45bc9cf3"],["org/mockito/exceptions/base/MockitoException.html","ec4860ad65870d90c7ed9df8ae2e8838"],["org/mockito/exceptions/base/MockitoInitializationException.html","f9a8f4dc261cb49ff9c92e5fde5a3000"],["org/mockito/exceptions/base/MockitoSerializationIssue.html","7728ee5534242af1d0edd44fe4e5e61a"],["org/mockito/exceptions/base/class-use/MockitoAssertionError.html","cc956f60b0fd7fa02ff27c6097c43653"],["org/mockito/exceptions/base/class-use/MockitoException.html","7aec70a348b47b6ef893ff24f3f7432d"],["org/mockito/exceptions/base/class-use/MockitoInitializationException.html","f764409367b4e9b26041a1d05cffa05b"],["org/mockito/exceptions/base/class-use/MockitoSerializationIssue.html","f43445cdf3e9be66fb1235ce02aedc5d"],["org/mockito/exceptions/base/package-frame.html","87ebeee41e018465cd3aa1573634ce76"],["org/mockito/exceptions/base/package-summary.html","201fdff9acd27b26d6422f02c55f5794"],["org/mockito/exceptions/base/package-tree.html","e90af259c7b441a2bdcebc0709459185"],["org/mockito/exceptions/base/package-use.html","3429fd2b75dfabeac0af758f906db5f4"],["org/mockito/exceptions/misusing/CannotStubVoidMethodWithReturnValue.html","04381fc42ad0a2eff69555516ab320b4"],["org/mockito/exceptions/misusing/CannotVerifyStubOnlyMock.html","eedb4e296fbc63e5a11fdf07e56f5ace"],["org/mockito/exceptions/misusing/FriendlyReminderException.html","84f39d908f52c0739f6728d504b3a8a7"],["org/mockito/exceptions/misusing/InvalidUseOfMatchersException.html","8b144add6eb1d4b51b111683c1dd21d8"],["org/mockito/exceptions/misusing/MissingMethodInvocationException.html","f5b5e338471da727aa9fd143ece7d3a1"],["org/mockito/exceptions/misusing/MockitoConfigurationException.html","7b1af8088255d86c351d55bd89dbc081"],["org/mockito/exceptions/misusing/NotAMockException.html","afa2398c7530c1f98106c357441fc224"],["org/mockito/exceptions/misusing/NullInsteadOfMockException.html","9fb5216f5de5513a88b5cc978c8f607e"],["org/mockito/exceptions/misusing/PotentialStubbingProblem.html","df6ee126129e32c9770ad186252d0515"],["org/mockito/exceptions/misusing/RedundantListenerException.html","13d345291ead00a45b51112bcf9d96a4"],["org/mockito/exceptions/misusing/UnfinishedStubbingException.html","ba2791261ffe3bd85b9d91a489bb9e2b"],["org/mockito/exceptions/misusing/UnfinishedVerificationException.html","339fcf1f07b041ee95efc5096cb0196a"],["org/mockito/exceptions/misusing/UnnecessaryStubbingException.html","75d6a431a141471e5e865706e041067f"],["org/mockito/exceptions/misusing/WrongTypeOfReturnValue.html","23ccec0d0a2130be5e0627921de952ef"],["org/mockito/exceptions/misusing/class-use/CannotStubVoidMethodWithReturnValue.html","1e17d1206ea1bdc8e7c3a99767bac9e1"],["org/mockito/exceptions/misusing/class-use/CannotVerifyStubOnlyMock.html","504ce719a2484256c231bf7d1d61244e"],["org/mockito/exceptions/misusing/class-use/FriendlyReminderException.html","d0b1fb117bf6e2d5ca65f24e8bc348be"],["org/mockito/exceptions/misusing/class-use/InvalidUseOfMatchersException.html","dc0f31650f6208b6267af58599679dd5"],["org/mockito/exceptions/misusing/class-use/MissingMethodInvocationException.html","664ee1c07c3bb6b20aada14fd9317d85"],["org/mockito/exceptions/misusing/class-use/MockitoConfigurationException.html","5992489fd301174fa0091ad6c57f2b09"],["org/mockito/exceptions/misusing/class-use/NotAMockException.html","ff3fb04255850e85eb94046f6931aa66"],["org/mockito/exceptions/misusing/class-use/NullInsteadOfMockException.html","8a06b67a3c6bf3b92b5fa4493aa11987"],["org/mockito/exceptions/misusing/class-use/PotentialStubbingProblem.html","8ce802858a3c97704158a31e6d5e5367"],["org/mockito/exceptions/misusing/class-use/RedundantListenerException.html","7d26cffa9b66372d492d00d3bdc17130"],["org/mockito/exceptions/misusing/class-use/UnfinishedStubbingException.html","8660e3838f98ae62bfdea87c80b9d398"],["org/mockito/exceptions/misusing/class-use/UnfinishedVerificationException.html","8c7fb786a9884a0e69348523ca9d749e"],["org/mockito/exceptions/misusing/class-use/UnnecessaryStubbingException.html","0f96582b429c61292ba17246a180647a"],["org/mockito/exceptions/misusing/class-use/WrongTypeOfReturnValue.html","0bbf5ddd04112baaacd0ded223301b1f"],["org/mockito/exceptions/misusing/package-frame.html","7dff30f22a083256de6f1b7b0a406a81"],["org/mockito/exceptions/misusing/package-summary.html","adb2c93e0ef4beea6e720bcf67d94c11"],["org/mockito/exceptions/misusing/package-tree.html","9af2a5a746a76d1f108fb0401947c86a"],["org/mockito/exceptions/misusing/package-use.html","ca437a95ed0cb5e34cf5a217749c4e09"],["org/mockito/exceptions/stacktrace/StackTraceCleaner.html","3c30b93d11e25eec7d3963e9a6fe3554"],["org/mockito/exceptions/stacktrace/class-use/StackTraceCleaner.html","faf4eed0914f2bc0d6f72887f9b35d9e"],["org/mockito/exceptions/stacktrace/package-frame.html","e828f85c453748d83210b06d976ce66a"],["org/mockito/exceptions/stacktrace/package-summary.html","a1842a7efe1aca16476a3149379661e6"],["org/mockito/exceptions/stacktrace/package-tree.html","bd38acd8274d98cb488f4056f2db4678"],["org/mockito/exceptions/stacktrace/package-use.html","8eea027b6d454b1632a48ce3d2de7523"],["org/mockito/exceptions/verification/ArgumentsAreDifferent.html","c34909becefe082752ddb72c840071fa"],["org/mockito/exceptions/verification/NeverWantedButInvoked.html","a1cf7cf688e44e6181dc927f5c5a2c2f"],["org/mockito/exceptions/verification/NoInteractionsWanted.html","a87f08469069221e9ba5987309df7155"],["org/mockito/exceptions/verification/SmartNullPointerException.html","995e7c781f2d8899269f3969bc582388"],["org/mockito/exceptions/verification/TooLittleActualInvocations.html","c96c1095086ca3d4a9490dd162b4f8c5"],["org/mockito/exceptions/verification/TooManyActualInvocations.html","5e326de1307aca9ce40d87efbdf61abe"],["org/mockito/exceptions/verification/VerificationInOrderFailure.html","f0e34e939f32d7288b918c8aabc1a090"],["org/mockito/exceptions/verification/WantedButNotInvoked.html","c3312419a101f779cd8e3d7932447437"],["org/mockito/exceptions/verification/class-use/ArgumentsAreDifferent.html","421cc9f29c085881224a1137428b6e7b"],["org/mockito/exceptions/verification/class-use/NeverWantedButInvoked.html","f14c30d684f36b251dec129ec390ca66"],["org/mockito/exceptions/verification/class-use/NoInteractionsWanted.html","f9128684116268313afd7d736d870df2"],["org/mockito/exceptions/verification/class-use/SmartNullPointerException.html","3fb43c11f9cf164409acb63d598d201e"],["org/mockito/exceptions/verification/class-use/TooLittleActualInvocations.html","04d90608e89d90cca8cbd4097d0dadb8"],["org/mockito/exceptions/verification/class-use/TooManyActualInvocations.html","d40de01aa2e01c9c0eae0480cdad94ca"],["org/mockito/exceptions/verification/class-use/VerificationInOrderFailure.html","0e04f127c1fb2426fea0852972084628"],["org/mockito/exceptions/verification/class-use/WantedButNotInvoked.html","f94a4434f820b32e75e46726d77a4c6b"],["org/mockito/exceptions/verification/junit/ArgumentsAreDifferent.html","0ffbfd1244bc28d50273279c8eaaca95"],["org/mockito/exceptions/verification/junit/class-use/ArgumentsAreDifferent.html","feaa615d55ceafc0b8f99cb4f6550f5e"],["org/mockito/exceptions/verification/junit/package-frame.html","9e676ed87259696bd816917104bad73b"],["org/mockito/exceptions/verification/junit/package-summary.html","c0ff7cc8059cb66f0c408af598c10c1b"],["org/mockito/exceptions/verification/junit/package-tree.html","a8fe304ed028068dd91e452fafcfdfd8"],["org/mockito/exceptions/verification/junit/package-use.html","50b30b321145da3c9cc2868994291127"],["org/mockito/exceptions/verification/package-frame.html","35ef01f235beff0f636b989701cc32a7"],["org/mockito/exceptions/verification/package-summary.html","794e122f562676473ac054f940994f9a"],["org/mockito/exceptions/verification/package-tree.html","29264827fde230eb9776c4a138c9811c"],["org/mockito/exceptions/verification/package-use.html","9afc36207c83d17437f74b2ad549c04c"],["org/mockito/hamcrest/MockitoHamcrest.html","5c382d6e7cf740d0c6e34cbe6faa31e5"],["org/mockito/hamcrest/class-use/MockitoHamcrest.html","b8e359d46f6e6f1855128b33d4b8a651"],["org/mockito/hamcrest/package-frame.html","70d332b9235bd7d25cd1857d7c2ac5e1"],["org/mockito/hamcrest/package-summary.html","a2fc8c50f2f939d7a557e6977b722efb"],["org/mockito/hamcrest/package-tree.html","9213b7dc324f4426b580ecf4746626ea"],["org/mockito/hamcrest/package-use.html","6854729419964275fe93d8db49bd355f"],["org/mockito/invocation/DescribedInvocation.html","9d2532c6a3c051018cb2829caf24ee3b"],["org/mockito/invocation/Invocation.html","acba1e76c74ca9841deb12fd031d3f4f"],["org/mockito/invocation/InvocationOnMock.html","007f053dc053cbe56b406e97150705dc"],["org/mockito/invocation/Location.html","0ec8f7cda06cfb5043bfbec4d7f4b54e"],["org/mockito/invocation/MatchableInvocation.html","87bb60a3515373712fa057dc46363b62"],["org/mockito/invocation/MockHandler.html","833c1d291d78319b789c11954b40cef2"],["org/mockito/invocation/StubInfo.html","fb65c4f2d95cae50cfd1df5d3ecfcc54"],["org/mockito/invocation/class-use/DescribedInvocation.html","298e6f0fc1865ab8817f294c4b091601"],["org/mockito/invocation/class-use/Invocation.html","da73582cda7b3c164716d16ffa01e3f2"],["org/mockito/invocation/class-use/InvocationOnMock.html","201a20afb2d049a9c7d09fe456d87281"],["org/mockito/invocation/class-use/Location.html","82f63ca83a3b02f94e09543dcf9fa08a"],["org/mockito/invocation/class-use/MatchableInvocation.html","14686b2cf3f71a8b4da5c85bad670671"],["org/mockito/invocation/class-use/MockHandler.html","3d29f25442380dd6495c68440b528a94"],["org/mockito/invocation/class-use/StubInfo.html","ee6719c8b90572b15f7b71d95cac8577"],["org/mockito/invocation/package-frame.html","2a461cdcf48635049802fe475e2f1c65"],["org/mockito/invocation/package-summary.html","cc433226a803dd1db8904a56e3b3ef6a"],["org/mockito/invocation/package-tree.html","862fcb11ffa98ec5d337cd6f7988c32f"],["org/mockito/invocation/package-use.html","2674d452ee0f835bdd686f78b3ee9b7e"],["org/mockito/junit/MockitoJUnit.html","8a01d4fc878e252cf6e50f64a70180ca"],["org/mockito/junit/MockitoJUnitRunner.Silent.html","1dc325c0197e7a40b35cdaa6ed4e4724"],["org/mockito/junit/MockitoJUnitRunner.Strict.html","24ac14f6d0e2e3954a5a5b3a4123bb90"],["org/mockito/junit/MockitoJUnitRunner.StrictStubs.html","c1d88216c3b4d3f64a953aadd028f328"],["org/mockito/junit/MockitoJUnitRunner.html","e5ed05a4bcfd24adc02b1aff505f9ea2"],["org/mockito/junit/MockitoRule.html","b7296f7065e8f6acb495de22a3ba63e3"],["org/mockito/junit/VerificationCollector.html","664cd1117d74ae9793c0c93d4b7ddbe7"],["org/mockito/junit/class-use/MockitoJUnit.html","4428570fc179d1711dfac7e398bfe2f7"],["org/mockito/junit/class-use/MockitoJUnitRunner.Silent.html","5e8fa35654f4e0efe4fa46c1f3ebc512"],["org/mockito/junit/class-use/MockitoJUnitRunner.Strict.html","0661ffc44a5f8bc666b005905e7a8050"],["org/mockito/junit/class-use/MockitoJUnitRunner.StrictStubs.html","f49bb14d4c189d42f16c32aceaace663"],["org/mockito/junit/class-use/MockitoJUnitRunner.html","f922229397d1a71a2ef9e02f6b1ffcc8"],["org/mockito/junit/class-use/MockitoRule.html","998e666b0b07a03951f3b46f1f4fe396"],["org/mockito/junit/class-use/VerificationCollector.html","5a15571a113a53f97c14213b54f762c7"],["org/mockito/junit/package-frame.html","9948a163359dbb9a062b83251bb8a594"],["org/mockito/junit/package-summary.html","60f3a55a6d1d489fd3d24da7ea65f077"],["org/mockito/junit/package-tree.html","1714b32f6651498683ec6a9deff7c0f6"],["org/mockito/junit/package-use.html","3d75e5a65cc8941f4e32ae271ea40b06"],["org/mockito/listeners/InvocationListener.html","c24d7dd02074b0b7281f4a53fbf72f6f"],["org/mockito/listeners/MethodInvocationReport.html","16200e3304a638ed00f2d8cbcbae722a"],["org/mockito/listeners/MockCreationListener.html","690de5e786d3a21072a2da0fb24d1f2d"],["org/mockito/listeners/MockitoListener.html","d421647f4b257bd414f4e23420fc3d48"],["org/mockito/listeners/VerificationListener.html","8639400082620157611a8ffb1ce77df7"],["org/mockito/listeners/class-use/InvocationListener.html","6259d165f5ed4ddcb31a32910bcce376"],["org/mockito/listeners/class-use/MethodInvocationReport.html","2751ddbb70deee1b41bd2ebb29a3c4f1"],["org/mockito/listeners/class-use/MockCreationListener.html","7315ee2fc4f52c5bd08f50aa4049b17e"],["org/mockito/listeners/class-use/MockitoListener.html","a1c6c2d9280a2203f5766f17acc3c59b"],["org/mockito/listeners/class-use/VerificationListener.html","7eede6d7b831f79e8294d5d5ab42f870"],["org/mockito/listeners/package-frame.html","f08d995d7515b82c5de3f3a38b95a6ff"],["org/mockito/listeners/package-summary.html","962c8996f06e17e4420b41dd075d3ed8"],["org/mockito/listeners/package-tree.html","cc193d5601989081a59cecbe7cca45df"],["org/mockito/listeners/package-use.html","9bcbb12e6de233381650a373a8ea29e4"],["org/mockito/mock/MockCreationSettings.html","acf6661655c059a8794d7cdf084cd97c"],["org/mockito/mock/MockName.html","37e7a6933ef9f0c8b4624e93a60b9cc1"],["org/mockito/mock/SerializableMode.html","ab27a03c0538ae7e9621036baa62edbf"],["org/mockito/mock/class-use/MockCreationSettings.html","f55506e426e0ee1fde26c89ecf116b76"],["org/mockito/mock/class-use/MockName.html","67fda07ab2e050b48de3713739fd9d25"],["org/mockito/mock/class-use/SerializableMode.html","42e99d2bab687883ffe767197752875c"],["org/mockito/mock/package-frame.html","fc72ed993fd63628dc27c169ff21b9af"],["org/mockito/mock/package-summary.html","51c459854b3550bdea3ba6780da41572"],["org/mockito/mock/package-tree.html","8d7e4af0572348edc076f8dae63c92d3"],["org/mockito/mock/package-use.html","50abb249995e91c20e71aea341d2a701"],["org/mockito/package-frame.html","94cd0cce0f3c19cb99694a7bbdc43621"],["org/mockito/package-summary.html","c26f0c77ccf2a10d32f082615e6aecc1"],["org/mockito/package-tree.html","a14438860331e0014ef5f4590f0eedf4"],["org/mockito/package-use.html","0ba8c5b5df728f493df9294059b38e2f"],["org/mockito/plugins/AnnotationEngine.html","8748a924ef51e363a9c717300cfb4f13"],["org/mockito/plugins/InstantiatorProvider.html","d843f938147d617d35909b681a8ce52b"],["org/mockito/plugins/MockMaker.TypeMockability.html","6fc0cdf7f60303d0cca90e1aa703c227"],["org/mockito/plugins/MockMaker.html","e88d44e580ae5bb84e082b564a39e516"],["org/mockito/plugins/PluginSwitch.html","69e544b7b87924f93055e8a903ac6404"],["org/mockito/plugins/StackTraceCleanerProvider.html","f040e150d6a1900d477e0f6d4d7426d4"],["org/mockito/plugins/class-use/AnnotationEngine.html","1ede7da1ce44c7926bb389cbf49683d5"],["org/mockito/plugins/class-use/InstantiatorProvider.html","04d3910897ffaf2b8e3db443a8fbc6c3"],["org/mockito/plugins/class-use/MockMaker.TypeMockability.html","81a7634692c35e139801c2b0cd288586"],["org/mockito/plugins/class-use/MockMaker.html","73ac983cd63c37780561a598bff439a5"],["org/mockito/plugins/class-use/PluginSwitch.html","c661decd222c10a60543f8b07a59e205"],["org/mockito/plugins/class-use/StackTraceCleanerProvider.html","135e9347fecf2f5af604d15256cf2004"],["org/mockito/plugins/package-frame.html","fbc98299d9a95022af838010b5d0448c"],["org/mockito/plugins/package-summary.html","fcd814d1f1d9a11c45272a49f5809b43"],["org/mockito/plugins/package-tree.html","e28791433c3c6a46edad6ad15766439b"],["org/mockito/plugins/package-use.html","a8c18dabcffd6165446282f2939b005c"],["org/mockito/quality/MockitoHint.html","53be465aad6c2b3ec98708c4805334da"],["org/mockito/quality/Strictness.html","27c72fbf6ba251016b576780adf6db01"],["org/mockito/quality/class-use/MockitoHint.html","71c000e023e9ac1c6b0e2f04476974b0"],["org/mockito/quality/class-use/Strictness.html","ed604b9dfc33abeb130bae59b3cafcfd"],["org/mockito/quality/package-frame.html","64b630d487d9d1b76ad5718561340a62"],["org/mockito/quality/package-summary.html","69b781e6838018d73e8cd91ad85f620e"],["org/mockito/quality/package-tree.html","83241bb58158e2a4706cd4d63812331f"],["org/mockito/quality/package-use.html","ed66d42f647d060195ef839327c1820f"],["org/mockito/runners/ConsoleSpammingMockitoJUnitRunner.html","b93e507ad9bd466a1841c6d66643ad7e"],["org/mockito/runners/MockitoJUnitRunner.Silent.html","8f0e3663d7a6ef6c3fe83206f7fa8275"],["org/mockito/runners/MockitoJUnitRunner.Strict.html","8efc4a500719fcab12857d396e886647"],["org/mockito/runners/MockitoJUnitRunner.html","06da33643cd0536606e42c0812b9a2f7"],["org/mockito/runners/VerboseMockitoJUnitRunner.html","70b3b85fc9b4b8337b34b3f46365e46b"],["org/mockito/runners/class-use/ConsoleSpammingMockitoJUnitRunner.html","b6a2c4807c7bb30a1637dfd86ae88ef9"],["org/mockito/runners/class-use/MockitoJUnitRunner.Silent.html","2c5444a8ef18e826fc64173e74981a0e"],["org/mockito/runners/class-use/MockitoJUnitRunner.Strict.html","e632c88db27987ea333cbdd04b99c00b"],["org/mockito/runners/class-use/MockitoJUnitRunner.html","b88afa725eb4208fc38db64c83f2ee44"],["org/mockito/runners/class-use/VerboseMockitoJUnitRunner.html","0ffb86ab6c9200a2b9fc361c09d74ae9"],["org/mockito/runners/package-frame.html","e62f0aaaf4694d8030d8774e5bcadb4e"],["org/mockito/runners/package-summary.html","d82bb0e9e7ae7aac03fadcee45fc548e"],["org/mockito/runners/package-tree.html","1136150b718007cf74ffd3e2ea0e54c0"],["org/mockito/runners/package-use.html","3cb6a7da6de995043476d2a63f5a9f2e"],["org/mockito/stubbing/Answer.html","aee7f4b7dcaa8f47c283d96d10d8986a"],["org/mockito/stubbing/Answer1.html","c83457d7a4d7665f5c193dc3eab5984f"],["org/mockito/stubbing/Answer2.html","69ed079e2709b826d137f914e82d0255"],["org/mockito/stubbing/Answer3.html","fb63ab3c13382e156250f30b297d16b6"],["org/mockito/stubbing/Answer4.html","dfbc2a591ce7c9d48d0d82545379cada"],["org/mockito/stubbing/Answer5.html","94a1c975d5d15740955ec828e9997914"],["org/mockito/stubbing/OngoingStubbing.html","feb401992304bd9b8c92efceeb56e574"],["org/mockito/stubbing/Stubber.html","a5cfc03098269cea8a9b97e0c925acad"],["org/mockito/stubbing/Stubbing.html","f4f7b106bf0e7ab034a12c97b034ef88"],["org/mockito/stubbing/ValidableAnswer.html","bba5295cd05e007ff46afb1f70617600"],["org/mockito/stubbing/VoidAnswer1.html","83f214894667dc4a5a3dc8a6dfbac691"],["org/mockito/stubbing/VoidAnswer2.html","a57d63042fba2c8915b34185da8730e7"],["org/mockito/stubbing/VoidAnswer3.html","71783241b7db56e8dd597ae380c8dae1"],["org/mockito/stubbing/VoidAnswer4.html","427d2553f3290a39056b7aa0ec100bd3"],["org/mockito/stubbing/VoidAnswer5.html","5ece655a4b6c1e73bb08dc858b7da5dc"],["org/mockito/stubbing/class-use/Answer.html","2d31837e13ee5c5b8e66ed19cd64bd52"],["org/mockito/stubbing/class-use/Answer1.html","52964592a18db7c26670195deeb5a8d5"],["org/mockito/stubbing/class-use/Answer2.html","4ae0490ea9f09f73de033a16bbe9fcc0"],["org/mockito/stubbing/class-use/Answer3.html","e532b9eca94911449680c363329ebfce"],["org/mockito/stubbing/class-use/Answer4.html","761a13f887d4e36474b9fc9f3f369c17"],["org/mockito/stubbing/class-use/Answer5.html","08feaa10f4034917f6675676d493cda9"],["org/mockito/stubbing/class-use/OngoingStubbing.html","e39dd8ea846b4f792a7b6d869db027c1"],["org/mockito/stubbing/class-use/Stubber.html","83eb3e8a68d3aab8f5b7937d79ab4c3e"],["org/mockito/stubbing/class-use/Stubbing.html","57e2d34bafec151ac29ee2c09ddc3792"],["org/mockito/stubbing/class-use/ValidableAnswer.html","d3c8c02c086d4ed93f57c0eb95bffb2e"],["org/mockito/stubbing/class-use/VoidAnswer1.html","c6d66bb94f23b5d5cca012865c4fb64f"],["org/mockito/stubbing/class-use/VoidAnswer2.html","45b09edd13778f922039db933ae4d334"],["org/mockito/stubbing/class-use/VoidAnswer3.html","229d106c4cbfa1b3f90af5daf62b35c6"],["org/mockito/stubbing/class-use/VoidAnswer4.html","8f22220cf0fa84a3ad964657186cb7d0"],["org/mockito/stubbing/class-use/VoidAnswer5.html","ff836233cb2c3657bc81bdaa1dddd047"],["org/mockito/stubbing/package-frame.html","4ad883d202858d5201cba503324ad7e5"],["org/mockito/stubbing/package-summary.html","7ea7a59c156bfbd2cb54481626955a47"],["org/mockito/stubbing/package-tree.html","546fc7b7295d8608ef3ff067b9bca62d"],["org/mockito/stubbing/package-use.html","088555b10679f7edef8bc4ef7dc95e9d"],["org/mockito/verification/After.html","246211d5c79bb34180e95f5b35dabf71"],["org/mockito/verification/Timeout.html","0f75513da6b669134b8ec2c390ea10db"],["org/mockito/verification/VerificationAfterDelay.html","4dde53b6d1a9430b5013f41183900db3"],["org/mockito/verification/VerificationEvent.html","3dc4c4f408fd5c1dc8a7577ad33cd541"],["org/mockito/verification/VerificationMode.html","32bf24f19b4b0022e7dd5294e8f4c6d2"],["org/mockito/verification/VerificationStrategy.html","b13dc7188bd2e5791d19304e632d076d"],["org/mockito/verification/VerificationWithTimeout.html","abc6e96f4dc54e767f2d3260dfb5f26f"],["org/mockito/verification/class-use/After.html","4c2c4c68ec47b7225b1e64a585e574e4"],["org/mockito/verification/class-use/Timeout.html","d4f29b4c18e80336526e45880686b6d3"],["org/mockito/verification/class-use/VerificationAfterDelay.html","9c9b9c1800f457f1e431313dc9272cda"],["org/mockito/verification/class-use/VerificationEvent.html","9b18991751ca3c24274cb561efb92581"],["org/mockito/verification/class-use/VerificationMode.html","a563b360f03cd23351824f49157f8db1"],["org/mockito/verification/class-use/VerificationStrategy.html","90abf5561529ddacaa0c341b74129b33"],["org/mockito/verification/class-use/VerificationWithTimeout.html","6e783fa29afc7922159b707b2a36ab12"],["org/mockito/verification/package-frame.html","f1e0cfe90d0a1167c19a28632ea2eb4f"],["org/mockito/verification/package-summary.html","558682ace804d116869d6040e186a101"],["org/mockito/verification/package-tree.html","ddce5c8017087ab888f777f13cc8a177"],["org/mockito/verification/package-use.html","66a6c5a5f3da13e8b3796d2557db1a16"],["overview-frame.html","14c0e607d8797a38a5cda78ffa731aa2"],["overview-summary.html","0373df57f98032d171b7ee6bb5ae2dbd"],["overview-tree.html","6b5e60cf833e82c5b7cf9ff0f5d27d4f"],["serialized-form.html","aaaf51d7d6d312af04aa3765b004cb2e"],["stylesheet.css","3dd9013d4309436be79cba586b6e5454"]];
var cacheName = 'sw-precache-v2-sw-precache-' + (self.registration ? self.registration.scope : '');


var ignoreUrlParametersMatching = [/^utm_/];



var addDirectoryIndex = function (originalUrl, index) {
    var url = new URL(originalUrl);
    if (url.pathname.slice(-1) === '/') {
      url.pathname += index;
    }
    return url.toString();
  };

var createCacheKey = function (originalUrl, paramName, paramValue,
                           dontCacheBustUrlsMatching) {
    // Create a new URL object to avoid modifying originalUrl.
    var url = new URL(originalUrl);

    // If dontCacheBustUrlsMatching is not set, or if we don't have a match,
    // then add in the extra cache-busting URL parameter.
    if (!dontCacheBustUrlsMatching ||
        !(url.toString().match(dontCacheBustUrlsMatching))) {
      url.search += (url.search ? '&' : '') +
        encodeURIComponent(paramName) + '=' + encodeURIComponent(paramValue);
    }

    return url.toString();
  };

var isPathWhitelisted = function (whitelist, absoluteUrlString) {
    // If the whitelist is empty, then consider all URLs to be whitelisted.
    if (whitelist.length === 0) {
      return true;
    }

    // Otherwise compare each path regex to the path of the URL passed in.
    var path = (new URL(absoluteUrlString)).pathname;
    return whitelist.some(function(whitelistedPathRegex) {
      return path.match(whitelistedPathRegex);
    });
  };

var stripIgnoredUrlParameters = function (originalUrl,
    ignoreUrlParametersMatching) {
    var url = new URL(originalUrl);

    url.search = url.search.slice(1) // Exclude initial '?'
      .split('&') // Split into an array of 'key=value' strings
      .map(function(kv) {
        return kv.split('='); // Split each 'key=value' string into a [key, value] array
      })
      .filter(function(kv) {
        return ignoreUrlParametersMatching.every(function(ignoredRegex) {
          return !ignoredRegex.test(kv[0]); // Return true iff the key doesn't match any of the regexes.
        });
      })
      .map(function(kv) {
        return kv.join('='); // Join each [key, value] array into a 'key=value' string
      })
      .join('&'); // Join the array of 'key=value' strings into a string with '&' in between each

    return url.toString();
  };


var hashParamName = '_sw-precache';
var urlsToCacheKeys = new Map(
  precacheConfig.map(function(item) {
    var relativeUrl = item[0];
    var hash = item[1];
    var absoluteUrl = new URL(relativeUrl, self.location);
    var cacheKey = createCacheKey(absoluteUrl, hashParamName, hash, false);
    return [absoluteUrl.toString(), cacheKey];
  })
);

function setOfCachedUrls(cache) {
  return cache.keys().then(function(requests) {
    return requests.map(function(request) {
      return request.url;
    });
  }).then(function(urls) {
    return new Set(urls);
  });
}

self.addEventListener('install', function(event) {
  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return setOfCachedUrls(cache).then(function(cachedUrls) {
        return Promise.all(
          Array.from(urlsToCacheKeys.values()).map(function(cacheKey) {
            // If we don't have a key matching url in the cache already, add it.
            if (!cachedUrls.has(cacheKey)) {
              return cache.add(new Request(cacheKey, {
                credentials: 'same-origin',
                redirect: 'follow'
              }));
            }
          })
        );
      });
    }).then(function() {
      
      // Force the SW to transition from installing -> active state
      return self.skipWaiting();
      
    })
  );
});

self.addEventListener('activate', function(event) {
  var setOfExpectedUrls = new Set(urlsToCacheKeys.values());

  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return cache.keys().then(function(existingRequests) {
        return Promise.all(
          existingRequests.map(function(existingRequest) {
            if (!setOfExpectedUrls.has(existingRequest.url)) {
              return cache.delete(existingRequest);
            }
          })
        );
      });
    }).then(function() {
      
      return self.clients.claim();
      
    })
  );
});


self.addEventListener('fetch', function(event) {
  if (event.request.method === 'GET') {
    // Should we call event.respondWith() inside this fetch event handler?
    // This needs to be determined synchronously, which will give other fetch
    // handlers a chance to handle the request if need be.
    var shouldRespond;

    // First, remove all the ignored parameter and see if we have that URL
    // in our cache. If so, great! shouldRespond will be true.
    var url = stripIgnoredUrlParameters(event.request.url, ignoreUrlParametersMatching);
    shouldRespond = urlsToCacheKeys.has(url);

    // If shouldRespond is false, check again, this time with 'index.html'
    // (or whatever the directoryIndex option is set to) at the end.
    var directoryIndex = 'index.html';
    if (!shouldRespond && directoryIndex) {
      url = addDirectoryIndex(url, directoryIndex);
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond is still false, check to see if this is a navigation
    // request, and if so, whether the URL matches navigateFallbackWhitelist.
    var navigateFallback = '';
    if (!shouldRespond &&
        navigateFallback &&
        (event.request.mode === 'navigate') &&
        isPathWhitelisted([], event.request.url)) {
      url = new URL(navigateFallback, self.location).toString();
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond was set to true at any point, then call
    // event.respondWith(), using the appropriate cache key.
    if (shouldRespond) {
      event.respondWith(
        caches.open(cacheName).then(function(cache) {
          return cache.match(urlsToCacheKeys.get(url)).then(function(response) {
            if (response) {
              return response;
            }
            throw Error('The cached response that was expected is missing.');
          });
        }).catch(function(e) {
          // Fall back to just fetch()ing the request if some unexpected error
          // prevented the cached response from being valid.
          console.warn('Couldn\'t serve response for "%s" from cache: %O', event.request.url, e);
          return fetch(event.request);
        })
      );
    }
  }
});







