/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.mockito.internal.util.reflection.AccessibilityChanger;

public class BeanPropertySetter {
    private static final String SET_PREFIX = "set";
    private final Object target;
    private final boolean reportNoSetterFound;
    private final Field field;

    public BeanPropertySetter(Object target, Field propertyField, boolean reportNoSetterFound) {
        this.field = propertyField;
        this.target = target;
        this.reportNoSetterFound = reportNoSetterFound;
    }

    public BeanPropertySetter(Object target, Field propertyField) {
        this(target, propertyField, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean set(Object value) {
        AccessibilityChanger changer = new AccessibilityChanger();
        Method writeMethod = null;
        try {
            writeMethod = this.target.getClass().getMethod(this.setterName(this.field.getName()), this.field.getType());
            changer.enableAccess(writeMethod);
            writeMethod.invoke(this.target, value);
            boolean bl = true;
            if (writeMethod == null) return bl;
            changer.safelyDisableAccess(writeMethod);
            return bl;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Setter '" + writeMethod + "' of '" + this.target + "' with value '" + value + "' threw exception : '" + e.getTargetException() + "'", e);
            catch (IllegalAccessException e2) {
                throw new RuntimeException("Access not authorized on field '" + this.field + "' of object '" + this.target + "' with value: '" + value + "'", e2);
            }
            catch (NoSuchMethodException e3) {
                this.reportNoSetterFound();
            }
        }
        finally {
            if (writeMethod != null) {
                changer.safelyDisableAccess(writeMethod);
            }
        }
        this.reportNoSetterFound();
        return false;
    }

    private String setterName(String fieldName) {
        return SET_PREFIX + fieldName.substring(0, 1).toUpperCase(Locale.ENGLISH) + fieldName.substring(1);
    }

    private void reportNoSetterFound() {
        if (this.reportNoSetterFound) {
            throw new RuntimeException("Problems setting value on object: [" + this.target + "] for property : [" + this.field.getName() + "], setter not found");
        }
    }
}

