/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.InOrderImpl;
import org.mockito.internal.verification.InOrderWrapper;
import org.mockito.internal.verification.VerificationOverTimeImpl;
import org.mockito.internal.verification.VerificationWrapper;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.internal.verification.api.VerificationInOrderMode;
import org.mockito.verification.VerificationMode;

public class VerificationWrapperInOrderWrapper
implements VerificationMode {
    private final VerificationMode delegate;

    public VerificationWrapperInOrderWrapper(VerificationWrapper<?> verificationWrapper, InOrderImpl inOrder) {
        Object verificationMode = verificationWrapper.wrappedVerification;
        VerificationMode inOrderWrappedVerificationMode = this.wrapInOrder(verificationWrapper, (VerificationMode)verificationMode, inOrder);
        this.delegate = verificationWrapper.copySelfWithNewVerificationMode(inOrderWrappedVerificationMode);
    }

    @Override
    public void verify(VerificationData data) {
        this.delegate.verify(data);
    }

    private VerificationMode wrapInOrder(VerificationWrapper<?> verificationWrapper, VerificationMode verificationMode, InOrderImpl inOrder) {
        VerificationOverTimeImpl verificationOverTime;
        if (verificationMode instanceof VerificationInOrderMode) {
            VerificationInOrderMode verificationInOrderMode = (VerificationInOrderMode)((Object)verificationMode);
            return new InOrderWrapper(verificationInOrderMode, inOrder);
        }
        if (verificationMode instanceof VerificationOverTimeImpl && (verificationOverTime = (VerificationOverTimeImpl)verificationMode).isReturnOnSuccess()) {
            return new VerificationOverTimeImpl(verificationOverTime.getPollingPeriod(), verificationOverTime.getTimer().duration(), this.wrapInOrder(verificationWrapper, verificationOverTime.getDelegate(), inOrder), verificationOverTime.isReturnOnSuccess());
        }
        throw new MockitoException(verificationMode.getClass().getSimpleName() + " is not implemented to work with InOrder wrapped inside a " + verificationWrapper.getClass().getSimpleName());
    }
}

