/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.connector.base;

import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAResource;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.statistic.Stopwatch;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.cache.CachePolicy;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.base.BaseRepositorySource;
import org.modeshape.graph.connector.base.Node;
import org.modeshape.graph.connector.base.Repository;
import org.modeshape.graph.connector.base.Transaction;
import org.modeshape.graph.connector.base.Workspace;
import org.modeshape.graph.request.Request;
import org.modeshape.graph.request.processor.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class Connection<NodeType extends Node, WorkspaceType extends Workspace>
implements RepositoryConnection {
    private final BaseRepositorySource source;
    private final Repository<NodeType, WorkspaceType> repository;

    public Connection(BaseRepositorySource source, Repository<NodeType, WorkspaceType> repository) {
        assert (source != null);
        assert (repository != null);
        this.source = source;
        this.repository = repository;
    }

    @Override
    public String getSourceName() {
        return this.source.getName();
    }

    @Override
    public CachePolicy getDefaultCachePolicy() {
        return this.source.getDefaultCachePolicy();
    }

    @Override
    public XAResource getXAResource() {
        return null;
    }

    @Override
    public boolean ping(long time, TimeUnit unit) {
        return true;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void execute(ExecutionContext context, Request request) throws RepositorySourceException {
        Stopwatch sw;
        Logger logger;
        block32: {
            Object v0;
            RequestProcessor processor;
            Transaction<NodeType, WorkspaceType> txn;
            boolean commit;
            block27: {
                logger = context.getLogger(this.getClass());
                sw = null;
                if (logger.isTraceEnabled()) {
                    sw = new Stopwatch();
                    sw.start();
                }
                commit = true;
                txn = this.repository.startTransaction(context, request.isReadOnly());
                processor = this.repository.createRequestProcessor(txn);
                processor.process(request);
                if (!request.hasError() || request.isReadOnly()) break block27;
                commit = false;
            }
            Object var10_8 = null;
            try {
                processor.close();
                v0 = null;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var12_14 = v0;
            try {
                if (commit) {
                    txn.commit();
                } else {
                    txn.rollback();
                }
            }
            catch (Throwable commitOrRollbackError) {
                commitOrRollbackError.printStackTrace();
                if (commit && !request.hasError() && !request.isFrozen()) {
                    request.setError(commitOrRollbackError);
                }
                commit = false;
            }
            if (commit) {
                processor.notifyObserverOfChanges();
            }
            break block32;
            {
                catch (Throwable error) {
                    Object v1;
                    commit = false;
                    error.printStackTrace();
                    Object var10_9 = null;
                    try {
                        processor.close();
                        v1 = null;
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var12_15 = v1;
                    try {
                        if (commit) {
                            txn.commit();
                        } else {
                            txn.rollback();
                        }
                    }
                    catch (Throwable commitOrRollbackError) {
                        commitOrRollbackError.printStackTrace();
                        if (commit && !request.hasError() && !request.isFrozen()) {
                            request.setError(commitOrRollbackError);
                        }
                        commit = false;
                    }
                    if (commit) {
                        processor.notifyObserverOfChanges();
                    }
                }
            }
            catch (Throwable throwable) {
                Object v2;
                Object var10_10 = null;
                try {
                    processor.close();
                    v2 = null;
                }
                catch (Throwable throwable2) {
                    v2 = null;
                }
                Object var12_16 = v2;
                try {
                    if (commit) {
                        txn.commit();
                    } else {
                        txn.rollback();
                    }
                }
                catch (Throwable commitOrRollbackError) {
                    commitOrRollbackError.printStackTrace();
                    if (commit && !request.hasError() && !request.isFrozen()) {
                        request.setError(commitOrRollbackError);
                    }
                    commit = false;
                }
                if (commit) {
                    processor.notifyObserverOfChanges();
                }
                throw throwable;
            }
        }
        if (logger.isTraceEnabled()) {
            assert (sw != null);
            sw.stop();
            logger.trace("MapRepositoryConnection.execute(...) took " + sw.getTotalDuration(), new Object[0]);
        }
    }

    public String toString() {
        return "Connection to the \"" + this.getSourceName() + "\" " + this.repository.getClass().getSimpleName();
    }
}

