/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.graph.query.validate;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.i18n.I18n;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.query.QueryContext;
import org.modeshape.graph.query.model.AllNodes;
import org.modeshape.graph.query.model.ArithmeticOperand;
import org.modeshape.graph.query.model.ChildNode;
import org.modeshape.graph.query.model.ChildNodeJoinCondition;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.DescendantNode;
import org.modeshape.graph.query.model.DescendantNodeJoinCondition;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.EquiJoinCondition;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.FullTextSearchScore;
import org.modeshape.graph.query.model.Length;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.LowerCase;
import org.modeshape.graph.query.model.NamedSelector;
import org.modeshape.graph.query.model.NodeDepth;
import org.modeshape.graph.query.model.NodeLocalName;
import org.modeshape.graph.query.model.NodeName;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.Ordering;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.ReferenceValue;
import org.modeshape.graph.query.model.SameNode;
import org.modeshape.graph.query.model.SameNodeJoinCondition;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.Subquery;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.model.UpperCase;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.validate.Schemata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Validator
extends Visitors.AbstractVisitor {
    private final QueryContext context;
    private final Problems problems;
    private final Map<SelectorName, Schemata.Table> selectorsByNameOrAlias;
    private final Map<SelectorName, Schemata.Table> selectorsByName;
    private final Map<String, Schemata.Column> columnsByAlias;
    private final boolean validateColumnExistence;

    public Validator(QueryContext context, Map<SelectorName, Schemata.Table> selectorsByName) {
        this.context = context;
        this.problems = this.context.getProblems();
        this.selectorsByNameOrAlias = selectorsByName;
        this.selectorsByName = new HashMap<SelectorName, Schemata.Table>();
        for (Schemata.Table table : selectorsByName.values()) {
            this.selectorsByName.put(table.getName(), table);
        }
        this.columnsByAlias = new HashMap<String, Schemata.Column>();
        this.validateColumnExistence = context.getHints().validateColumnExistance;
    }

    @Override
    public void visit(AllNodes obj) {
        this.verifyTable(obj.name());
    }

    @Override
    public void visit(ArithmeticOperand obj) {
        this.verifyArithmeticOperand(obj.left());
        this.verifyArithmeticOperand(obj.right());
    }

    protected void verifyArithmeticOperand(DynamicOperand operand) {
        if (!(operand instanceof NodeDepth || operand instanceof Length || operand instanceof ArithmeticOperand || operand instanceof FullTextSearchScore)) {
            if (operand instanceof PropertyValue) {
                String propertyName;
                PropertyValue value = (PropertyValue)operand;
                SelectorName selector = value.selectorName();
                Schemata.Column column = this.verify(selector, propertyName = value.propertyName(), this.validateColumnExistence);
                if (column != null) {
                    String columnType = column.getPropertyType();
                    TypeSystem types = this.context.getTypeSystem();
                    String longType = types.getLongFactory().getTypeName();
                    String doubleType = types.getDoubleFactory().getTypeName();
                    if (!longType.equals(types.getCompatibleType(columnType, longType)) && !doubleType.equals(types.getCompatibleType(columnType, doubleType))) {
                        I18n msg = GraphI18n.columnTypeCannotBeUsedInArithmeticOperation;
                        this.problems.addError(msg, new Object[]{selector, propertyName, columnType});
                    }
                }
            } else {
                I18n msg = GraphI18n.dynamicOperandCannotBeUsedInArithmeticOperation;
                this.problems.addError(msg, new Object[]{operand});
            }
        }
    }

    @Override
    public void visit(ChildNode obj) {
        this.verify(obj.selectorName());
        this.verifyPath(obj.parentPath());
    }

    @Override
    public void visit(ChildNodeJoinCondition obj) {
        this.verify(obj.parentSelectorName());
        this.verify(obj.childSelectorName());
    }

    @Override
    public void visit(Column obj) {
        this.verify(obj.selectorName(), obj.propertyName(), this.validateColumnExistence);
    }

    @Override
    public void visit(Comparison obj) {
        this.verifyComparison(obj.operand1(), obj.operator(), obj.operand2());
    }

    @Override
    public void visit(DescendantNode obj) {
        this.verify(obj.selectorName());
        this.verifyPath(obj.ancestorPath());
    }

    @Override
    public void visit(DescendantNodeJoinCondition obj) {
        this.verify(obj.ancestorSelectorName());
        this.verify(obj.descendantSelectorName());
    }

    @Override
    public void visit(EquiJoinCondition obj) {
        this.verify(obj.selector1Name(), obj.property1Name(), this.validateColumnExistence);
        this.verify(obj.selector2Name(), obj.property2Name(), this.validateColumnExistence);
    }

    @Override
    public void visit(FullTextSearch obj) {
        SelectorName selectorName = obj.selectorName();
        if (obj.propertyName() != null) {
            Schemata.Column column = this.verify(selectorName, obj.propertyName(), this.validateColumnExistence);
            if (column != null && !column.isFullTextSearchable()) {
                this.problems.addError(GraphI18n.columnIsNotFullTextSearchable, new Object[]{column.getName(), selectorName});
            }
        } else {
            Schemata.Table table = this.verify(selectorName);
            if (table != null && !AllNodes.ALL_NODES_NAME.equals(table.getName())) {
                boolean searchable = false;
                for (Schemata.Column column : table.getColumns()) {
                    if (!column.isFullTextSearchable()) continue;
                    searchable = true;
                    break;
                }
                if (!searchable) {
                    this.problems.addError(GraphI18n.tableIsNotFullTextSearchable, new Object[]{selectorName});
                }
            }
        }
    }

    @Override
    public void visit(FullTextSearchScore obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(Length obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(LowerCase obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(NamedSelector obj) {
        this.verify(obj.aliasOrName());
    }

    @Override
    public void visit(NodeDepth obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(NodeLocalName obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(NodeName obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(NodePath obj) {
        this.verify(obj.selectorName());
    }

    @Override
    public void visit(Ordering obj) {
        this.verifyOrdering(obj.operand());
    }

    @Override
    public void visit(PropertyExistence obj) {
        this.verify(obj.selectorName(), obj.propertyName(), this.validateColumnExistence);
    }

    @Override
    public void visit(PropertyValue obj) {
        this.verify(obj.selectorName(), obj.propertyName(), this.validateColumnExistence);
    }

    @Override
    public void visit(ReferenceValue obj) {
        String propName = obj.propertyName();
        if (propName != null) {
            this.verify(obj.selectorName(), propName, this.validateColumnExistence);
        } else {
            this.verify(obj.selectorName());
        }
    }

    @Override
    public void visit(Query obj) {
        this.columnsByAlias.clear();
        for (Column column : obj.columns()) {
            Schemata.Column tableColumn;
            Schemata.Table table = this.tableWithNameOrAlias(column.selectorName());
            if (table == null || (tableColumn = table.getColumn(column.propertyName())) == null) continue;
            this.columnsByAlias.put(column.columnName(), tableColumn);
        }
        super.visit(obj);
    }

    @Override
    public void visit(Subquery subquery) {
    }

    @Override
    public void visit(SameNode obj) {
        this.verify(obj.selectorName());
        this.verifyPath(obj.path());
    }

    @Override
    public void visit(SameNodeJoinCondition obj) {
        this.verify(obj.selector1Name());
        this.verify(obj.selector2Name());
    }

    protected void verifyOrdering(DynamicOperand operand) {
        if (operand instanceof PropertyValue) {
            PropertyValue propValue = (PropertyValue)operand;
            this.verifyOrdering(propValue.selectorName(), propValue.propertyName());
        } else if (operand instanceof ReferenceValue) {
            ReferenceValue value = (ReferenceValue)operand;
            this.verifyOrdering(value.selectorName(), value.propertyName());
        } else if (operand instanceof Length) {
            Length length = (Length)operand;
            this.verifyOrdering(length.propertyValue());
        } else if (operand instanceof LowerCase) {
            this.verifyOrdering(((LowerCase)operand).operand());
        } else if (operand instanceof UpperCase) {
            this.verifyOrdering(((UpperCase)operand).operand());
        } else if (operand instanceof ArithmeticOperand) {
            ArithmeticOperand arith = (ArithmeticOperand)operand;
            this.verifyOrdering(arith.left());
            this.verifyOrdering(arith.right());
        }
    }

    protected void verifyOrdering(SelectorName selectorName, String propertyName) {
        Schemata.Column column = this.verify(selectorName, propertyName, false);
        if (column != null && !column.isOrderable()) {
            this.problems.addError(GraphI18n.columnInTableIsNotOrderable, new Object[]{propertyName, selectorName.getString()});
        }
    }

    protected String readable(Visitable visitable) {
        return Visitors.readable(visitable);
    }

    protected void verifyComparison(DynamicOperand operand, Operator op, StaticOperand rhs) {
        if (operand instanceof PropertyValue) {
            PropertyValue propValue = (PropertyValue)operand;
            this.verifyOperator(propValue.selectorName(), propValue.propertyName(), op);
        } else if (operand instanceof NodeName) {
            if (rhs instanceof Literal) {
                Path path;
                boolean fail = false;
                Literal literal = (Literal)rhs;
                Object value = literal.value();
                if (value instanceof Path && (path = (Path)value).size() > 1) {
                    fail = true;
                }
                if (value instanceof String || value instanceof Path || value instanceof URI || value instanceof Name || value instanceof Binary) {
                    String str = this.context.getTypeSystem().getStringFactory().asString(value);
                    try {
                        Path path2;
                        if (str.startsWith("./") && str.length() > 2) {
                            str = str.substring(2);
                        }
                        if ((path2 = (Path)this.context.getTypeSystem().getPathFactory().create(str)).isAbsolute() || path2.size() != 1) {
                            fail = true;
                        }
                    }
                    catch (ValueFormatException e) {
                        fail = true;
                    }
                    catch (IllegalArgumentException e) {
                        fail = true;
                    }
                } else {
                    fail = true;
                }
                if (fail) {
                    this.problems.addError(GraphI18n.nameOperandRequiresNameLiteralType, new Object[]{this.readable(operand), op.symbol(), this.readable(rhs)});
                }
            }
        } else if (operand instanceof ReferenceValue) {
            ReferenceValue value = (ReferenceValue)operand;
            this.verifyOperator(value.selectorName(), value.propertyName(), op);
        } else if (operand instanceof Length) {
            Length length = (Length)operand;
            this.verifyComparison(length.propertyValue(), op, rhs);
            if (rhs instanceof Literal) {
                try {
                    Literal literal = (Literal)rhs;
                    this.context.getTypeSystem().getLongFactory().create(literal.value());
                }
                catch (ValueFormatException e) {
                    this.problems.addError(GraphI18n.lengthOperandRequiresLongLiteralType, new Object[]{this.readable(operand), op.symbol(), this.readable(rhs)});
                }
            }
        } else if (operand instanceof LowerCase) {
            this.verifyComparison(((LowerCase)operand).operand(), op, rhs);
        } else if (operand instanceof UpperCase) {
            this.verifyComparison(((UpperCase)operand).operand(), op, rhs);
        } else if (operand instanceof ArithmeticOperand) {
            ArithmeticOperand arith = (ArithmeticOperand)operand;
            this.verifyComparison(arith.left(), op, rhs);
            this.verifyComparison(arith.right(), op, rhs);
        }
    }

    protected void verifyOperator(SelectorName selectorName, String propertyName, Operator op) {
        Schemata.Column column = this.verify(selectorName, propertyName, false);
        if (column != null && !column.getOperators().contains((Object)op)) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Operator allowed : column.getOperators()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(allowed.symbol());
            }
            this.problems.addError(GraphI18n.operatorIsNotValidAgainstColumnInTable, new Object[]{op.symbol(), propertyName, selectorName.getString(), sb});
        }
    }

    protected Schemata.Table tableWithNameOrAlias(SelectorName tableName) {
        Schemata.Table table = this.selectorsByNameOrAlias.get(tableName);
        if (table == null) {
            table = this.selectorsByName.get(tableName);
        }
        return table;
    }

    protected Schemata.Table verify(SelectorName selectorName) {
        Schemata.Table table = this.tableWithNameOrAlias(selectorName);
        if (table == null) {
            this.problems.addError(GraphI18n.tableDoesNotExist, new Object[]{selectorName.name()});
        }
        return table;
    }

    protected Schemata.Table verifyTable(SelectorName tableName) {
        Schemata.Table table = this.tableWithNameOrAlias(tableName);
        if (table == null) {
            this.problems.addError(GraphI18n.tableDoesNotExist, new Object[]{tableName.name()});
        }
        return table;
    }

    protected void verifyPath(String pathStr) {
        try {
            Path path = (Path)this.context.getTypeSystem().getPathFactory().create(pathStr);
            if (!path.isAbsolute()) {
                this.problems.addError(GraphI18n.pathIsNotAbsolute, new Object[]{pathStr});
            }
        }
        catch (IllegalArgumentException e) {
            this.problems.addError(GraphI18n.pathIsNotValid, new Object[]{pathStr});
        }
        catch (ValueFormatException e) {
            this.problems.addError(GraphI18n.pathIsNotValid, new Object[]{pathStr});
        }
    }

    protected Schemata.Column verify(SelectorName selectorName, String propertyName, boolean columnIsRequired) {
        Schemata.Table table = this.tableWithNameOrAlias(selectorName);
        if (table == null) {
            this.problems.addError(GraphI18n.tableDoesNotExist, new Object[]{selectorName.name()});
            return null;
        }
        Schemata.Column column = table.getColumn(propertyName);
        if (column == null && (column = this.columnsByAlias.get(propertyName)) == null && !"*".equals(propertyName) && columnIsRequired && !table.hasExtraColumns()) {
            this.problems.addError(GraphI18n.columnDoesNotExistOnTable, new Object[]{propertyName, selectorName.name()});
        }
        return column;
    }
}

