/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink;

import com.mongodb.ConnectionString;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.util.Validators;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigValue;

public class MongoSinkConfig
extends AbstractConfig {
    public static final String TOPICS_CONFIG = "topics";
    private static final String TOPICS_DISPLAY = "The Kafka topics";
    private static final String TOPICS_DOC = "A list of kafka topics for the sink connector.";
    public static final String CONNECTION_URI_CONFIG = "connection.uri";
    private static final String CONNECTION_URI_DEFAULT = "mongodb://localhost:27017";
    private static final String CONNECTION_URI_DISPLAY = "MongoDB Connection URI";
    private static final String CONNECTION_URI_DOC = "The connection URI as supported by the official drivers. eg: ``mongodb://user@pass@locahost/``.";
    public static final String TOPIC_OVERRIDE_CONFIG = "topic.override.%s.%s";
    private static final String TOPIC_OVERRIDE_DEFAULT = "";
    private static final String TOPIC_OVERRIDE_DISPLAY = "Per topic configuration overrides.";
    public static final String TOPIC_OVERRIDE_DOC = "The overrides configuration allows for per topic customization of configuration. The customized overrides are merged with the default configuration, to create the specific configuration for a topic.\nFor example, ``topic.override.foo.collection=bar`` will store data from the ``foo`` topic into the ``bar`` collection.\nNote: All configuration options apart from 'connection.uri' and 'topics' are overridable.";
    private Map<String, String> originals;
    private final List<String> topics;
    private Map<String, MongoSinkTopicConfig> topicSinkConnectorConfigMap;
    private ConnectionString connectionString;
    public static final ConfigDef CONFIG = MongoSinkConfig.createConfigDef();

    MongoSinkConfig(Map<String, String> originals) {
        super(CONFIG, originals, false);
        this.originals = Collections.unmodifiableMap(originals);
        this.topics = Collections.unmodifiableList(this.getList(TOPICS_CONFIG));
        this.connectionString = new ConnectionString(this.getString(CONNECTION_URI_CONFIG));
        this.topics.forEach(this::getMongoSinkTopicConfig);
    }

    public static String createOverrideKey(String topic, String config) {
        if (!CONFIG.configKeys().containsKey(config)) {
            throw new ConfigException("Unknown configuration key: " + config);
        }
        return String.format(TOPIC_OVERRIDE_CONFIG, topic, config);
    }

    public ConnectionString getConnectionString() {
        return this.connectionString;
    }

    List<String> getTopics() {
        return this.topics;
    }

    MongoSinkTopicConfig getMongoSinkTopicConfig(String topic) {
        if (!this.topics.contains(topic)) {
            throw new IllegalArgumentException(String.format("Unknown topic: %s, must be one of: %s", topic, this.topics));
        }
        if (this.topicSinkConnectorConfigMap == null) {
            this.createMongoSinkTopicConfig();
        }
        return this.topicSinkConnectorConfigMap.get(topic);
    }

    private void createMongoSinkTopicConfig() {
        this.topicSinkConnectorConfigMap = this.topics.stream().collect(Collectors.toMap(t -> t, t -> new MongoSinkTopicConfig((String)t, this.originals)));
    }

    private static ConfigDef createConfigDef() {
        ConfigDef configDef = new ConfigDef(){

            public Map<String, ConfigValue> validateAll(Map<String, String> props) {
                Map results = super.validateAll(props);
                if (results.values().stream().anyMatch(c -> !c.errorMessages().isEmpty())) {
                    return results;
                }
                List topics = (List)((ConfigValue)results.get(MongoSinkConfig.TOPICS_CONFIG)).value();
                topics.forEach(topic -> results.putAll(MongoSinkTopicConfig.validateAll(topic, props)));
                return results;
            }
        };
        String group = "Connection";
        int orderInGroup = 0;
        configDef.define(TOPICS_CONFIG, ConfigDef.Type.LIST, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)Validators.nonEmptyList(), ConfigDef.Importance.HIGH, TOPICS_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TOPICS_DISPLAY);
        configDef.define(CONNECTION_URI_CONFIG, ConfigDef.Type.STRING, (Object)CONNECTION_URI_DEFAULT, (ConfigDef.Validator)Validators.errorCheckingValueValidator("A valid connection string", ConnectionString::new), ConfigDef.Importance.HIGH, CONNECTION_URI_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, CONNECTION_URI_DISPLAY);
        group = "Overrides";
        orderInGroup = 0;
        configDef.define(TOPIC_OVERRIDE_CONFIG, ConfigDef.Type.STRING, (Object)TOPIC_OVERRIDE_DEFAULT, (ConfigDef.Validator)Validators.topicOverrideValidator(), ConfigDef.Importance.LOW, TOPIC_OVERRIDE_DOC, group, ++orderInGroup, ConfigDef.Width.MEDIUM, TOPIC_OVERRIDE_DISPLAY);
        MongoSinkTopicConfig.BASE_CONFIG.configKeys().values().forEach(arg_0 -> ((ConfigDef)configDef).define(arg_0));
        return configDef;
    }
}

