/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.cdc.debezium.rdbms;

import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.kafka.connect.sink.cdc.CdcOperation;
import com.mongodb.kafka.connect.sink.cdc.debezium.OperationType;
import com.mongodb.kafka.connect.sink.cdc.debezium.rdbms.RdbmsHandler;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class RdbmsUpdate
implements CdcOperation {
    private static final ReplaceOptions REPLACE_OPTIONS = new ReplaceOptions().upsert(true);

    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc) {
        BsonDocument keyDoc = doc.getKeyDoc().orElseThrow(() -> new DataException("Error: key doc must not be missing for update operation"));
        BsonDocument valueDoc = doc.getValueDoc().orElseThrow(() -> new DataException("Error: value doc must not be missing for update operation"));
        try {
            BsonDocument filterDoc = RdbmsHandler.generateFilterDoc(keyDoc, valueDoc, OperationType.UPDATE);
            BsonDocument replaceDoc = RdbmsHandler.generateUpsertOrReplaceDoc(keyDoc, valueDoc, filterDoc);
            return new ReplaceOneModel<BsonDocument>((Bson)filterDoc, replaceDoc, REPLACE_OPTIONS);
        }
        catch (Exception exc) {
            throw new DataException((Throwable)exc);
        }
    }
}

