/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.converter;

import com.mongodb.kafka.connect.sink.converter.AvroJsonSchemafulRecordConverter;
import com.mongodb.kafka.connect.sink.converter.JsonRawStringRecordConverter;
import com.mongodb.kafka.connect.sink.converter.JsonSchemalessRecordConverter;
import com.mongodb.kafka.connect.sink.converter.RecordConverter;
import com.mongodb.kafka.connect.sink.converter.SinkDocument;
import java.util.Map;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;
import org.apache.kafka.connect.sink.SinkRecord;
import org.bson.BsonDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinkConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SinkConverter.class);
    private final RecordConverter schemafulConverter = new AvroJsonSchemafulRecordConverter();
    private final RecordConverter schemalessConverter = new JsonSchemalessRecordConverter();
    private final RecordConverter rawConverter = new JsonRawStringRecordConverter();

    public SinkDocument convert(SinkRecord record) {
        LOGGER.debug(record.toString());
        BsonDocument keyDoc = null;
        if (record.key() != null) {
            keyDoc = this.getRecordConverter(record.key(), record.keySchema()).convert(record.keySchema(), record.key());
        }
        BsonDocument valueDoc = null;
        if (record.value() != null) {
            valueDoc = this.getRecordConverter(record.value(), record.valueSchema()).convert(record.valueSchema(), record.value());
        }
        return new SinkDocument(keyDoc, valueDoc);
    }

    private RecordConverter getRecordConverter(Object data, Schema schema) {
        if (schema != null && data instanceof Struct) {
            LOGGER.debug("using schemaful converter");
            return this.schemafulConverter;
        }
        if (data instanceof Map) {
            LOGGER.debug("using schemaless converter");
            return this.schemalessConverter;
        }
        if (data instanceof String) {
            LOGGER.debug("using raw converter");
            return this.rawConverter;
        }
        throw new DataException("Error: no converter present due to unexpected object type " + data.getClass().getName());
    }
}

