/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.processor.DocumentIdAdder;
import com.mongodb.kafka.connect.sink.processor.PostProcessor;
import com.mongodb.kafka.connect.util.ClassHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PostProcessors {
    private final List<PostProcessor> postProcessorList;

    public PostProcessors(MongoSinkTopicConfig config, List<String> classes) {
        ArrayList<PostProcessor> postProcessors = new ArrayList<PostProcessor>();
        boolean hasDocumentIdAdder = false;
        for (String c : classes) {
            if (c.equals(DocumentIdAdder.class.getName())) {
                hasDocumentIdAdder = true;
            }
            postProcessors.add(ClassHelper.createInstance("post.processor.chain", c, PostProcessor.class, Collections.singletonList(MongoSinkTopicConfig.class), Collections.singletonList(config)));
        }
        if (!hasDocumentIdAdder) {
            postProcessors.add(0, new DocumentIdAdder(config));
        }
        this.postProcessorList = Collections.unmodifiableList(postProcessors);
    }

    public List<PostProcessor> getPostProcessorList() {
        return this.postProcessorList;
    }
}

