/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.field.projection;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.processor.field.projection.FieldProjector;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public abstract class BlacklistProjector
extends FieldProjector {
    public BlacklistProjector(MongoSinkTopicConfig config, Set<String> fields) {
        super(config, fields);
    }

    protected boolean isUsingBlacklistKeyProjection() {
        return this.getConfig().getString("key.projection.type").equalsIgnoreCase(MongoSinkTopicConfig.FieldProjectionType.BLACKLIST.name());
    }

    protected boolean isUsingBlacklistValueProjection() {
        return this.getConfig().getString("value.projection.type").equalsIgnoreCase(MongoSinkTopicConfig.FieldProjectionType.BLACKLIST.name());
    }

    @Override
    protected void doProjection(String field, BsonDocument doc) {
        String otherParts;
        if (!field.contains(".")) {
            if (field.equals("*") || field.equals("**")) {
                this.handleWildcard(field, "", doc);
                return;
            }
            if (!field.equals("_id")) {
                doc.remove(field);
            }
            return;
        }
        int dotIdx = field.indexOf(".");
        String firstPart = field.substring(0, dotIdx);
        String string = otherParts = field.length() >= dotIdx ? field.substring(dotIdx + 1) : "";
        if (firstPart.equals("*") || firstPart.equals("**")) {
            this.handleWildcard(firstPart, otherParts, doc);
            return;
        }
        BsonValue value = doc.get(firstPart);
        if (value != null) {
            if (value.isDocument()) {
                this.doProjection(otherParts, value.asDocument());
            }
            if (value.isArray()) {
                BsonArray values = value.asArray();
                for (BsonValue v : values.getValues()) {
                    if (v == null || !v.isDocument()) continue;
                    this.doProjection(otherParts, v.asDocument());
                }
            }
        }
    }

    private void handleWildcard(String firstPart, String otherParts, BsonDocument doc) {
        Iterator<Map.Entry<String, BsonValue>> iter = doc.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, BsonValue> entry = iter.next();
            BsonValue value = entry.getValue();
            if (entry.getKey().equals("_id")) continue;
            if (firstPart.equals("**")) {
                iter.remove();
                continue;
            }
            if (!firstPart.equals("*")) continue;
            if (!value.isDocument()) {
                iter.remove();
                continue;
            }
            if (otherParts.isEmpty()) continue;
            this.doProjection(otherParts, (BsonDocument)value);
        }
    }
}

