/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.sink.processor.field.projection;

import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.processor.field.projection.FieldProjector;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public abstract class WhitelistProjector
extends FieldProjector {
    public WhitelistProjector(MongoSinkTopicConfig config, Set<String> fields) {
        super(config, fields);
    }

    protected boolean isUsingWhitelistKeyProjection() {
        return this.getConfig().getString("key.projection.type").equalsIgnoreCase(MongoSinkTopicConfig.FieldProjectionType.WHITELIST.name());
    }

    protected boolean isUsingWhitelistValueProjection() {
        return this.getConfig().getString("value.projection.type").equalsIgnoreCase(MongoSinkTopicConfig.FieldProjectionType.WHITELIST.name());
    }

    @Override
    protected void doProjection(String field, BsonDocument doc) {
        if (this.getFields().contains("**")) {
            return;
        }
        Iterator<Map.Entry<String, BsonValue>> iter = doc.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, BsonValue> entry = iter.next();
            String key = field.isEmpty() ? entry.getKey() : field + "." + entry.getKey();
            BsonValue value = entry.getValue();
            if (!(this.getFields().contains(key) || key.equals("_id") || this.checkForWildcardMatch(key))) {
                iter.remove();
            }
            if (value == null) continue;
            if (value.isDocument()) {
                String matchDoubleWildCard = key + "." + "**";
                if (!this.getFields().contains(matchDoubleWildCard)) {
                    this.doProjection(key, (BsonDocument)value);
                }
            }
            if (!value.isArray()) continue;
            BsonArray values = (BsonArray)value;
            for (BsonValue v : values.getValues()) {
                if (v == null || !v.isDocument()) continue;
                this.doProjection(key, (BsonDocument)v);
            }
        }
    }

    private boolean checkForWildcardMatch(String key) {
        String[] keyParts = key.split("\\.");
        Object[] pattern = new String[keyParts.length];
        Arrays.fill(pattern, "*");
        for (int c = (int)Math.pow(2.0, keyParts.length) - 1; c >= 0; --c) {
            int mask = 1;
            for (int d = keyParts.length - 1; d >= 0; --d) {
                if ((c & mask) != 0) {
                    pattern[d] = keyParts[d];
                }
                mask <<= 1;
            }
            if (this.getFields().contains(String.join((CharSequence)".", (CharSequence[])pattern))) {
                return true;
            }
            Arrays.fill(pattern, "*");
        }
        return false;
    }
}

