/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public final class Validators {
    public static ValidatorWithOperators emptyString() {
        return Validators.withStringDef("An empty string", (name, value) -> {
            if (!((String)value).isEmpty()) {
                throw new ConfigException(name, value, "Not empty");
            }
        });
    }

    public static ValidatorWithOperators matching(Pattern pattern) {
        return Validators.withStringDef(String.format("A string matching `%s`", pattern), (name, value) -> {
            if (!pattern.matcher((String)value).matches()) {
                throw new ConfigException(name, value, "Does not match: " + pattern);
            }
        });
    }

    public static ValidatorWithOperators listMatchingPattern(Pattern pattern) {
        return Validators.withStringDef(String.format("A list matching: `%s`", pattern), (name, value) -> ((List)value).forEach(v -> {
            if (!pattern.matcher((String)v).matches()) {
                throw new ConfigException(name, value, "Contains an invalid value. Does not match: " + pattern);
            }
        }));
    }

    public static ValidatorWithOperators nonEmptyList() {
        return Validators.withStringDef("A non-empty list", (name, value) -> {
            if (value != null && ((List)value).isEmpty()) {
                throw new ConfigException(name, value, "Empty list");
            }
        });
    }

    public static ValidatorWithOperators topicOverrideValidator() {
        return Validators.withStringDef("Topic override", (name, value) -> {
            if (!((String)value).isEmpty()) {
                throw new ConfigException(name, value, "This configuration shouldn't be set directly. See the documentation about how to configure topic based overrides.\nThe overrides configuration allows for per topic customization of configuration. The customized overrides are merged with the default configuration, to create the specific configuration for a topic.\nFor example, ``topic.override.foo.collection=bar`` will store data from the ``foo`` topic into the ``bar`` collection.\nNote: All configuration options apart from 'connection.uri' and 'topics' are overridable.");
            }
        });
    }

    public static ValidatorWithOperators errorCheckingValueValidator(String validValuesString, Consumer<String> consumer) {
        return Validators.withStringDef(validValuesString, (name, value) -> {
            try {
                consumer.accept((String)value);
            }
            catch (Exception e) {
                throw new ConfigException(name, value, e.getMessage());
            }
        });
    }

    public static ValidatorWithOperators withStringDef(final String validatorString, final ConfigDef.Validator validator) {
        return new ValidatorWithOperators(){

            public void ensureValid(String name, Object value) {
                validator.ensureValid(name, value);
            }

            public String toString() {
                return validatorString;
            }
        };
    }

    private Validators() {
    }

    public static final class EnumValidatorAndRecommender
    implements ValidatorWithOperators,
    ConfigDef.Recommender {
        private final List<String> values;

        private EnumValidatorAndRecommender(List<String> values) {
            this.values = values;
        }

        public static <E> EnumValidatorAndRecommender in(E[] enumerators) {
            return EnumValidatorAndRecommender.in(enumerators, Object::toString);
        }

        public static <E> EnumValidatorAndRecommender in(E[] enumerators, Function<E, String> mapper) {
            ArrayList<String> values = new ArrayList<String>(enumerators.length);
            for (E e : enumerators) {
                values.add(mapper.apply(e).toLowerCase());
            }
            return new EnumValidatorAndRecommender(values);
        }

        public void ensureValid(String key, Object value) {
            String enumValue = (String)value;
            if (!this.values.contains(enumValue.toLowerCase())) {
                throw new ConfigException(key, value, String.format("Invalid enumerator value. Should be one of: %s", this.values));
            }
        }

        public String toString() {
            return this.values.toString();
        }

        public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
            return new ArrayList<Object>(this.values);
        }

        public boolean visible(String name, Map<String, Object> parsedConfig) {
            return true;
        }
    }

    public static interface ValidatorWithOperators
    extends ConfigDef.Validator {
        default public ValidatorWithOperators or(ValidatorWithOperators other) {
            return Validators.withStringDef(String.format("%s OR %s", this.toString(), other.toString()), (name, value) -> {
                try {
                    this.ensureValid(name, value);
                }
                catch (ConfigException e) {
                    other.ensureValid(name, value);
                }
            });
        }
    }
}

