/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.ClusterDescription;
import com.mongodb.DBObject;
import com.mongodb.ServerDescription;
import com.mongodb.TaggableReadPreference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReadPreference {
    @Deprecated
    public static final ReadPreference PRIMARY;
    @Deprecated
    public static final ReadPreference SECONDARY;
    private static final ReadPreference _PRIMARY;
    private static final ReadPreference _SECONDARY;
    private static final ReadPreference _SECONDARY_PREFERRED;
    private static final ReadPreference _PRIMARY_PREFERRED;
    private static final ReadPreference _NEAREST;

    ReadPreference() {
    }

    public abstract boolean isSlaveOk();

    public abstract DBObject toDBObject();

    public abstract String getName();

    abstract List<ServerDescription> choose(ClusterDescription var1);

    public static ReadPreference primary() {
        return _PRIMARY;
    }

    public static ReadPreference primaryPreferred() {
        return _PRIMARY_PREFERRED;
    }

    public static TaggableReadPreference primaryPreferred(DBObject firstTagSet, DBObject ... remainingTagSets) {
        return new TaggableReadPreference.PrimaryPreferredReadPreference(firstTagSet, remainingTagSets);
    }

    public static ReadPreference secondary() {
        return _SECONDARY;
    }

    public static TaggableReadPreference secondary(DBObject firstTagSet, DBObject ... remainingTagSets) {
        return new TaggableReadPreference.SecondaryReadPreference(firstTagSet, remainingTagSets);
    }

    public static ReadPreference secondaryPreferred() {
        return _SECONDARY_PREFERRED;
    }

    public static TaggableReadPreference secondaryPreferred(DBObject firstTagSet, DBObject ... remainingTagSets) {
        return new TaggableReadPreference.SecondaryPreferredReadPreference(firstTagSet, remainingTagSets);
    }

    public static ReadPreference nearest() {
        return _NEAREST;
    }

    public static ReadPreference valueOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if ((name = name.toLowerCase()).equals(_PRIMARY.getName().toLowerCase())) {
            return _PRIMARY;
        }
        if (name.equals(_SECONDARY.getName().toLowerCase())) {
            return _SECONDARY;
        }
        if (name.equals(_SECONDARY_PREFERRED.getName().toLowerCase())) {
            return _SECONDARY_PREFERRED;
        }
        if (name.equals(_PRIMARY_PREFERRED.getName().toLowerCase())) {
            return _PRIMARY_PREFERRED;
        }
        if (name.equals(_NEAREST.getName().toLowerCase())) {
            return _NEAREST;
        }
        throw new IllegalArgumentException("No match for read preference of " + name);
    }

    public static TaggableReadPreference valueOf(String name, DBObject firstTagSet, DBObject ... remainingTagSets) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if ((name = name.toLowerCase()).equals(_SECONDARY.getName().toLowerCase())) {
            return new TaggableReadPreference.SecondaryReadPreference(firstTagSet, remainingTagSets);
        }
        if (name.equals(_SECONDARY_PREFERRED.getName().toLowerCase())) {
            return new TaggableReadPreference.SecondaryPreferredReadPreference(firstTagSet, remainingTagSets);
        }
        if (name.equals(_PRIMARY_PREFERRED.getName().toLowerCase())) {
            return new TaggableReadPreference.PrimaryPreferredReadPreference(firstTagSet, remainingTagSets);
        }
        if (name.equals(_NEAREST.getName().toLowerCase())) {
            return new TaggableReadPreference.NearestReadPreference(firstTagSet, remainingTagSets);
        }
        throw new IllegalArgumentException("No match for read preference of " + name);
    }

    public static TaggableReadPreference nearest(DBObject firstTagSet, DBObject ... remainingTagSets) {
        return new TaggableReadPreference.NearestReadPreference(firstTagSet, remainingTagSets);
    }

    @Deprecated
    public static ReadPreference withTags(Map<String, String> tags) {
        return new TaggedReadPreference(tags);
    }

    @Deprecated
    public static ReadPreference withTags(DBObject tags) {
        return new TaggedReadPreference(tags);
    }

    static {
        _PRIMARY = new PrimaryReadPreference();
        _SECONDARY = new TaggableReadPreference.SecondaryReadPreference();
        _SECONDARY_PREFERRED = new TaggableReadPreference.SecondaryPreferredReadPreference();
        _PRIMARY_PREFERRED = new TaggableReadPreference.PrimaryPreferredReadPreference();
        _NEAREST = new TaggableReadPreference.NearestReadPreference();
        PRIMARY = _PRIMARY;
        SECONDARY = _SECONDARY_PREFERRED;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static class TaggedReadPreference
    extends ReadPreference {
        private final DBObject _tags;
        private final ReadPreference _pref;

        public TaggedReadPreference(Map<String, String> tags) {
            if (tags == null || tags.size() == 0) {
                throw new IllegalArgumentException("tags can not be null or empty");
            }
            this._tags = new BasicDBObject(tags);
            List<DBObject> maps = TaggedReadPreference.splitMapIntoMultipleMaps(this._tags);
            this._pref = new TaggableReadPreference.SecondaryReadPreference(maps.get(0), this.getRemainingMaps(maps));
        }

        public TaggedReadPreference(DBObject tags) {
            if (tags == null || tags.keySet().size() == 0) {
                throw new IllegalArgumentException("tags can not be null or empty");
            }
            this._tags = tags;
            List<DBObject> maps = TaggedReadPreference.splitMapIntoMultipleMaps(this._tags);
            this._pref = new TaggableReadPreference.SecondaryReadPreference(maps.get(0), this.getRemainingMaps(maps));
        }

        public DBObject getTags() {
            BasicDBObject tags = new BasicDBObject();
            for (String key : this._tags.keySet()) {
                tags.put(key, this._tags.get(key));
            }
            return tags;
        }

        @Override
        public boolean isSlaveOk() {
            return this._pref.isSlaveOk();
        }

        @Override
        List<ServerDescription> choose(ClusterDescription clusterDescription) {
            return this._pref.choose(clusterDescription);
        }

        @Override
        public DBObject toDBObject() {
            return this._pref.toDBObject();
        }

        @Override
        public String getName() {
            return this._pref.getName();
        }

        private static List<DBObject> splitMapIntoMultipleMaps(DBObject tags) {
            ArrayList<DBObject> tagList = new ArrayList<DBObject>(tags.keySet().size());
            for (String key : tags.keySet()) {
                tagList.add(new BasicDBObject(key, tags.get(key).toString()));
            }
            return tagList;
        }

        private DBObject[] getRemainingMaps(List<DBObject> maps) {
            if (maps.size() <= 1) {
                return new DBObject[0];
            }
            return maps.subList(1, maps.size() - 1).toArray(new DBObject[maps.size() - 1]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PrimaryReadPreference
    extends ReadPreference {
        private PrimaryReadPreference() {
        }

        @Override
        public boolean isSlaveOk() {
            return false;
        }

        public String toString() {
            return this.getName();
        }

        public boolean equals(Object o) {
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        List<ServerDescription> choose(ClusterDescription clusterDescription) {
            return clusterDescription.getPrimaries();
        }

        @Override
        public DBObject toDBObject() {
            return new BasicDBObject("mode", this.getName());
        }

        @Override
        public String getName() {
            return "primary";
        }
    }
}

