/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.Function;
import com.mongodb.MongoChangeStreamException;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.binding.ReadBinding;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.ChangeStreamBatchCursorHelper;
import com.mongodb.operation.ChangeStreamOperation;
import java.util.ArrayList;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.RawBsonDocument;

final class ChangeStreamBatchCursor<T>
implements BatchCursor<T> {
    private final ReadBinding binding;
    private final ChangeStreamOperation<T> changeStreamOperation;
    private BsonDocument resumeToken;
    private BatchCursor<RawBsonDocument> wrapped;

    ChangeStreamBatchCursor(ChangeStreamOperation<T> changeStreamOperation, BatchCursor<RawBsonDocument> wrapped, ReadBinding binding) {
        changeStreamOperation.startOperationTimeForResume(binding.getSessionContext().getOperationTime());
        this.changeStreamOperation = changeStreamOperation;
        this.resumeToken = changeStreamOperation.getResumeToken();
        this.wrapped = wrapped;
        this.binding = binding.retain();
    }

    BatchCursor<RawBsonDocument> getWrapped() {
        return this.wrapped;
    }

    @Override
    public boolean hasNext() {
        return this.resumeableOperation(new Function<BatchCursor<RawBsonDocument>, Boolean>(){

            @Override
            public Boolean apply(BatchCursor<RawBsonDocument> queryBatchCursor) {
                return queryBatchCursor.hasNext();
            }
        });
    }

    @Override
    public List<T> next() {
        return (List)this.resumeableOperation(new Function<BatchCursor<RawBsonDocument>, List<T>>(){

            @Override
            public List<T> apply(BatchCursor<RawBsonDocument> queryBatchCursor) {
                return ChangeStreamBatchCursor.this.convertResults(queryBatchCursor.next());
            }
        });
    }

    @Override
    public List<T> tryNext() {
        return (List)this.resumeableOperation(new Function<BatchCursor<RawBsonDocument>, List<T>>(){

            @Override
            public List<T> apply(BatchCursor<RawBsonDocument> queryBatchCursor) {
                return ChangeStreamBatchCursor.this.convertResults(queryBatchCursor.tryNext());
            }
        });
    }

    @Override
    public void close() {
        this.wrapped.close();
        this.binding.release();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.wrapped.setBatchSize(batchSize);
    }

    @Override
    public int getBatchSize() {
        return this.wrapped.getBatchSize();
    }

    @Override
    public ServerCursor getServerCursor() {
        return this.wrapped.getServerCursor();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.wrapped.getServerAddress();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    private List<T> convertResults(List<RawBsonDocument> rawDocuments) {
        ArrayList<T> results = null;
        if (rawDocuments != null) {
            results = new ArrayList<T>();
            for (RawBsonDocument rawDocument : rawDocuments) {
                if (!rawDocument.containsKey("_id")) {
                    throw new MongoChangeStreamException("Cannot provide resume functionality when the resume token is missing.");
                }
                this.resumeToken = rawDocument.getDocument("_id");
                results.add(rawDocument.decode(this.changeStreamOperation.getDecoder()));
            }
        }
        return results;
    }

    <R> R resumeableOperation(Function<BatchCursor<RawBsonDocument>, R> function) {
        while (true) {
            try {
                return function.apply(this.wrapped);
            }
            catch (Throwable t) {
                if (!ChangeStreamBatchCursorHelper.isRetryableError(t)) {
                    throw MongoException.fromThrowableNonNull(t);
                }
                this.wrapped.close();
                if (this.resumeToken != null) {
                    this.changeStreamOperation.startOperationTimeForResume(null);
                    this.changeStreamOperation.resumeAfter(this.resumeToken);
                }
                this.wrapped = ((ChangeStreamBatchCursor)this.changeStreamOperation.execute(this.binding)).getWrapped();
                this.binding.release();
                continue;
            }
            break;
        }
    }
}

