/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.binding.AsyncReadWriteBinding;
import com.mongodb.internal.binding.AsyncSingleServerBinding;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Server;
import com.mongodb.internal.selector.ReadPreferenceServerSelector;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.internal.session.SessionContext;

class ClientSessionBinding
implements AsyncReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final AsyncClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    ClientSessionBinding(AsyncClientSession session, boolean ownsSession, AsyncClusterAwareReadWriteBinding wrapped) {
        this.wrapped = Assertions.notNull("wrapped", wrapped);
        this.ownsSession = ownsSession;
        this.session = Assertions.notNull("session", session);
        this.sessionContext = new AsyncClientSessionContext(session);
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public void getReadConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getReadConnectionSource(new SingleResultCallback<AsyncConnectionSource>(){

            @Override
            public void onResult(AsyncConnectionSource result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    ClientSessionBinding.this.wrapConnectionSource(result, callback);
                }
            }
        });
    }

    @Override
    public void getWriteConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getWriteConnectionSource(new SingleResultCallback<AsyncConnectionSource>(){

            @Override
            public void onResult(AsyncConnectionSource result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    ClientSessionBinding.this.wrapConnectionSource(result, callback);
                }
            }
        });
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    private void wrapConnectionSource(AsyncConnectionSource connectionSource, final SingleResultCallback<AsyncConnectionSource> callback) {
        if (this.isActiveShardedTxn()) {
            if (this.session.getPinnedServerAddress() == null) {
                this.wrapped.getCluster().selectServerAsync(new ReadPreferenceServerSelector(this.wrapped.getReadPreference()), new SingleResultCallback<Server>(){

                    @Override
                    public void onResult(Server server, Throwable t) {
                        if (t != null) {
                            callback.onResult(null, t);
                        } else {
                            ClientSessionBinding.this.session.setPinnedServerAddress(server.getDescription().getAddress());
                            ClientSessionBinding.this.setSingleServerBindingConnectionSource(callback);
                        }
                    }
                });
            } else {
                this.setSingleServerBindingConnectionSource(callback);
            }
        } else {
            callback.onResult(new SessionBindingAsyncConnectionSource(connectionSource), null);
        }
    }

    private void setSingleServerBindingConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        final AsyncSingleServerBinding binding = new AsyncSingleServerBinding(this.wrapped.getCluster(), this.session.getPinnedServerAddress(), this.wrapped.getReadPreference());
        binding.getWriteConnectionSource(new SingleResultCallback<AsyncConnectionSource>(){

            @Override
            public void onResult(AsyncConnectionSource result, Throwable t) {
                binding.release();
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new SessionBindingAsyncConnectionSource(result), null);
                }
            }
        });
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public AsyncReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public void release() {
        this.wrapped.release();
        this.closeSessionIfCountIsZero();
    }

    private void closeSessionIfCountIsZero() {
        if (this.getCount() == 0 && this.ownsSession) {
            this.session.close();
        }
    }

    private boolean isActiveShardedTxn() {
        return this.session.hasActiveTransaction() && this.wrapped.getCluster().getDescription().getType() == ClusterType.SHARDED;
    }

    private final class AsyncClientSessionContext
    extends ClientSessionContext
    implements SessionContext {
        private final AsyncClientSession clientSession;

        AsyncClientSessionContext(AsyncClientSession clientSession) {
            super(clientSession);
            this.clientSession = clientSession;
        }

        @Override
        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        @Override
        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        @Override
        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        @Override
        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return this.clientSession.getTransactionOptions().getReadConcern();
            }
            return ClientSessionBinding.this.wrapped.getSessionContext().getReadConcern();
        }
    }

    private class SessionBindingAsyncConnectionSource
    implements AsyncConnectionSource {
        private AsyncConnectionSource wrapped;

        SessionBindingAsyncConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        @Override
        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            this.wrapped.getConnection(callback);
        }

        @Override
        public AsyncConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public void release() {
            this.wrapped.release();
            ClientSessionBinding.this.closeSessionIfCountIsZero();
        }
    }
}

