/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.logging;

import com.mongodb.connection.ClusterId;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.logging.StructuredLogMessage;
import com.mongodb.internal.logging.StructuredLoggingInterceptor;
import com.mongodb.lang.Nullable;
import java.util.concurrent.ConcurrentHashMap;

public final class StructuredLogger {
    private static final ConcurrentHashMap<String, StructuredLoggingInterceptor> INTERCEPTORS = new ConcurrentHashMap();
    private final Logger logger;

    public static void addInterceptor(String clusterDescription, StructuredLoggingInterceptor interceptor) {
        INTERCEPTORS.put(clusterDescription, interceptor);
    }

    public static void removeInterceptor(String clusterDescription) {
        INTERCEPTORS.remove(clusterDescription);
    }

    @Nullable
    private static StructuredLoggingInterceptor getInterceptor(@Nullable String clusterDescription) {
        if (clusterDescription == null) {
            return null;
        }
        return INTERCEPTORS.get(clusterDescription);
    }

    public StructuredLogger(String suffix) {
        this(Loggers.getLogger(suffix));
    }

    public StructuredLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isRequired(StructuredLogMessage.Level level, ClusterId clusterId) {
        if (StructuredLogger.getInterceptor(clusterId.getDescription()) != null) {
            return true;
        }
        switch (level) {
            case DEBUG: {
                return this.logger.isDebugEnabled();
            }
        }
        throw new UnsupportedOperationException();
    }

    public void log(StructuredLogMessage message, String format) {
        StructuredLoggingInterceptor interceptor = StructuredLogger.getInterceptor(message.getClusterId().getDescription());
        if (interceptor != null) {
            interceptor.intercept(message);
        }
        switch (message.getLevel()) {
            case DEBUG: {
                if (!this.logger.isDebugEnabled()) break;
                Throwable exception = message.getException();
                if (exception == null) {
                    this.logger.debug(String.format(format, message.getEntries().stream().map(StructuredLogMessage.Entry::getValue).toArray()));
                    break;
                }
                this.logger.debug(String.format(format, message.getEntries().stream().map(StructuredLogMessage.Entry::getValue).toArray()), exception);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

