/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.model.bulk;

import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.lang.Nullable;
import java.util.Optional;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public final class ConcreteClientBulkWriteOptions
implements ClientBulkWriteOptions {
    private static final Boolean CLIENT_DEFAULT_ORDERED = true;
    private static final Boolean CLIENT_DEFAULT_VERBOSE_RESULTS = false;
    @Nullable
    private Boolean ordered;
    @Nullable
    private Boolean bypassDocumentValidation;
    @Nullable
    private Bson let;
    @Nullable
    private BsonValue comment;
    @Nullable
    private Boolean verboseResults;

    @Override
    public ClientBulkWriteOptions ordered(@Nullable Boolean ordered) {
        this.ordered = ordered;
        return this;
    }

    public boolean isOrdered() {
        return this.ordered == null ? CLIENT_DEFAULT_ORDERED : this.ordered;
    }

    @Override
    public ClientBulkWriteOptions bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public Optional<Boolean> isBypassDocumentValidation() {
        return Optional.ofNullable(this.bypassDocumentValidation);
    }

    @Override
    public ClientBulkWriteOptions let(@Nullable Bson let) {
        this.let = let;
        return this;
    }

    public Optional<Bson> getLet() {
        return Optional.ofNullable(this.let);
    }

    @Override
    public ClientBulkWriteOptions comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public Optional<BsonValue> getComment() {
        return Optional.ofNullable(this.comment);
    }

    @Override
    public ClientBulkWriteOptions verboseResults(@Nullable Boolean verboseResults) {
        this.verboseResults = verboseResults;
        return this;
    }

    public boolean isVerboseResults() {
        return this.verboseResults == null ? CLIENT_DEFAULT_VERBOSE_RESULTS : this.verboseResults;
    }

    public String toString() {
        return "ClientBulkWriteOptions{ordered=" + this.ordered + ", bypassDocumentValidation=" + this.bypassDocumentValidation + ", let=" + this.let + ", comment=" + this.comment + ", verboseResults=" + this.verboseResults + '}';
    }
}

