/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.validator;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import java.util.Arrays;
import java.util.List;
import org.bson.FieldNameValidator;

public final class ReplacingDocumentFieldNameValidator
implements FieldNameValidator {
    public static final ReplacingDocumentFieldNameValidator INSTANCE = new ReplacingDocumentFieldNameValidator();
    private static final List<String> EXCEPTIONS = Arrays.asList("$db", "$ref", "$id");

    private ReplacingDocumentFieldNameValidator() {
    }

    public boolean validate(String fieldName) {
        return !fieldName.startsWith("$") || EXCEPTIONS.contains(fieldName);
    }

    public String getValidationErrorMessage(String fieldName) {
        Assertions.assertFalse(this.validate(fieldName));
        return String.format("Field names in a replacement document can not start with '$' but '%s' does", fieldName);
    }

    public FieldNameValidator getValidatorForField(String fieldName) {
        return NoOpFieldNameValidator.INSTANCE;
    }
}

