/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoDriverInformation;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.Clusters;
import com.mongodb.client.internal.MongoClientImpl;
import com.mongodb.connection.TransportSettings;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.ServerAddressHelper;
import com.mongodb.internal.connection.StreamFactoryFactory;
import com.mongodb.internal.connection.StreamFactoryHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.spi.dns.InetAddressResolver;

public final class MongoClients {
    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    public static MongoClient create(ConnectionString connectionString, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(MongoClientSettings.builder().applyConnectionString(connectionString).build(), mongoDriverInformation);
    }

    public static MongoClient create(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        Assertions.notNull((String)"settings", (Object)settings);
        MongoDriverInformation.Builder builder = mongoDriverInformation == null ? MongoDriverInformation.builder() : MongoDriverInformation.builder((MongoDriverInformation)mongoDriverInformation);
        MongoDriverInformation driverInfo = builder.driverName("sync").build();
        StreamFactoryFactory syncStreamFactoryFactory = StreamFactoryHelper.getSyncStreamFactoryFactory((TransportSettings)settings.getTransportSettings(), (InetAddressResolver)ServerAddressHelper.getInetAddressResolver((MongoClientSettings)settings));
        Cluster cluster = Clusters.createCluster(settings, driverInfo, syncStreamFactoryFactory);
        return new MongoClientImpl(cluster, settings, driverInfo, (AutoCloseable)syncStreamFactoryFactory);
    }

    private MongoClients() {
    }
}

