/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.config;

import com.mongodb.WriteConcern;
import com.mongodb.spark.sql.connector.config.AbstractMongoConfig;
import com.mongodb.spark.sql.connector.exceptions.ConfigException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class WriteConfig
extends AbstractMongoConfig {
    private static final long serialVersionUID = 1L;
    public static final String MAX_BATCH_SIZE_CONFIG = "maxBatchSize";
    private static final int MAX_BATCH_SIZE_DEFAULT = 512;
    public static final String ORDERED_BULK_OPERATION_CONFIG = "ordered";
    private static final boolean ORDERED_BULK_OPERATION_DEFAULT = true;
    public static final String OPERATION_TYPE_CONFIG = "operationType";
    private static final OperationType OPERATION_TYPE_DEFAULT = OperationType.REPLACE;
    public static final String ID_FIELD_CONFIG = "idFieldList";
    private static final List<String> ID_FIELD_DEFAULT = Collections.singletonList("_id");
    public static final String WRITE_CONCERN_W_CONFIG = "writeConcern.w";
    public static final String WRITE_CONCERN_JOURNAL_CONFIG = "writeConcern.journal";
    public static final String WRITE_CONCERN_W_TIMEOUT_MS_CONFIG = "writeConcern.wTimeoutMS";
    public static final String UPSERT_DOCUMENT_CONFIG = "upsertDocument";
    private static final boolean UPSERT_DOCUMENT_DEFAULT = true;
    public static final String CONVERT_JSON_CONFIG = "convertJson";
    private static final boolean CONVERT_JSON_DEFAULT = false;
    private final WriteConcern writeConcern = this.createWriteConcern();
    private final OperationType operationType = OperationType.fromString(this.getOrDefault("operationType", OperationType.access$000(OPERATION_TYPE_DEFAULT)));

    WriteConfig(Map<String, String> options) {
        super(options, AbstractMongoConfig.UsageMode.WRITE);
    }

    @Override
    public WriteConfig withOption(String key, String value) {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put(key, value);
        return this.withOptions(options);
    }

    @Override
    public WriteConfig withOptions(Map<String, String> options) {
        if (options.isEmpty()) {
            return this;
        }
        return new WriteConfig(this.withOverrides("spark.mongodb.write.", options));
    }

    public int getMaxBatchSize() {
        return this.getInt(MAX_BATCH_SIZE_CONFIG, 512);
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public List<String> getIdFields() {
        return this.getList(ID_FIELD_CONFIG, ID_FIELD_DEFAULT);
    }

    public boolean isOrdered() {
        return this.getBoolean(ORDERED_BULK_OPERATION_CONFIG, true);
    }

    public boolean isUpsert() {
        return this.getBoolean(UPSERT_DOCUMENT_CONFIG, true);
    }

    public boolean convertJson() {
        return this.getBoolean(CONVERT_JSON_CONFIG, false);
    }

    private WriteConcern createWriteConcern() {
        WriteConcern writeConcern = WriteConcern.ACKNOWLEDGED;
        try {
            if (this.containsKey(WRITE_CONCERN_W_CONFIG)) {
                try {
                    writeConcern = writeConcern.withW(this.getInt(WRITE_CONCERN_W_CONFIG, -1));
                }
                catch (ConfigException e) {
                    writeConcern = writeConcern.withW(this.get(WRITE_CONCERN_W_CONFIG));
                }
            }
            if (this.containsKey(WRITE_CONCERN_JOURNAL_CONFIG)) {
                writeConcern = writeConcern.withJournal(Boolean.valueOf(this.getBoolean(WRITE_CONCERN_JOURNAL_CONFIG, false)));
            }
            if (this.containsKey(WRITE_CONCERN_W_TIMEOUT_MS_CONFIG)) {
                writeConcern = writeConcern.withWTimeout((long)this.getInt(WRITE_CONCERN_W_TIMEOUT_MS_CONFIG, -1), TimeUnit.MILLISECONDS);
            }
        }
        catch (RuntimeException e) {
            throw new ConfigException("Invalid write concern configuration.", e);
        }
        return writeConcern;
    }

    public static enum OperationType {
        INSERT("insert"),
        REPLACE("replace"),
        UPDATE("update");

        private final String value;

        private OperationType(String operationType) {
            this.value = operationType;
        }

        static OperationType fromString(String operationType) {
            for (OperationType writeOperationType : OperationType.values()) {
                if (!operationType.equalsIgnoreCase(writeOperationType.value)) continue;
                return writeOperationType;
            }
            throw new ConfigException(String.format("'%s' is not a valid Write Operation Type", operationType));
        }

        public String toString() {
            return this.value;
        }

        static /* synthetic */ String access$000(OperationType x0) {
            return x0.value;
        }
    }
}

