/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.connection;

import com.mongodb.ConnectionString;
import com.mongodb.MongoDriverInformation;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.spark.sql.connector.config.MongoConfig;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.connection.MongoClientFactory;
import java.util.Objects;
import org.apache.spark.package$;
import org.jetbrains.annotations.ApiStatus;
import scala.util.Properties;

@ApiStatus.Internal
public final class DefaultMongoClientFactory
implements MongoClientFactory {
    private final MongoConfig config;
    private final MongoDriverInformation mongoDriverInformation;

    public DefaultMongoClientFactory(MongoConfig config) {
        this.config = config;
        this.mongoDriverInformation = DefaultMongoClientFactory.generateMongoDriverInformation(config instanceof ReadConfig ? "source" : "sink");
    }

    @Override
    public MongoClient create() {
        return MongoClients.create((ConnectionString)this.config.getConnectionString(), (MongoDriverInformation)this.mongoDriverInformation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultMongoClientFactory that = (DefaultMongoClientFactory)o;
        return this.config.equals(that.config) && Objects.equals(this.mongoDriverInformation, that.mongoDriverInformation);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.mongoDriverInformation);
    }

    private static MongoDriverInformation generateMongoDriverInformation(String configType) {
        return MongoDriverInformation.builder().driverName("mongo-spark-connector|" + configType).driverVersion("10.1.1").driverPlatform("Scala/" + Properties.versionNumberString() + "/Spark/" + package$.MODULE$.SPARK_VERSION()).build();
    }
}

