/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoBatchPartitionReaderFactory;
import com.mongodb.spark.sql.connector.read.MongoInputPartitionHelper;
import com.mongodb.spark.sql.connector.schema.BsonDocumentToRowConverter;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.types.StructType;

final class MongoBatch
implements Batch {
    private final StructType schema;
    private final ReadConfig readConfig;
    private final BsonDocumentToRowConverter bsonDocumentToRowConverter;

    MongoBatch(StructType schema, ReadConfig readConfig) {
        this.schema = schema;
        this.readConfig = readConfig;
        this.bsonDocumentToRowConverter = new BsonDocumentToRowConverter(schema, readConfig.outputExtendedJson());
    }

    public InputPartition[] planInputPartitions() {
        return MongoInputPartitionHelper.generateMongoBatchPartitions(this.schema, this.readConfig);
    }

    public PartitionReaderFactory createReaderFactory() {
        return new MongoBatchPartitionReaderFactory(this.bsonDocumentToRowConverter, this.readConfig);
    }
}

