/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoBatchPartitionReader;
import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import com.mongodb.spark.sql.connector.schema.BsonDocumentToRowConverter;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;

final class MongoBatchPartitionReaderFactory
implements PartitionReaderFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BsonDocumentToRowConverter bsonDocumentToRowConverter;
    private final ReadConfig readConfig;

    MongoBatchPartitionReaderFactory(BsonDocumentToRowConverter bsonDocumentToRowConverter, ReadConfig readConfig) {
        this.bsonDocumentToRowConverter = bsonDocumentToRowConverter;
        this.readConfig = readConfig;
    }

    public PartitionReader<InternalRow> createReader(InputPartition partition) {
        Assertions.ensureState(() -> partition instanceof MongoInputPartition, () -> String.format("Unsupported InputPartition type, a MongoInputPartition instance is required. Got: %s", partition.getClass()));
        return new MongoBatchPartitionReader((MongoInputPartition)partition, this.bsonDocumentToRowConverter, this.readConfig);
    }
}

