/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import com.mongodb.spark.sql.connector.read.ResumeTokenPartitionOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bson.BsonDocument;

final class MongoContinuousInputPartition
extends MongoInputPartition {
    private static final long serialVersionUID = 1L;
    private final ResumeTokenPartitionOffset resumeTokenPartitionOffset;

    MongoContinuousInputPartition(int partitionId, List<BsonDocument> pipeline, ResumeTokenPartitionOffset resumeTokenPartitionOffset) {
        super(partitionId, pipeline);
        this.resumeTokenPartitionOffset = resumeTokenPartitionOffset;
    }

    ResumeTokenPartitionOffset getResumeTokenPartitionOffset() {
        return this.resumeTokenPartitionOffset;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MongoContinuousInputPartition that = (MongoContinuousInputPartition)o;
        return Objects.equals(this.resumeTokenPartitionOffset, that.resumeTokenPartitionOffset);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resumeTokenPartitionOffset);
    }

    @Override
    public String toString() {
        return "MongoContinuousInputPartition{partitionId=" + this.getPartitionId() + ", pipeline=" + this.getPipeline().stream().map(BsonDocument::toJson).collect(Collectors.joining(",", "[", "]")) + ", preferredLocations=" + Arrays.toString(this.preferredLocations()) + "resumeTokenPartitionOffset=" + this.resumeTokenPartitionOffset + "} ";
    }
}

