/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.spark.sql.connector.read.InputPartition;
import org.bson.BsonDocument;

public class MongoInputPartition
implements InputPartition {
    private static final long serialVersionUID = 1L;
    private final int partitionId;
    private final List<BsonDocument> pipeline;
    private final List<String> preferredLocations;

    public MongoInputPartition(int partitionId, List<BsonDocument> pipeline) {
        this(partitionId, pipeline, Collections.emptyList());
    }

    public MongoInputPartition(int partitionId, List<BsonDocument> pipeline, List<String> preferredLocations) {
        this.partitionId = partitionId;
        this.pipeline = pipeline;
        this.preferredLocations = preferredLocations;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    public List<String> getPreferredLocations() {
        return this.preferredLocations;
    }

    public String[] preferredLocations() {
        return this.preferredLocations.toArray(new String[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoInputPartition that = (MongoInputPartition)o;
        return this.partitionId == that.partitionId && Objects.equals(this.pipeline, that.pipeline) && Objects.equals(this.preferredLocations, that.preferredLocations);
    }

    public int hashCode() {
        return Objects.hash(this.partitionId, this.pipeline, this.preferredLocations);
    }

    public String toString() {
        return "MongoInputPartition{partitionId=" + this.partitionId + ", pipeline=" + this.pipeline.stream().map(BsonDocument::toJson).collect(Collectors.joining(",", "[", "]")) + ", preferredLocations=" + this.preferredLocations + '}';
    }
}

