/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.exceptions.MongoSparkException;
import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import com.mongodb.spark.sql.connector.read.partitioner.Partitioner;
import com.mongodb.spark.sql.connector.read.partitioner.PartitionerHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.spark.sql.types.StructType;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;

final class MongoInputPartitionHelper {
    static MongoInputPartition[] generateMongoBatchPartitions(StructType schema, ReadConfig readConfig) {
        try {
            Partitioner partitioner = readConfig.getPartitioner();
            Partitioner.LOGGER.debug("Generating partitions using '{}'.", (Object)partitioner.getClass().getSimpleName());
            List<MongoInputPartition> mongoInputPartitions = partitioner.generatePartitions(readConfig);
            if (mongoInputPartitions.isEmpty()) {
                Partitioner.LOGGER.warn("Partitioner '{}' failed to create any partitions. Falling back to a single partition for the collection", (Object)partitioner.getClass().getSimpleName());
                mongoInputPartitions = PartitionerHelper.SINGLE_PARTITIONER.generatePartitions(readConfig);
            } else {
                Partitioner.LOGGER.debug("Partitioner '{}' created {} partition(s).", (Object)partitioner.getClass().getSimpleName(), (Object)mongoInputPartitions.size());
            }
            List<MongoInputPartition> partitions = mongoInputPartitions;
            return MongoInputPartitionHelper.schemaProjections(schema, readConfig.streamPublishFullDocumentOnly()).map(schemaProjection -> {
                ArrayList partitionsWithProjection = new ArrayList(partitions.size());
                partitions.forEach(p -> partitionsWithProjection.add(new MongoInputPartition(p.getPartitionId(), MongoInputPartitionHelper.mergePipelineFunction(p.getPipeline()).apply((BsonDocument)schemaProjection), p.getPreferredLocations())));
                return partitionsWithProjection;
            }).orElse(mongoInputPartitions).toArray(new MongoInputPartition[0]);
        }
        catch (RuntimeException ex) {
            throw new MongoSparkException("Partitioning failed. " + ex.getMessage(), ex);
        }
    }

    static List<BsonDocument> generatePipeline(StructType schema, ReadConfig readConfig) {
        return MongoInputPartitionHelper.schemaProjections(schema, readConfig.streamPublishFullDocumentOnly()).map(MongoInputPartitionHelper.mergePipelineFunction(readConfig.getAggregationPipeline())).orElse(readConfig.getAggregationPipeline());
    }

    private static Optional<BsonDocument> schemaProjections(StructType schema, boolean streamPublishFullDocumentOnly) {
        if (schema.isEmpty()) {
            return Optional.empty();
        }
        String fieldPrefix = streamPublishFullDocumentOnly ? "fullDocument." : "";
        BsonDocument projections = new BsonDocument();
        Arrays.stream(schema.fields()).map(f -> fieldPrefix + f.name()).forEach(f -> projections.append(f, (BsonValue)new BsonInt32(1)));
        return Optional.of(new BsonDocument("$project", (BsonValue)projections));
    }

    private static Function<BsonDocument, List<BsonDocument>> mergePipelineFunction(List<BsonDocument> pipeline) {
        return projectionStage -> {
            ArrayList<BsonDocument> pipelineWithSchemaProjection = new ArrayList<BsonDocument>(pipeline);
            pipelineWithSchemaProjection.add((BsonDocument)projectionStage);
            return pipelineWithSchemaProjection;
        };
    }

    private MongoInputPartitionHelper() {
    }
}

