/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoMicroBatchInputPartition;
import com.mongodb.spark.sql.connector.read.MongoMicroBatchPartitionReader;
import com.mongodb.spark.sql.connector.schema.BsonDocumentToRowConverter;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;

final class MongoMicroBatchPartitionReaderFactory
implements PartitionReaderFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BsonDocumentToRowConverter bsonDocumentToRowConverter;
    private final ReadConfig readConfig;

    MongoMicroBatchPartitionReaderFactory(BsonDocumentToRowConverter bsonDocumentToRowConverter, ReadConfig readConfig) {
        this.bsonDocumentToRowConverter = bsonDocumentToRowConverter;
        this.readConfig = readConfig;
    }

    public PartitionReader<InternalRow> createReader(InputPartition partition) {
        Assertions.ensureState(() -> partition instanceof MongoMicroBatchInputPartition, () -> String.format("Unsupported InputPartition type, a MongoMicroBatchInputPartition instance is required. Got: %s", partition.getClass()));
        return new MongoMicroBatchPartitionReader((MongoMicroBatchInputPartition)partition, this.bsonDocumentToRowConverter, this.readConfig);
    }
}

