/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read;

import com.mongodb.spark.sql.connector.exceptions.MongoSparkException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;

final class ResumeTokenTimestampHelper {
    static BsonTimestamp getTimestamp(BsonDocument resumeToken) {
        if (!resumeToken.containsKey((Object)"_data")) {
            throw new MongoSparkException("Invalid resume token, missing `_data` field");
        }
        BsonValue data = resumeToken.get((Object)"_data");
        if (!data.isString()) {
            throw new MongoSparkException("Invalid resume token, expected string value for `_data` field, but found: " + data.getBsonType().name());
        }
        byte[] bytes = ResumeTokenTimestampHelper.hexStringToBytes(data.asString().getValue());
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN);
        int canonicalType = byteBuffer.get() & 0xFF;
        if (canonicalType != 130) {
            throw new MongoSparkException("Invalid resume token, expected _data field canonical type to equal 130, but found: " + canonicalType);
        }
        long timestampAsLong = byteBuffer.asLongBuffer().get();
        return new BsonTimestamp(timestampAsLong);
    }

    static byte[] hexStringToBytes(String hexString) {
        int len = hexString.length();
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return bytes;
    }

    private ResumeTokenTimestampHelper() {
    }
}

