/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read.partitioner;

import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.exceptions.MongoSparkException;
import com.mongodb.spark.sql.connector.read.partitioner.Partitioner;
import com.mongodb.spark.sql.connector.read.partitioner.SinglePartitionPartitioner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public final class PartitionerHelper {
    private static final List<BsonDocument> COLL_STATS_AGGREGATION_PIPELINE = Collections.singletonList(BsonDocument.parse((String)"{'$collStats': {'storageStats': { } } }"));
    private static final BsonDocument PING_COMMAND = BsonDocument.parse((String)"{ping: 1}");
    public static final Partitioner SINGLE_PARTITIONER = new SinglePartitionPartitioner();

    public static BsonDocument matchQuery(List<BsonDocument> userPipeline) {
        BsonDocument firstPipelineStage = userPipeline.isEmpty() ? new BsonDocument() : userPipeline.get(0);
        return firstPipelineStage.getDocument((Object)"$match", new BsonDocument());
    }

    public static BsonDocument createPartitionBounds(BsonValue lower, BsonValue upper) {
        BsonDocument partitionBoundary = new BsonDocument();
        if (lower.getBsonType() != BsonType.MIN_KEY) {
            partitionBoundary.append("$gte", lower);
        }
        if (upper.getBsonType() != BsonType.MAX_KEY) {
            partitionBoundary.append("$lt", upper);
        }
        return partitionBoundary;
    }

    public static List<BsonDocument> createPartitionPipeline(BsonDocument partitionBounds, List<BsonDocument> userPipeline) {
        ArrayList<BsonDocument> partitionPipeline = new ArrayList<BsonDocument>();
        partitionPipeline.add(new BsonDocument("$match", (BsonValue)partitionBounds));
        partitionPipeline.addAll(userPipeline);
        return partitionPipeline;
    }

    public static BsonDocument storageStats(ReadConfig readConfig) {
        Partitioner.LOGGER.info("Getting collection stats for: {}", (Object)readConfig.getNamespace().getFullName());
        try {
            return ((BsonDocument)readConfig.withCollection(coll -> Optional.ofNullable((BsonDocument)coll.aggregate(COLL_STATS_AGGREGATION_PIPELINE).allowDiskUse(Boolean.valueOf(readConfig.getAggregationAllowDiskUse())).first()).orElseGet(BsonDocument::new))).getDocument((Object)"storageStats", new BsonDocument());
        }
        catch (RuntimeException ex) {
            if (ex instanceof MongoCommandException && (ex.getMessage().contains("not found.") || ((MongoCommandException)ex).getCode() == 26)) {
                Partitioner.LOGGER.info("Could not find collection: {}", (Object)readConfig.getCollectionName());
                return new BsonDocument();
            }
            throw new MongoSparkException("Partitioner calling collStats command failed", ex);
        }
    }

    public static List<String> getPreferredLocations(ReadConfig readConfig) {
        return ((ClusterDescription)readConfig.withClient(c -> {
            MongoDatabase db = c.getDatabase(readConfig.getDatabaseName());
            db.runCommand((Bson)PING_COMMAND, db.getReadPreference());
            return c.getClusterDescription();
        })).getServerDescriptions().stream().flatMap(sd -> sd.getHosts().stream()).distinct().collect(Collectors.toList());
    }

    private PartitionerHelper() {
    }
}

