/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.schema;

import com.mongodb.spark.sql.connector.exceptions.DataException;
import com.mongodb.spark.sql.connector.interop.JavaScala;
import com.mongodb.spark.sql.connector.schema.ConverterHelper;
import com.mongodb.spark.sql.connector.schema.RowToInternalRowFunction;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.bson.BsonArray;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.BsonNumber;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.EncoderContext;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.bson.json.JsonWriterSettings;
import org.bson.types.Decimal128;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import scala.collection.Map;

@NotNull
public final class BsonDocumentToRowConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Function<Row, InternalRow> rowToInternalRowFunction;
    private final StructType schema;
    private final boolean outputExtendedJson;

    public BsonDocumentToRowConverter(StructType schema, boolean outputExtendedJson) {
        this.schema = schema;
        this.rowToInternalRowFunction = new RowToInternalRowFunction(schema);
        this.outputExtendedJson = outputExtendedJson;
    }

    public StructType getSchema() {
        return this.schema;
    }

    @VisibleForTesting
    GenericRowWithSchema toRow(BsonDocument bsonDocument) {
        return this.convertToRow("", this.schema, (BsonValue)bsonDocument);
    }

    public InternalRow toInternalRow(BsonDocument bsonDocument) {
        return this.rowToInternalRowFunction.apply((Row)this.toRow(bsonDocument));
    }

    @VisibleForTesting
    Object convertBsonValue(String fieldName, DataType dataType, BsonValue bsonValue) {
        if (bsonValue.isNull()) {
            return null;
        }
        if (dataType instanceof StructType) {
            return this.convertToRow(fieldName, (StructType)dataType, bsonValue);
        }
        if (dataType instanceof MapType) {
            return this.convertToMap(fieldName, (MapType)dataType, bsonValue);
        }
        if (dataType instanceof ArrayType) {
            return this.convertToArray(fieldName, (ArrayType)dataType, bsonValue);
        }
        if (dataType instanceof BinaryType) {
            return this.convertToBinary(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof BooleanType) {
            return this.convertToBoolean(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof DateType) {
            return this.convertToTimestamp(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof TimestampType) {
            return this.convertToTimestamp(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(this.convertToFloat(fieldName, dataType, bsonValue));
        }
        if (dataType instanceof IntegerType) {
            return this.convertToInteger(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof DoubleType) {
            return this.convertToDouble(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof ShortType) {
            return this.convertToShort(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof ByteType) {
            return this.convertToByte(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof LongType) {
            return this.convertToLong(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof DecimalType) {
            return this.convertToDecimal(fieldName, dataType, bsonValue);
        }
        if (dataType instanceof StringType) {
            return this.convertToString(bsonValue);
        }
        if (dataType instanceof NullType) {
            return null;
        }
        throw BsonDocumentToRowConverter.invalidFieldData(fieldName, dataType, bsonValue);
    }

    private JsonWriterSettings getJsonWriterSettings() {
        return this.outputExtendedJson ? ConverterHelper.EXTENDED_JSON_WRITER_SETTINGS : ConverterHelper.RELAXED_JSON_WRITER_SETTINGS;
    }

    private GenericRowWithSchema convertToRow(String fieldName, StructType dataType, BsonValue bsonValue) {
        BsonDocumentToRowConverter.ensureFieldData(() -> ((BsonValue)bsonValue).isDocument(), () -> BsonDocumentToRowConverter.invalidFieldData(fieldName, (DataType)dataType, bsonValue));
        BsonDocument bsonDocument = bsonValue.asDocument();
        ArrayList<Object> values = new ArrayList<Object>();
        for (StructField field : dataType.fields()) {
            boolean hasField = bsonDocument.containsKey((Object)field.name());
            String fullFieldPath = this.createFieldPath(fieldName, field.name());
            if (!hasField && !field.nullable()) {
                throw this.missingFieldException(fullFieldPath, bsonDocument);
            }
            values.add(hasField ? this.convertBsonValue(fullFieldPath, field.dataType(), bsonDocument.get((Object)field.name())) : null);
        }
        return new GenericRowWithSchema(values.toArray(), dataType);
    }

    private Map<String, ?> convertToMap(String fieldName, MapType dataType, BsonValue bsonValue) {
        BsonDocumentToRowConverter.ensureFieldData(() -> ((BsonValue)bsonValue).isDocument(), () -> BsonDocumentToRowConverter.invalidFieldData(fieldName, (DataType)dataType, bsonValue));
        BsonDocumentToRowConverter.ensureFieldData(() -> dataType.keyType() instanceof StringType, () -> BsonDocumentToRowConverter.invalidFieldData(fieldName, (DataType)dataType, bsonValue, " Map keys must be strings."));
        HashMap map = new HashMap();
        bsonValue.asDocument().forEach((k, v) -> map.put(k, this.convertBsonValue(this.createFieldPath(fieldName, (String)k), dataType.valueType(), (BsonValue)v)));
        return JavaScala.asScala(map);
    }

    private Object[] convertToArray(String fieldName, ArrayType dataType, BsonValue bsonValue) {
        if (!bsonValue.isArray()) {
            throw BsonDocumentToRowConverter.invalidFieldData(fieldName, (DataType)dataType, bsonValue);
        }
        BsonArray bsonArray = bsonValue.asArray();
        ArrayList<Object> arrayList = new ArrayList<Object>(bsonArray.size());
        for (int i = 0; i < bsonArray.size(); ++i) {
            arrayList.add(this.convertBsonValue(this.createFieldPath(fieldName, String.valueOf(i)), dataType.elementType(), bsonArray.get(i)));
        }
        return arrayList.toArray();
    }

    private byte[] convertToBinary(String fieldName, DataType dataType, BsonValue bsonValue) {
        switch (bsonValue.getBsonType()) {
            case STRING: {
                return bsonValue.asString().getValue().trim().getBytes(StandardCharsets.UTF_8);
            }
            case BINARY: {
                return bsonValue.asBinary().getData();
            }
            case DOCUMENT: {
                return BsonDocumentToRowConverter.documentToByteArray(bsonValue.asDocument());
            }
        }
        throw BsonDocumentToRowConverter.invalidFieldData(fieldName, dataType, bsonValue);
    }

    private boolean convertToBoolean(String fieldName, DataType dataType, BsonValue bsonValue) {
        if (!bsonValue.isBoolean()) {
            throw BsonDocumentToRowConverter.invalidFieldData(fieldName, dataType, bsonValue);
        }
        return bsonValue.asBoolean().getValue();
    }

    private Timestamp convertToTimestamp(String fieldName, DataType dataType, BsonValue bsonValue) {
        return new Timestamp(this.convertToLong(fieldName, dataType, bsonValue));
    }

    private float convertToFloat(String fieldName, DataType dataType, BsonValue bsonValue) {
        return (float)this.convertToBsonNumber(fieldName, dataType, bsonValue).doubleValue();
    }

    private double convertToDouble(String fieldName, DataType dataType, BsonValue bsonValue) {
        return this.convertToBsonNumber(fieldName, dataType, bsonValue).doubleValue();
    }

    private int convertToInteger(String fieldName, DataType dataType, BsonValue bsonValue) {
        return this.convertToBsonNumber(fieldName, dataType, bsonValue).intValue();
    }

    private short convertToShort(String fieldName, DataType dataType, BsonValue bsonValue) {
        return (short)this.convertToBsonNumber(fieldName, dataType, bsonValue).intValue();
    }

    private long convertToLong(String fieldName, DataType dataType, BsonValue bsonValue) {
        return this.convertToBsonNumber(fieldName, dataType, bsonValue).longValue();
    }

    private BigDecimal convertToDecimal(String fieldName, DataType dataType, BsonValue bsonValue) {
        BsonNumber bsonNumber = this.convertToBsonNumber(fieldName, dataType, bsonValue);
        switch (bsonNumber.getBsonType()) {
            case DOUBLE: {
                return BigDecimal.valueOf(bsonNumber.doubleValue());
            }
            case INT32: 
            case INT64: {
                return BigDecimal.valueOf(bsonNumber.longValue());
            }
        }
        return bsonNumber.decimal128Value().bigDecimalValue();
    }

    private byte convertToByte(String fieldName, DataType dataType, BsonValue bsonValue) {
        return (byte)this.convertToBsonNumber(fieldName, dataType, bsonValue).longValue();
    }

    private String convertToString(BsonValue bsonValue) {
        switch (bsonValue.getBsonType()) {
            case STRING: {
                return bsonValue.asString().getValue();
            }
            case DOCUMENT: {
                return bsonValue.asDocument().toJson(this.getJsonWriterSettings());
            }
        }
        String value = new BsonDocument("v", bsonValue).toJson(this.getJsonWriterSettings());
        value = value.substring(6, value.length() - 1);
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }

    private BsonNumber convertToBsonNumber(String fieldName, DataType dataType, BsonValue bsonValue) {
        switch (bsonValue.getBsonType()) {
            case DATE_TIME: {
                return new BsonInt64(bsonValue.asDateTime().getValue());
            }
            case TIMESTAMP: {
                return new BsonInt64(TimeUnit.SECONDS.toMillis(bsonValue.asTimestamp().getTime()));
            }
            case STRING: {
                try {
                    return new BsonDecimal128(Decimal128.parse((String)this.convertToString(bsonValue)));
                }
                catch (NumberFormatException e) {
                    throw BsonDocumentToRowConverter.invalidFieldData(fieldName, dataType, bsonValue);
                }
            }
        }
        if (bsonValue instanceof BsonNumber) {
            return (BsonNumber)bsonValue;
        }
        throw BsonDocumentToRowConverter.invalidFieldData(fieldName, dataType, bsonValue);
    }

    private String createFieldPath(String currentLevel, String subLevel) {
        return currentLevel.isEmpty() ? subLevel : String.format("%s.%s", currentLevel, subLevel);
    }

    private static void ensureFieldData(Supplier<Boolean> isValid, Supplier<DataException> errorSupplier) {
        if (!isValid.get().booleanValue()) {
            throw errorSupplier.get();
        }
    }

    private static DataException invalidFieldData(String fieldName, DataType dataType, BsonValue bsonValue) {
        return BsonDocumentToRowConverter.invalidFieldData(fieldName, dataType, bsonValue, "");
    }

    private static DataException invalidFieldData(String fieldName, DataType dataType, BsonValue bsonValue, String extraMessage) {
        return new DataException(String.format("Invalid field: '%s'. The dataType '%s' is invalid for '%s'.%s", fieldName, dataType.typeName(), bsonValue, extraMessage));
    }

    private DataException missingFieldException(String fieldPath, BsonDocument value) {
        return new DataException(String.format("Missing field '%s' in: '%s'", fieldPath, value.toJson(this.getJsonWriterSettings())));
    }

    @VisibleForTesting
    static byte[] documentToByteArray(BsonDocument document) {
        if (document instanceof RawBsonDocument) {
            RawBsonDocument rawBsonDocument = (RawBsonDocument)document;
            ByteBuffer byteBuffer = rawBsonDocument.getByteBuffer().asNIO();
            int startPosition = byteBuffer.position();
            int length = byteBuffer.limit() - startPosition;
            byte[] byteArray = new byte[length];
            System.arraycopy(byteBuffer.array(), startPosition, byteArray, 0, length);
            return byteArray;
        }
        BasicOutputBuffer buffer = new BasicOutputBuffer();
        try (BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)buffer);){
            ConverterHelper.BSON_VALUE_CODEC.encode((BsonWriter)writer, (Object)document, EncoderContext.builder().build());
        }
        return buffer.toByteArray();
    }

    public String toString() {
        return "BsonDocumentToRowConverter{schema=" + this.schema + '}';
    }
}

