/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.schema;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.MongoConfig;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import scala.Option;

@NotNull
public final class InferSchema {
    private static final StructType PLACE_HOLDER_STRUCT_TYPE = DataTypes.createStructType((StructField[])new StructField[0]);
    private static final DataType PLACE_HOLDER_DATA_TYPE = new DataType(){

        public int defaultSize() {
            return 0;
        }

        public DataType asNullable() {
            return PLACE_HOLDER_DATA_TYPE;
        }
    };
    static final ArrayType PLACE_HOLDER_ARRAY_TYPE = DataTypes.createArrayType((DataType)PLACE_HOLDER_DATA_TYPE);

    public static StructType inferSchema(CaseInsensitiveStringMap options) {
        MongoConfig readConfig = MongoConfig.readConfig(options.asCaseSensitiveMap()).withOptions(options.asCaseSensitiveMap());
        ArrayList<BsonDocument> samplePipeline = new ArrayList<BsonDocument>(((ReadConfig)readConfig).getAggregationPipeline());
        samplePipeline.add((BsonDocument)Aggregates.sample((int)((ReadConfig)readConfig).getInferSchemaSampleSize()));
        return InferSchema.inferSchema((List)((ReadConfig)readConfig).withCollection(arg_0 -> InferSchema.lambda$inferSchema$0(samplePipeline, (ReadConfig)readConfig, arg_0)), (ReadConfig)readConfig);
    }

    @VisibleForTesting
    static StructType inferSchema(List<BsonDocument> bsonDocuments, ReadConfig readConfig) {
        StructType structType = bsonDocuments.stream().map(d -> InferSchema.getStructType(d, readConfig)).reduce(PLACE_HOLDER_STRUCT_TYPE, (dt1, dt2) -> InferSchema.compatibleStructType(dt1, dt2, readConfig));
        return DataTypes.createStructType(Arrays.stream(structType.fields()).map(f -> {
            if (f.dataType().sameType((DataType)PLACE_HOLDER_ARRAY_TYPE)) {
                return DataTypes.createStructField((String)f.name(), (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType, (boolean)true), (boolean)f.nullable());
            }
            return f;
        }).collect(Collectors.toList()));
    }

    @NotNull
    private static StructType getStructType(BsonDocument bsonDocument, ReadConfig readConfig) {
        return (StructType)InferSchema.getDataType((BsonValue)bsonDocument, readConfig);
    }

    @VisibleForTesting
    static DataType getDataType(BsonValue bsonValue, ReadConfig readConfig) {
        switch (bsonValue.getBsonType()) {
            case DOCUMENT: {
                ArrayList fields = new ArrayList();
                bsonValue.asDocument().forEach((k, v) -> fields.add(new StructField(k, InferSchema.getDataType(v, readConfig), true, Metadata.empty())));
                return InferSchema.dataTypeCheckStructTypeToMapType((DataType)DataTypes.createStructType(fields), readConfig);
            }
            case ARRAY: {
                DataType elementType = bsonValue.asArray().stream().map(v -> InferSchema.getDataType(v, readConfig)).distinct().reduce((d1, d2) -> InferSchema.compatibleType(d1, d2, readConfig)).orElse(PLACE_HOLDER_DATA_TYPE);
                if (elementType.sameType(PLACE_HOLDER_DATA_TYPE)) {
                    return PLACE_HOLDER_ARRAY_TYPE;
                }
                return DataTypes.createArrayType((DataType)elementType, (boolean)true);
            }
            case SYMBOL: 
            case STRING: 
            case OBJECT_ID: {
                return DataTypes.StringType;
            }
            case BINARY: {
                return DataTypes.BinaryType;
            }
            case BOOLEAN: {
                return DataTypes.BooleanType;
            }
            case TIMESTAMP: 
            case DATE_TIME: {
                return DataTypes.TimestampType;
            }
            case NULL: {
                return DataTypes.NullType;
            }
            case DOUBLE: {
                return DataTypes.DoubleType;
            }
            case INT32: {
                return DataTypes.IntegerType;
            }
            case INT64: {
                return DataTypes.LongType;
            }
            case DECIMAL128: {
                BigDecimal bigDecimal = bsonValue.asDecimal128().decimal128Value().bigDecimalValue();
                return DataTypes.createDecimalType((int)Math.max(bigDecimal.precision(), bigDecimal.scale()), (int)bigDecimal.scale());
            }
        }
        return DataTypes.StringType;
    }

    private static StructType compatibleStructType(StructType structType1, StructType structType2, ReadConfig readConfig) {
        if (structType1 == PLACE_HOLDER_STRUCT_TYPE) {
            return structType2;
        }
        Map<String, List<StructField>> fieldNameToStructFieldMap = Stream.of(structType1.fields(), structType2.fields()).flatMap(Stream::of).collect(Collectors.groupingBy(StructField::name));
        ArrayList<StructField> structFields = new ArrayList<StructField>();
        fieldNameToStructFieldMap.forEach((fieldName, groupedStructFields) -> {
            DataType fieldCommonDataType = groupedStructFields.stream().map(StructField::dataType).reduce(PLACE_HOLDER_DATA_TYPE, (dt1, dt2) -> InferSchema.compatibleType(dt1, dt2, readConfig));
            structFields.add(DataTypes.createStructField((String)fieldName, (DataType)fieldCommonDataType, (boolean)true));
        });
        structFields.sort(Comparator.comparing(StructField::name));
        return DataTypes.createStructType(structFields);
    }

    private static DataType compatibleType(@Nullable DataType dataType1, DataType dataType2, ReadConfig readConfig) {
        if (dataType1 == PLACE_HOLDER_DATA_TYPE) {
            return dataType2;
        }
        DataType dataType = (DataType)((Option)TypeCoercion.findTightestCommonType().apply((Object)dataType1, (Object)dataType2)).getOrElse(() -> {
            if (dataType1 instanceof StructType && dataType2 instanceof StructType) {
                return InferSchema.compatibleStructType((StructType)dataType1, (StructType)dataType2, readConfig);
            }
            if (dataType1 instanceof ArrayType && dataType2 instanceof ArrayType) {
                return InferSchema.compatibleArrayType((ArrayType)dataType1, (ArrayType)dataType2, readConfig);
            }
            if (dataType1 instanceof DecimalType || dataType2 instanceof DecimalType) {
                return InferSchema.compatibleDecimalType(dataType1, dataType2);
            }
            if (dataType1 instanceof MapType && dataType2 instanceof StructType || dataType1 instanceof StructType && dataType2 instanceof MapType) {
                return InferSchema.appendStructToMap(dataType1, dataType2, readConfig);
            }
            return DataTypes.StringType;
        });
        return InferSchema.dataTypeCheckStructTypeToMapType(dataType, readConfig);
    }

    private static DataType compatibleArrayType(ArrayType arrayType1, ArrayType arrayType2, ReadConfig readConfig) {
        DataType arrayElementType1 = arrayType1.elementType();
        DataType arrayElementType2 = arrayType2.elementType();
        if (arrayElementType1 != PLACE_HOLDER_DATA_TYPE && arrayElementType2 != PLACE_HOLDER_DATA_TYPE) {
            return DataTypes.createArrayType((DataType)InferSchema.compatibleType(arrayElementType1, arrayElementType2, readConfig), (arrayType1.containsNull() || arrayType2.containsNull() ? 1 : 0) != 0);
        }
        if (arrayElementType1 == PLACE_HOLDER_DATA_TYPE && arrayElementType2 == PLACE_HOLDER_DATA_TYPE) {
            return DataTypes.createArrayType((DataType)DataTypes.StringType, (arrayType1.containsNull() || arrayType2.containsNull() ? 1 : 0) != 0);
        }
        if (arrayElementType1 != PLACE_HOLDER_DATA_TYPE) {
            return arrayType1;
        }
        return arrayType2;
    }

    private static DataType appendStructToMap(DataType dataType1, DataType dataType2, ReadConfig readConfig) {
        Assertions.ensureArgument(() -> dataType1 instanceof StructType && dataType2 instanceof MapType || dataType1 instanceof MapType && dataType2 instanceof StructType, () -> String.format("Requires a StructType and a MapType.  Got: %s, %s", dataType1.typeName(), dataType2.typeName()));
        StructType structType = dataType1 instanceof StructType ? (StructType)dataType1 : (StructType)dataType2;
        MapType mapType = dataType1 instanceof StructType ? (MapType)dataType2 : (MapType)dataType1;
        DataType valueType = Stream.concat(Stream.of(mapType.valueType()), Arrays.stream(structType.fields()).map(StructField::dataType)).reduce(PLACE_HOLDER_DATA_TYPE, (dt1, dt2) -> InferSchema.compatibleType(dt1, dt2, readConfig));
        return DataTypes.createMapType((DataType)mapType.keyType(), (DataType)valueType, (boolean)mapType.valueContainsNull());
    }

    private static DataType compatibleDecimalType(DataType dataType1, DataType dataType2) {
        DataType dataType;
        Assertions.ensureArgument(() -> dataType1 instanceof DecimalType || dataType2 instanceof DecimalType, () -> String.format("Neither datatype is an instance of DecimalType.  Got: %s, %s", dataType1.typeName(), dataType2.typeName()));
        DecimalType decimalType = dataType1 instanceof DecimalType ? (DecimalType)dataType1 : (DecimalType)dataType2;
        DataType dataType3 = dataType = dataType1 instanceof DecimalType ? dataType2 : dataType1;
        if (dataType instanceof DecimalType) {
            DecimalType decimalType2 = (DecimalType)dataType;
            int scale = Math.max(decimalType.scale(), decimalType2.scale());
            int range = Math.max(decimalType.precision() - decimalType.scale(), decimalType2.precision() - decimalType2.scale());
            if (range + scale > 38) {
                return DataTypes.DoubleType;
            }
            return DataTypes.createDecimalType((int)(range + scale), (int)scale);
        }
        if (dataType instanceof IntegerType) {
            return DataTypes.createDecimalType((int)10, (int)0);
        }
        if (dataType instanceof LongType) {
            return DataTypes.createDecimalType((int)20, (int)0);
        }
        if (dataType instanceof DoubleType) {
            return DataTypes.createDecimalType((int)30, (int)15);
        }
        return DataTypes.StringType;
    }

    private static DataType dataTypeCheckStructTypeToMapType(DataType dataType, ReadConfig readConfig) {
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            if (readConfig.inferSchemaMapType() && structType.fields().length >= readConfig.getInferSchemaMapTypeMinimumKeySize()) {
                DataType valueType = Arrays.stream(structType.fields()).map(StructField::dataType).reduce(PLACE_HOLDER_DATA_TYPE, (dt1, dt2) -> InferSchema.compatibleType(dt1, dt2, readConfig));
                return DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)valueType, (boolean)true);
            }
        }
        return dataType;
    }

    private InferSchema() {
    }

    private static /* synthetic */ ArrayList lambda$inferSchema$0(ArrayList samplePipeline, ReadConfig readConfig, MongoCollection coll) {
        return (ArrayList)coll.aggregate((List)samplePipeline).allowDiskUse(Boolean.valueOf(readConfig.getAggregationAllowDiskUse())).into(new ArrayList());
    }
}

